﻿---
title: Service Account Token or Certificate Read Detected via Defend for Containers
description: This rule detects the reading of the service account token or certificate inside a container. The service account token or certificate is used to authenticate...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/cloud_defend/credential_access_service_account_token_or_cert_read
products:
  - Elastic Security
---

# Service Account Token or Certificate Read Detected via Defend for Containers
This rule detects the reading of the service account token or certificate inside a container. The service account
token or certificate is used to authenticate the container to the Kubernetes API server, and may be used by an
adversary to gain access to the Kubernetes API server or other resources within the cluster. These files are a
common target for adversaries to gain access to the cluster.
**Rule type**: eql
**Rule indices**:
- logs-cloud_defend.file*
- logs-cloud_defend.process*

**Rule Severity**: medium
**Risk Score**: 47
**Runs every**: 5m
**Searches indices from**: `now-6m`
**Maximum alerts per execution**: 100
**References**:
**Tags**:
- Data Source: Elastic Defend for Containers
- Domain: Container
- OS: Linux
- Use Case: Threat Detection
- Tactic: Credential Access
- Resources: Investigation Guide

**Version**: 2
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Investigation guide


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating Service Account Token or Certificate Read Detected via Defend for Containers

This rule flags when a container’s service account token or CA certificate is opened interactively, signaling direct access to credentials that grant API permissions within the cluster. Attackers often exec into a running pod, read /var/run/secrets/kubernetes.io/serviceaccount/token and ca.crt, then use the token with kubectl or curl to enumerate namespaces, list secrets, or spawn privileged workloads via the Kubernetes API.

### Possible investigation steps

- Map the container to its pod, namespace, node, image, and service account, and use Kubernetes audit and runtime logs to identify any recent exec/attach/tty into the pod and the originating user and source IP.
- Examine process ancestry and command activity around the event to detect shells, kubectl/curl/wget usage, token exfiltration patterns (for example, piping the token to a network client), or the token being copied elsewhere.
- Correlate with network telemetry to see if the container initiated connections to the API server or external endpoints immediately after the read, including unusual DNS lookups or spikes in egress.
- Search Kubernetes audit logs for requests authenticated as the implicated service account after the event, prioritizing secrets access, pod exec/attach, workload create/update, and role or clusterrole binding changes, and verify the source IP matches the pod.
- Run a SubjectAccessReview or review RBAC bindings for the service account to quickly determine effective permissions and the potential blast radius if the token was abused.


### False positive analysis

- During legitimate troubleshooting, an engineer attaches an interactive shell to the container and opens /var/run/secrets/kubernetes.io/serviceaccount/token or /var/run/secrets/kubernetes.io/serviceaccount/ca.crt to verify the service account mount and certificate trust.
- An interactive in-container diagnostic or training session reads the token or CA certificate to confirm connectivity or inspect claims, with no subsequent API calls or credential exfiltration, resulting in a benign open event.


### Response and remediation

- Immediately delete the affected pod (namespace/pod-name) to invalidate /var/run/secrets/kubernetes.io/serviceaccount/token, scale the owning Deployment/StatefulSet to zero to stop respawns, and apply a temporary deny-all egress NetworkPolicy to the namespace to contain any misuse.
- On the node hosting the pod, kill any interactive shells (e.g., bash or sh) attached to the container and remove any copied credential artifacts such as /tmp/token or files containing contents of /var/run/secrets/kubernetes.io/serviceaccount/token or ca.crt.
- Rotate credentials and access by recreating the service account and its tokens, purge unauthorized RoleBinding/ClusterRoleBinding entries granting high privileges to that identity, and redeploy the workload from a trusted image with a clean start.
- Escalate to incident response if audit logs show the token being used to read Secrets, create or modify Pods/Jobs/Deployments, or alter RoleBinding/ClusterRoleBinding, or if API requests originate from an IP not matching the affected pod’s node.
- Harden by setting automountServiceAccountToken: false for pods that do not need API access, using projected service account tokens with short TTL and audience binding, denying kubectl exec/attach in production via RBAC/admission, and trimming the service account’s RBAC to least privilege.


## Rule Query

```eql
any where host.os.type == "linux" and process.interactive == true and container.id like "*" and (
  (event.category == "file" and event.type == "change" and event.action == "open" and
  file.path in (
    "/var/run/secrets/kubernetes.io/serviceaccount/token",
    "/var/run/secrets/kubernetes.io/serviceaccount/ca.crt",
    "/run/secrets/kubernetes.io/serviceaccount/token",
    "/run/secrets/kubernetes.io/serviceaccount/ca.crt"
  )) or
  (event.category == "process" and event.type == "start" and event.action == "exec" and
  (
    process.name in ("cat", "head", "tail", "more", "less", "sed", "awk") or
    process.args in (
      "cat", "/bin/cat", "/usr/bin/cat", "/usr/local/bin/cat",
      "head", "/bin/head", "/usr/bin/head", "/usr/local/bin/head",
      "tail", "/bin/tail", "/usr/bin/tail", "/usr/local/bin/tail",
      "more", "/bin/more", "/usr/bin/more", "/usr/local/bin/more",
      "less", "/bin/less", "/usr/bin/less", "/usr/local/bin/less",
      "sed", "/bin/sed", "/usr/bin/sed", "/usr/local/bin/sed",
      "awk", "/bin/awk", "/usr/bin/awk", "/usr/local/bin/awk"
    )
  ) and process.args like (
    "*/run/secrets/kubernetes.io/serviceaccount/token*",
    "*/run/secrets/kubernetes.io/serviceaccount/ca.crt*"
  ))
)
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Credential Access
- Id: TA0006
- Reference URL: [[https://attack.mitre.org/tactics/TA0006/](https://attack.mitre.org/tactics/TA0006/)](https://attack.mitre.org/tactics/TA0006/)
- Technique:
  - Name: Unsecured Credentials
- Id: T1552
- Reference URL: [[https://attack.mitre.org/techniques/T1552/](https://attack.mitre.org/techniques/T1552/)](https://attack.mitre.org/techniques/T1552/)
- Sub Technique:
  - Name: Credentials In Files
- Id: T1552.001
- Reference URL: [[https://attack.mitre.org/techniques/T1552/001/](https://attack.mitre.org/techniques/T1552/001/)](https://attack.mitre.org/techniques/T1552/001/)