﻿---
title: Sensitive File Compression Detected via Defend for Containers
description: Identifies the use of a compression utility to collect known files containing sensitive information, such as credentials and system configurations inside...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/cloud_defend/credential_access_collection_sensitive_files_compression_inside_a_container
products:
  - Elastic Security
---

# Sensitive File Compression Detected via Defend for Containers
Identifies the use of a compression utility to collect known files containing sensitive information, such as credentials
and system configurations inside a container.
**Rule type**: eql
**Rule indices**:
- logs-cloud_defend.process*

**Rule Severity**: medium
**Risk Score**: 47
**Runs every**: 5m
**Searches indices from**: `now-6m`
**Maximum alerts per execution**: 100
**References**:
**Tags**:
- Data Source: Elastic Defend for Containers
- Domain: Container
- OS: Linux
- Use Case: Threat Detection
- Tactic: Collection
- Tactic: Credential Access
- Resources: Investigation Guide

**Version**: 104
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Investigation guide


## Setup


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating Sensitive File Compression Detected via Defend for Containers

Containers are lightweight, portable environments used to run applications consistently across different systems. Adversaries may exploit compression utilities within containers to gather and exfiltrate sensitive files, such as credentials and configuration files. The detection rule identifies suspicious compression activities by monitoring for specific utilities and file paths, flagging potential unauthorized data collection attempts.

### Possible investigation steps

- Review the process details to confirm the use of compression utilities such as zip, tar, gzip, hdiutil, or 7z within the container environment, focusing on the process.name and process.args fields.
- Examine the specific file paths listed in the process.args to determine if they include sensitive files like SSH keys, AWS credentials, or Docker configurations, which could indicate unauthorized data collection.
- Identify the container.id associated with the alert to gather more context about the container's purpose, owner, and any recent changes or deployments that might explain the activity.
- Check the event.type field for "start" to verify the timing of the process initiation and correlate it with any known legitimate activities or scheduled tasks within the container.
- Investigate the user or service account under which the process was executed to assess whether it has the necessary permissions and if the activity aligns with expected behavior for that account.
- Look for any related alerts or logs that might indicate a broader pattern of suspicious activity within the same container or across other containers in the environment.


### False positive analysis

- Routine backup operations may trigger the rule if they involve compressing sensitive files for storage. To handle this, identify and exclude backup processes or scripts that are known and trusted.
- Automated configuration management tools might compress configuration files as part of their normal operation. Exclude these tools by specifying their process names or paths in the exception list.
- Developers or system administrators might compress sensitive files during legitimate troubleshooting or maintenance activities. Establish a process to log and review these activities, and exclude them if they are verified as non-threatening.
- Continuous integration and deployment pipelines could involve compressing configuration files for deployment purposes. Identify these pipelines and exclude their associated processes to prevent false positives.
- Security tools that perform regular audits or scans might compress files for analysis. Ensure these tools are recognized and excluded from triggering the rule.


### Response and remediation

- Immediately isolate the affected container to prevent further data exfiltration or unauthorized access. This can be done by stopping the container or disconnecting it from the network.
- Conduct a thorough review of the compressed files and their contents to assess the extent of sensitive data exposure. Focus on the specific file paths identified in the alert.
- Change credentials and keys that may have been compromised, including SSH keys, AWS credentials, and Docker configurations. Ensure that new credentials are distributed securely.
- Review and update access controls and permissions for sensitive files within containers to minimize exposure. Ensure that only necessary processes and users have access to these files.
- Implement monitoring and alerting for similar compression activities in other containers to detect potential threats early. Use the identified process names and arguments as indicators.
- Escalate the incident to the security operations team for further investigation and to determine if additional systems or data have been affected.
- Conduct a post-incident review to identify gaps in security controls and update container security policies to prevent recurrence.


## Rule Query

```eql
process where host.os.type == "linux" and event.type == "start" and event.action == "exec" and (
  process.name in ("zip", "tar", "gzip", "hdiutil", "7z", "rar", "7zip", "p7zip") or
  (
    /* account for tools that execute utilities as a subprocess, in this case the target utility name will appear as a process arg */
    process.name in ("bash", "dash", "sh", "tcsh", "csh", "zsh", "ksh", "fish", "busybox") and
    process.args in (
      "zip", "/bin/zip", "/usr/bin/zip", "/usr/local/bin/zip",
      "tar", "/bin/tar", "/usr/bin/tar", "/usr/local/bin/tar",
      "gzip", "/bin/gzip", "/usr/bin/gzip", "/usr/local/bin/gzip",
      "hdiutil", "/bin/hdiutil", "/usr/bin/hdiutil", "/usr/local/bin/hdiutil",
      "7z", "/bin/7z", "/usr/bin/7z", "/usr/local/bin/7z",
      "rar", "/bin/rar", "/usr/bin/rar", "/usr/local/bin/rar",
      "7zip", "/bin/7zip", "/usr/bin/7zip", "/usr/local/bin/7zip",
      "p7zip", "/bin/p7zip", "/usr/bin/p7zip", "/usr/local/bin/p7zip"
    ) and 
    /* default exclusion list to not FP on default multi-process commands */
    not process.args in (
      "which", "/bin/which", "/usr/bin/which", "/usr/local/bin/which",
      "man", "/bin/man", "/usr/bin/man", "/usr/local/bin/man",
      "chmod", "/bin/chmod", "/usr/bin/chmod", "/usr/local/bin/chmod",
      "chown", "/bin/chown", "/usr/bin/chown", "/usr/local/bin/chown"
    )
  )
) and
process.args like~ (
  "*/root/.ssh/*", "*/home/*/.ssh/*", "*/root/.bash_history*", "*/etc/hosts*", "*/root/.aws/*", "*/home/*/.aws/*",
  "*/root/.docker/*", "*/home/*/.docker/*", "*/etc/group*", "*/etc/passwd*", "*/etc/shadow*", "*/etc/gshadow*",
  "*/.azure/*", "*/var/run/secrets/azure/*", "*/.config/gcloud/*", "*application_default_credentials.json*",
  "*type: service_account*", "*client_email*", "*private_key_id*", "*private_key*", "*/var/run/secrets/google/*",
  "*GOOGLE_APPLICATION_CREDENTIALS*", "*AZURE_CLIENT_ID*", "*AZURE_TENANT_ID*", "*AZURE_CLIENT_SECRET*",
  "*AZURE_FEDERATED_TOKEN_FILE*", "*IDENTITY_ENDPOINT*", "*IDENTITY_HEADER*", "*MSI_ENDPOINT*", "*MSI_SECRET*"
) and process.interactive == true and container.id like "*" 
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Credential Access
- Id: TA0006
- Reference URL: [[https://attack.mitre.org/tactics/TA0006/](https://attack.mitre.org/tactics/TA0006/)](https://attack.mitre.org/tactics/TA0006/)
- Technique:
  - Name: Unsecured Credentials
- Id: T1552
- Reference URL: [[https://attack.mitre.org/techniques/T1552/](https://attack.mitre.org/techniques/T1552/)](https://attack.mitre.org/techniques/T1552/)
- Sub Technique:
  - Name: Credentials In Files
- Id: T1552.001
- Reference URL: [[https://attack.mitre.org/techniques/T1552/001/](https://attack.mitre.org/techniques/T1552/001/)](https://attack.mitre.org/techniques/T1552/001/)

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Collection
- Id: TA0009
- Reference URL: [[https://attack.mitre.org/tactics/TA0009/](https://attack.mitre.org/tactics/TA0009/)](https://attack.mitre.org/tactics/TA0009/)
- Technique:
  - Name: Archive Collected Data
- Id: T1560
- Reference URL: [[https://attack.mitre.org/techniques/T1560/](https://attack.mitre.org/techniques/T1560/)](https://attack.mitre.org/techniques/T1560/)
- Sub Technique:
  - Name: Archive via Utility
- Id: T1560.001
- Reference URL: [[https://attack.mitre.org/techniques/T1560/001/](https://attack.mitre.org/techniques/T1560/001/)](https://attack.mitre.org/techniques/T1560/001/)