﻿---
title: Cloud Credential Search Detected via Defend for Containers
description: This rule detects the use of system search utilities like grep and find to search for AWS credentials inside a container. Unauthorized access to these...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/cloud_defend/credential_access_cloud_creds_search_inside_a_container
products:
  - Elastic Security
---

# Cloud Credential Search Detected via Defend for Containers
This rule detects the use of system search utilities like grep and find to search for AWS credentials inside a
container. Unauthorized access to these sensitive files could lead to further compromise of the container
environment or facilitate a container breakout to the underlying cloud environment.
**Rule type**: eql
**Rule indices**:
- logs-cloud_defend.process*

**Rule Severity**: medium
**Risk Score**: 47
**Runs every**: 5m
**Searches indices from**: `now-6m`
**Maximum alerts per execution**: 100
**References**:
- [[https://sysdig.com/blog/threat-detection-aws-cloud-containers/](https://sysdig.com/blog/threat-detection-aws-cloud-containers/)](https://sysdig.com/blog/threat-detection-aws-cloud-containers/)

**Tags**:
- Data Source: Elastic Defend for Containers
- Domain: Container
- OS: Linux
- Use Case: Threat Detection
- Tactic: Credential Access
- Resources: Investigation Guide

**Version**: 103
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Rule Query

```eql
process where host.os.type == "linux" and event.type == "start" and event.action == "exec" and (
  process.name in ("grep", "egrep", "fgrep", "find", "locate", "mlocate", "cat", "sed", "awk") or
  (
    /* Account for tools that execute utilities as a subprocess, in this case the target utility name will appear as a process arg */
    process.name in ("bash", "dash", "sh", "tcsh", "csh", "zsh", "ksh", "fish", "busybox") and
    process.args in (
      "grep", "/bin/grep", "/usr/bin/grep", "/usr/local/bin/grep",
      "egrep", "/bin/egrep", "/usr/bin/egrep", "/usr/local/bin/egrep",
      "fgrep", "/bin/fgrep", "/usr/bin/fgrep", "/usr/local/bin/fgrep",
      "find", "/bin/find", "/usr/bin/find", "/usr/local/bin/find",
      "locate", "/bin/locate", "/usr/bin/locate", "/usr/local/bin/locate",
      "mlocate", "/bin/mlocate", "/usr/bin/mlocate", "/usr/local/bin/mlocate",
      "cat", "/bin/cat", "/usr/bin/cat", "/usr/local/bin/cat",
      "sed", "/bin/sed", "/usr/bin/sed", "/usr/local/bin/sed",
      "awk", "/bin/awk", "/usr/bin/awk", "/usr/local/bin/awk"
    ) and 
    /* default exclusion list to not FP on default multi-process commands */
    not process.args in (
      "which", "/bin/which", "/usr/bin/which", "/usr/local/bin/which",
      "man", "/bin/man", "/usr/bin/man", "/usr/local/bin/man",
      "chmod", "/bin/chmod", "/usr/bin/chmod", "/usr/local/bin/chmod",
      "chown", "/bin/chown", "/usr/bin/chown", "/usr/local/bin/chown"
    )
  )
)
and
process.args like~ (
  /* AWS Credentials */
  "*aws_access_key_id*", "*aws_secret_access_key*", "*aws_session_token*", "*accesskeyid*", "*secretaccesskey*",
  "*access_key*", "*.aws/credentials*",

  /* Azure Credentials */
  "*AZURE_CLIENT_ID*", "*AZURE_TENANT_ID*", "*AZURE_CLIENT_SECRET*", "*AZURE_FEDERATED_TOKEN_FILE*",
  "*IDENTITY_ENDPOINT*", "*IDENTITY_HEADER*", "*MSI_ENDPOINT*", "*MSI_SECRET*",
  "*/.azure/*", "*/var/run/secrets/azure/*",

  /* GCP Credentials */
  "*/.config/gcloud/*", "*application_default_credentials.json*",
  "*type: service_account*", "*client_email*", "*private_key_id*", "*private_key*",
  "*/var/run/secrets/google/*", "*GOOGLE_APPLICATION_CREDENTIALS*"
) and process.interactive == true and container.id like "*" 
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Credential Access
- Id: TA0006
- Reference URL: [[https://attack.mitre.org/tactics/TA0006/](https://attack.mitre.org/tactics/TA0006/)](https://attack.mitre.org/tactics/TA0006/)
- Technique:
  - Name: Unsecured Credentials
- Id: T1552
- Reference URL: [[https://attack.mitre.org/techniques/T1552/](https://attack.mitre.org/techniques/T1552/)](https://attack.mitre.org/techniques/T1552/)
- Sub Technique:
  - Name: Credentials In Files
- Id: T1552.001
- Reference URL: [[https://attack.mitre.org/techniques/T1552/001/](https://attack.mitre.org/techniques/T1552/001/)](https://attack.mitre.org/techniques/T1552/001/)