﻿---
title: Container Workload Protection
description: Generates a detection alert each time a 'Container Workload Protection' alert is received. Enabling this rule allows you to immediately begin triaging...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/cloud_defend/container_workload_protection
products:
  - Elastic Security
---

# Container Workload Protection
Generates a detection alert each time a 'Container Workload Protection' alert is received. Enabling this rule allows you
to immediately begin triaging and investigating these alerts.
**Rule type**: query
**Rule indices**:
- logs-cloud_defend.alerts-*

**Rule Severity**: medium
**Risk Score**: 47
**Runs every**: 
**Searches indices from**: `now-10m`
**Maximum alerts per execution**: 1000
**References**:
**Tags**:
- Data Source: Elastic Defend for Containers
- Domain: Container
- Resources: Investigation Guide

**Version**: 106
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Setup

This rule is configured to generate a maximum of 1000 alerts per run. This is to ensure that it captures as many alerts as possible.
For information on troubleshooting the maximum alerts warning please refer to this [guide](https://www.elastic.co/guide/en/security/current/alerts-ui-monitor.html#troubleshoot-max-alerts).

## Investigation guide


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating Container Workload Protection

Container Workload Protection is crucial for securing containerized environments by monitoring and defending against threats. Adversaries may exploit vulnerabilities in container orchestration or escape isolation to access host systems. The detection rule leverages alerts from cloud defense modules, focusing on suspicious activities within container domains, enabling timely triage and investigation of potential security incidents.

### Possible investigation steps

- Review the alert details to confirm it matches the query criteria, specifically checking for event.kind:alert and event.module:cloud_defend.
- Examine the context of the alert to identify any suspicious activities or anomalies within the container environment.
- Investigate the source and destination of the alert to determine if there are any unauthorized access attempts or lateral movement within the container infrastructure.
- Check for any recent changes or updates in the container orchestration system that might have introduced vulnerabilities.
- Correlate the alert with other security events or logs to identify patterns or repeated attempts that could indicate a larger attack campaign.
- Assess the impact of the alert on the containerized environment and determine if any immediate remediation actions are necessary to protect the host systems.


### False positive analysis

- Alerts triggered by routine maintenance tasks in container environments can be false positives. Users can create exceptions for known maintenance activities to reduce unnecessary alerts.
- Automated deployment processes might generate alerts due to rapid changes in container states. Exclude these processes by identifying and whitelisting their specific event patterns.
- Frequent updates to container images can cause alerts. Implement rules to recognize and exclude these updates if they match expected patterns and sources.
- Legitimate administrative actions within container orchestration platforms may be flagged. Document and exclude these actions by correlating them with authorized user activities.
- Network scanning tools used for security assessments might trigger alerts. Ensure these tools are recognized and excluded by defining their IP ranges and expected behaviors.


### Response and remediation

- Isolate the affected container to prevent lateral movement and further exploitation. This can be done by stopping the container or disconnecting it from the network.
- Analyze the container's logs and configurations to identify any unauthorized changes or suspicious activities that align with the alert.
- Patch any identified vulnerabilities in the container image or orchestration platform to prevent similar exploits.
- Restore the container from a known good backup or rebuild it using a secure and updated image to ensure no residual threats remain.
- Implement network segmentation and access controls to limit the exposure of containerized environments to potential threats.
- Escalate the incident to the security operations team if the threat appears to have impacted the host system or other critical infrastructure.
- Enhance monitoring and alerting rules to detect similar suspicious activities in the future, ensuring timely response to potential threats.


## Rule Query

```kuery
event.kind:alert and event.module:cloud_defend
```