﻿---
title: Curl SOCKS Proxy Detected via Defend for Containers
description: This rule detects the use of the "curl" command-line tool with SOCKS proxy options. Attackers may use "curl" to establish a SOCKS proxy connection to...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/cloud_defend/command_and_control_curl_socks_proxy_detected_inside_container
products:
  - Elastic Security
---

# Curl SOCKS Proxy Detected via Defend for Containers
This rule detects the use of the "curl" command-line tool with SOCKS proxy options. Attackers may use "curl" to establish a
SOCKS proxy connection to bypass network restrictions and exfiltrate data or communicate with C2 servers.
**Rule type**: eql
**Rule indices**:
- logs-cloud_defend.process*

**Rule Severity**: medium
**Risk Score**: 47
**Runs every**: 5m
**Searches indices from**: `now-6m`
**Maximum alerts per execution**: 100
**References**:
- [[https://www.trendmicro.com/en_us/research/25/f/tor-enabled-docker-exploit.html](https://www.trendmicro.com/en_us/research/25/f/tor-enabled-docker-exploit.html)](https://www.trendmicro.com/en_us/research/25/f/tor-enabled-docker-exploit.html)

**Tags**:
- Data Source: Elastic Defend for Containers
- Domain: Container
- OS: Linux
- Use Case: Threat Detection
- Tactic: Command and Control
- Resources: Investigation Guide

**Version**: 1
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Investigation guide


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating Curl SOCKS Proxy Detected via Defend for Containers

This detection flags interactive curl invocations inside Linux containers that use SOCKS proxy options, indicating traffic tunneling to evade egress controls and enable data exfiltration or C2 communications. A common pattern is an operator with shell access launching curl -x socks5h://localhost:1080 or --socks5-hostname via a dynamically created SSH -D port, then fetching payloads, beaconing to external endpoints, or posting stolen data through the proxy.

### Possible investigation steps

- Retrieve the full curl command line to extract the SOCKS proxy host:port, target URLs, and signs of uploads or auth (e.g., -d/--data, -T/--upload-file, -H Authorization), then pivot those IOCs across container and cluster telemetry.
- If the proxy points to localhost or an internal address, confirm a SOCKS listener in the container or node network namespace and identify the owning process to reveal the tunneling mechanism.
- Examine the process ancestry and same TTY/session context to attribute the action and spot precursor activity such as ssh -D, chisel, cloudflared, tor, or 3proxy establishing the proxy.
- Correlate Kubernetes metadata (pod, namespace, service account, node, image) and kube-apiserver audit logs for exec/attach to identify the actor, verify legitimacy, and find similar events in sibling pods or earlier revisions.
- Review network flows and DNS from this container through the proxy to external destinations to quantify data volume and destination reputation, and check for access to sensitive internal services.


### False positive analysis

- A developer troubleshooting from an interactive shell inside a container runs curl with -x/--proxy socks5 options to validate egress or reach internal endpoints through an approved proxy (e.g., localhost or an internal host), generating a benign match.
- Shell profiles or container environment configuration automatically route curl through --preproxy/--socks5-hostname to access internal APIs or artifact mirrors during interactive checks, causing expected activity to be flagged.


## Rule Query

```eql
process where host.os.type == "linux" and event.type == "start" and event.action == "exec" and
process.name == "curl" and process.args like ("--socks5-hostname", "--proxy", "--preproxy", "socks5*", "-x") and
process.interactive == true and container.id like "?*"
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Command and Control
- Id: TA0011
- Reference URL: [[https://attack.mitre.org/tactics/TA0011/](https://attack.mitre.org/tactics/TA0011/)](https://attack.mitre.org/tactics/TA0011/)
- Technique:
  - Name: Protocol Tunneling
- Id: T1572
- Reference URL: [[https://attack.mitre.org/techniques/T1572/](https://attack.mitre.org/techniques/T1572/)](https://attack.mitre.org/techniques/T1572/)