﻿---
title: Entra ID User Sign-in with Unusual Non-Managed Device
description: Identifies when a Microsoft Entra ID user signs in from a device that is not typically used by the user and is not managed, which may indicate potential...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/azure/persistence_entra_id_user_signed_in_from_unusual_device
products:
  - Elastic Security
---

# Entra ID User Sign-in with Unusual Non-Managed Device
Identifies when a Microsoft Entra ID user signs in from a device that is not typically used by the user and is not managed, which may
indicate potential compromise or unauthorized access attempts. This rule detects unusual sign-in activity by comparing
the device used for the sign-in against the user's typical device usage patterns. Adversaries may create and register a
new device to obtain a Primary Refresh Token (PRT) and maintain persistent access.
**Rule type**: new_terms
**Rule indices**:
- filebeat-*
- logs-azure.signinlogs-*

**Rule Severity**: low
**Risk Score**: 21
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
- [[https://pushsecurity.com/blog/consentfix](https://pushsecurity.com/blog/consentfix)](https://pushsecurity.com/blog/consentfix)
- [[https://www.volexity.com/blog/2025/04/22/phishing-for-codes-russian-threat-actors-target-microsoft-365-oauth-workflows/](https://www.volexity.com/blog/2025/04/22/phishing-for-codes-russian-threat-actors-target-microsoft-365-oauth-workflows/)](https://www.volexity.com/blog/2025/04/22/phishing-for-codes-russian-threat-actors-target-microsoft-365-oauth-workflows/)
- [[https://dirkjanm.io/phishing-for-microsoft-entra-primary-refresh-tokens/](https://dirkjanm.io/phishing-for-microsoft-entra-primary-refresh-tokens/)](https://dirkjanm.io/phishing-for-microsoft-entra-primary-refresh-tokens/)

**Tags**:
- Domain: Cloud
- Domain: Identity
- Use Case: Threat Detection
- Tactic: Persistence
- Data Source: Azure
- Data Source: Microsoft Entra ID
- Data Source: Microsoft Entra ID Sign-in Logs
- Resources: Investigation Guide

**Version**: 2
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

#### Required Microsoft Entra ID Sign-In Logs

This rule requires the Azure integration with Microsoft Entra ID Sign-In logs to be enabled and configured to collect audit and activity logs via Azure Event Hub.

## Investigation guide


## Triage and analysis


### Investigating Entra ID User Sign-in with Unusual Non-Managed Device

This rule detects when a Microsoft Entra ID user signs in from a device that is not typically used by the user, which may indicate potential compromise or unauthorized access attempts. This rule detects unusual sign-in activity by comparing the device used for the sign-in against the user's typical device usage patterns. Adversaries may create and register a new device to obtain a Primary Refresh Token (PRT) and maintain persistent access.

### Possible investigation steps

- Review the `azure.signinlogs.properties.user_principal_name` field to identify the user associated with the sign-in.
- Check the `azure.signinlogs.properties.device_detail.device_id` field to identify the device used for the sign-in.
- Review `azure.signinlogs.properties.incoming_token_type` to determine what tpe of security token was used for the sign-in, such as a Primary Refresh Token (PRT).
- Examine `azure.signinlogs.category` to determine if these were non-interactive or interactive sign-ins.
- Check the geolocation of the sign-in by reviewing `source.geo.country_name` and `source.geo.city_name` to identify the location of the device used for the sign-in. If these are unusual for the user, it may indicate a potential compromise.
- Review `azure.signinlogs.properties.app_id` to determine which client application was used for the sign-in. If the application is not recognized or expected, it may indicate unauthorized access. Adversaries use first-party client IDs to blend in with legitimate traffic.
- Examine `azure.signinlogs.properties.resource_id` to determine what resource the security token has in scope and/or is requesting access to. If the resource is not recognized or expected, it may indicate unauthorized access. Excessive access to Graph API is common post-compromise behavior.
- Review the identity protection risk status by checking `azure.signinlogs.properties.risk_level` and `azure.signinlogs.properties.risk_detail` to determine if the sign-in was flagged as risky by Entra ID Protection.


### False positive analysis

- Legitimate users may sign in from new devices, such as when using a new laptop or mobile device. If this is expected behavior, consider adjusting the rule or adding exceptions for specific users or device IDs.
- Environments where users frequently change devices, such as in a corporate setting with rotating hardware, may generate false positives.
- Users may use both an endpoint and mobile device for sign-ins, which could trigger this rule.


### Response and remediation

- If the sign-in is confirmed to be suspicious or unauthorized, take immediate action to revoke the access token and prevent further access.
- Disable the user account temporarily to prevent any potential compromise or unauthorized access.
- Review the user's recent sign-in activity and access patterns to identify any potential compromise or unauthorized access.
- If the user account is compromised, initiate a password reset and enforce multi-factor authentication (MFA) for the user.
- Review the conditional access policies in place to ensure they are sufficient to prevent unauthorized access to sensitive resources.
- Identify the registered Entra ID device by reviewing `azure.signinlogs.properties.device_detail.display_name` and confirm it is expected for the user or organization. If it is not expected, consider removing the device registration.
- Consider adding exceptions for verified devices that are known to be used by the user to reduce false-positives.


## Rule Query

```kuery
event.dataset: "azure.signinlogs" and
    event.category: "authentication" and
    azure.signinlogs.properties.user_type: "Member" and
    azure.signinlogs.properties.token_protection_status_details.sign_in_session_status: "unbound" and
    not azure.signinlogs.properties.device_detail.is_managed: true and
    not azure.signinlogs.properties.device_detail.device_id: "" and
    azure.signinlogs.properties.user_principal_name: *
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Persistence
- Id: TA0003
- Reference URL: [[https://attack.mitre.org/tactics/TA0003/](https://attack.mitre.org/tactics/TA0003/)](https://attack.mitre.org/tactics/TA0003/)
- Technique:
  - Name: Account Manipulation
- Id: T1098
- Reference URL: [[https://attack.mitre.org/techniques/T1098/](https://attack.mitre.org/techniques/T1098/)](https://attack.mitre.org/techniques/T1098/)
- Sub Technique:
  - Name: Device Registration
- Id: T1098.005
- Reference URL: [[https://attack.mitre.org/techniques/T1098/005/](https://attack.mitre.org/techniques/T1098/005/)](https://attack.mitre.org/techniques/T1098/005/)

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Initial Access
- Id: TA0001
- Reference URL: [[https://attack.mitre.org/tactics/TA0001/](https://attack.mitre.org/tactics/TA0001/)](https://attack.mitre.org/tactics/TA0001/)
- Technique:
  - Name: Valid Accounts
- Id: T1078
- Reference URL: [[https://attack.mitre.org/techniques/T1078/](https://attack.mitre.org/techniques/T1078/)](https://attack.mitre.org/techniques/T1078/)
- Sub Technique:
  - Name: Cloud Accounts
- Id: T1078.004
- Reference URL: [[https://attack.mitre.org/techniques/T1078/004/](https://attack.mitre.org/techniques/T1078/004/)](https://attack.mitre.org/techniques/T1078/004/)