﻿---
title: Entra ID Device Registration Detected (ROADtools)
description: Detects a sequence of events in Microsoft Entra ID indicative of a suspicious cloud-based device registration, potentially using ROADtools. This behavior...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/azure/persistence_entra_id_suspicious_cloud_device_registration
products:
  - Elastic Security
---

# Entra ID Device Registration Detected (ROADtools)
Detects a sequence of events in Microsoft Entra ID indicative of a suspicious cloud-based device registration,
potentially using ROADtools. This behavior involves adding a device via the Device Registration Service, followed by the
assignment of registered users and owners — a pattern consistent with techniques used to establish persistence or
acquire a Primary Refresh Token (PRT). ROADtools, a popular red team toolkit, often leaves distinct telemetry signatures
such as the `Microsoft.OData.Client` user agent and specific OS version values. These sequences are uncommon in typical
user behavior and may reflect abuse of device trust for session hijacking or silent token replay.
**Rule type**: eql
**Rule indices**:
- filebeat-*
- logs-azure.auditlogs-*

**Rule Severity**: medium
**Risk Score**: 47
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
- [[https://www.volexity.com/blog/2025/04/22/phishing-for-codes-russian-threat-actors-target-microsoft-365-oauth-workflows/](https://www.volexity.com/blog/2025/04/22/phishing-for-codes-russian-threat-actors-target-microsoft-365-oauth-workflows/)](https://www.volexity.com/blog/2025/04/22/phishing-for-codes-russian-threat-actors-target-microsoft-365-oauth-workflows/)
- [[https://github.com/dirkjanm/ROADtools](https://github.com/dirkjanm/ROADtools)](https://github.com/dirkjanm/ROADtools)

**Tags**:
- Domain: Cloud
- Domain: Identity
- Data Source: Azure
- Data Source: Microsoft Entra ID
- Data Source: Microsoft Entra ID Audit Logs
- Use Case: Identity and Access Audit
- Tactic: Persistence
- Resources: Investigation Guide

**Version**: 2
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Investigation guide


## Triage and analysis


### Investigating Entra ID Device Registration Detected (ROADtools)

This rule detects a sequence of Microsoft Entra ID audit events consistent with cloud device registration abuse via ROADtools or similar automation. The activity includes three correlated events:
1. Add device operation from the Device Registration Service using a `Microsoft.OData.Client/*` user-agent and a known Windows OS version.
2. Addition of a registered user with an `enterprise registration` URN.
3. Assignment of a registered owner to the device.

This pattern has been observed in OAuth phishing and PRT abuse campaigns where adversaries silently register a cloud device to obtain persistent, trusted access.

### Possible investigation steps

- Identify the user principal associated with the device registration.
- Review the `azure.auditlogs.identity` field to confirm the Device Registration Service initiated the request.
- Check for the presence of the `Microsoft.OData.Client/*` user-agent in `azure.auditlogs.properties.additional_details.value`, as this is common in ROADtools usage.
- Confirm the OS version seen in the modified properties is expected (e.g., `10.0.19041.928`), or investigate unexpected versions.
- Examine the URN in the new value field (`urn:ms-drs:enterpriseregistration.windows.net`) to verify it's not being misused.
- Use `azure.correlation_id` to pivot across all three steps of the registration flow.
- Pivot to `azure.signinlogs` to detect follow-on activity using the new device, such as sign-ins involving refresh or primary refresh tokens.
- Look for signs of persistence or lateral movement enabled by the newly registered device.
- Identify the registered device name by reviewing `azure.auditlogs.properties.target_resources.0.display_name` and confirm it's expected for the user or organization.
- Use the correlation ID `azure.correlation_id` to pivot into registered user events from Entra ID audit logs and check `azure.auditlogs.properties.target_resources.0.user_principal_name` to identify the user associated with the device registration.
- Review any activity for this user from Entra ID sign-in logs, where the incoming token type is a `primaryRefreshToken`.


### False positive analysis

- Some MDM or autopilot provisioning flows may generate similar sequences. Validate against known provisioning tools, expected rollout windows, and device inventory.
- Investigate whether the device name, OS version, and registration details align with normal IT workflows.


### Response and remediation

- If confirmed malicious, remove the registered device from Entra ID.
- Revoke refresh tokens and primary refresh tokens associated with the user and device.
- Disable the user account and initiate password reset and identity verification procedures.
- Review audit logs and sign-in activity for additional indicators of persistence or access from the rogue device.
- Tighten conditional access policies to restrict device registration and enforce compliance or hybrid join requirements.


## Rule Query

```eql
sequence by azure.correlation_id with maxspan=1m
[any where event.dataset == "azure.auditlogs" and
    azure.auditlogs.identity == "Device Registration Service" and
    azure.auditlogs.operation_name == "Add device" and
    azure.auditlogs.properties.additional_details.value like "Microsoft.OData.Client/*" and (
        `azure.auditlogs.properties.target_resources.0.modified_properties.1.display_name` == "CloudAccountEnabled" and
        `azure.auditlogs.properties.target_resources.0.modified_properties.1.new_value` == "[true]"
    ) and
    `azure.auditlogs.properties.target_resources.0.modified_properties.3.new_value` like "*10.0.19041.928*"]
[any where event.dataset == "azure.auditlogs" and
    azure.auditlogs.operation_name == "Add registered users to device" and
    `azure.auditlogs.properties.target_resources.0.modified_properties.2.new_value` like "*urn:ms-drs:enterpriseregistration.windows.net*"]
[any where event.dataset == "azure.auditlogs" and
    azure.auditlogs.operation_name == "Add registered owner to device"]
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Persistence
- Id: TA0003
- Reference URL: [[https://attack.mitre.org/tactics/TA0003/](https://attack.mitre.org/tactics/TA0003/)](https://attack.mitre.org/tactics/TA0003/)
- Technique:
  - Name: Account Manipulation
- Id: T1098
- Reference URL: [[https://attack.mitre.org/techniques/T1098/](https://attack.mitre.org/techniques/T1098/)](https://attack.mitre.org/techniques/T1098/)
- Sub Technique:
  - Name: Device Registration
- Id: T1098.005
- Reference URL: [[https://attack.mitre.org/techniques/T1098/005/](https://attack.mitre.org/techniques/T1098/005/)](https://attack.mitre.org/techniques/T1098/005/)