﻿---
title: Entra ID ADRS Token Request by Microsoft Authentication Broker
description: Detects suspicious OAuth 2.0 token requests where the Microsoft Authentication Broker (29d9ed98-a469-4536-ade2-f981bc1d605e) requests access to the Device...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/azure/persistence_entra_id_suspicious_adrs_token_request
products:
  - Elastic Security
---

# Entra ID ADRS Token Request by Microsoft Authentication Broker
Detects suspicious OAuth 2.0 token requests where the Microsoft Authentication Broker
(29d9ed98-a469-4536-ade2-f981bc1d605e) requests access to the Device Registration Service
(01cb2876-7ebd-4aa4-9cc9-d28bd4d359a9) on behalf of a user principal. The presence of the adrs_access scope in the
authentication processing details suggests an attempt to access ADRS, which is atypical for standard user sign-ins. This
behavior may reflect an effort to abuse device registration for unauthorized persistence, such as acquiring a Primary
Refresh Token (PRT) or establishing a trusted session.
**Rule type**: query
**Rule indices**:
- filebeat-*
- logs-azure.signinlogs-*

**Rule Severity**: medium
**Risk Score**: 47
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
- [[https://www.volexity.com/blog/2025/04/22/phishing-for-codes-russian-threat-actors-target-microsoft-365-oauth-workflows/](https://www.volexity.com/blog/2025/04/22/phishing-for-codes-russian-threat-actors-target-microsoft-365-oauth-workflows/)](https://www.volexity.com/blog/2025/04/22/phishing-for-codes-russian-threat-actors-target-microsoft-365-oauth-workflows/)

**Tags**:
- Domain: Cloud
- Domain: Identity
- Data Source: Azure
- Data Source: Microsoft Entra ID
- Data Source: Microsoft Entra ID Sign-In Logs
- Use Case: Identity and Access Audit
- Tactic: Persistence
- Resources: Investigation Guide

**Version**: 2
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Investigation guide


## Triage and analysis


### Investigating Entra ID ADRS Token Request by Microsoft Authentication Broker

Detects suspicious OAuth 2.0 token requests where the Microsoft Authentication Broker (29d9ed98-a469-4536-ade2-f981bc1d605e) requests access to the Device Registration Service (01cb2876-7ebd-4aa4-9cc9-d28bd4d359a9) on behalf of a user principal. The presence of the adrs_access scope in the authentication processing details suggests an attempt to access ADRS, which is atypical for standard user sign-ins. This behavior may reflect an effort to abuse device registration for unauthorized persistence, such as acquiring a Primary Refresh Token (PRT) or establishing a trusted session.

### Possible investigation steps

- Identify the user principal associated with the request by checking `azure.signinlogs.properties.user_principal_name` or `azure.signinlogs.properties.user_id`.
- Review the `azure.signinlogs.properties.app_id` and `azure.signinlogs.properties.resource_id` to confirm the request is made by the Microsoft Authentication Broker and targeting the Device Registration Service.
- Examine the `azure.signinlogs.properties.authentication_processing_details.Oauth Scope Info` for the presence of `adrs_access`, indicating an attempt to access ADRS.
- Check the `azure.signinlogs.properties.incoming_token_type` to confirm the request is made using a refresh token, which is typical for persistent access scenarios.
- Review the `azure.signinlogs.properties.user_type` to ensure it is a "Member" user, as this behavior is unusual for standard user accounts.
- Review the `source.address` and `source.geo.country_name` to identify the origin of the request. Look for any anomalies or unexpected locations.
- Check the `azure.signinlogs.properties.device_detail.operating_system` and `azure.signinlogs.properties.device_detail.browser` to identify the device and browser used for the request. Look for any unusual or unexpected devices for this user.
- Use the `azure.signinlogs.properties.session_id` to correlate this request with other sign-in events for the same user. Look for any patterns of suspicious activity or multiple requests in a short time frame.
- Correlate with Entra ID audit logs to identify any recent device registrations or changes to the user's device registration status.
- Pivot to primary refresh token (PRTs) usage for the same user and/or session ID to identify any potential abuse or unauthorized access attempts.


### False positive analysis

- Legitimate applications or services that require access to the Device Registration Service may trigger this rule. If this is expected behavior, consider adjusting the rule or adding exceptions for specific applications or user accounts.
- Users being onboarded or enrolled in new devices may also trigger this rule, especially if they are using the Microsoft Authentication Broker for the first time.


### Response and remediation

- If the request is confirmed to be suspicious or unauthorized, take immediate action to revoke the access token and prevent further access.
- Disable the user account temporarily to prevent any potential compromise or unauthorized access.
- Review the user's recent sign-in activity and access patterns to identify any potential compromise or unauthorized access.
- If the user account is compromised, initiate a password reset and enforce multi-factor authentication (MFA) for the user.
- Review the conditional access policies in place to ensure they are sufficient to prevent unauthorized access to sensitive resources.
- Consider deactivating any newly registered devices associated with the user account until further investigation is complete.


## Rule Query

```kuery
event.dataset: "azure.signinlogs" and
    azure.signinlogs.properties.app_id : "29d9ed98-a469-4536-ade2-f981bc1d605e" and
    azure.signinlogs.properties.resource_id : "01cb2876-7ebd-4aa4-9cc9-d28bd4d359a9" and
    azure.signinlogs.category: "NonInteractiveUserSignInLogs" and
    azure.signinlogs.properties.authentication_processing_details: *adrs_access* and
    azure.signinlogs.properties.incoming_token_type: "refreshToken" and
    azure.signinlogs.properties.user_type: "Member"
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Persistence
- Id: TA0003
- Reference URL: [[https://attack.mitre.org/tactics/TA0003/](https://attack.mitre.org/tactics/TA0003/)](https://attack.mitre.org/tactics/TA0003/)
- Technique:
  - Name: Account Manipulation
- Id: T1098
- Reference URL: [[https://attack.mitre.org/techniques/T1098/](https://attack.mitre.org/techniques/T1098/)](https://attack.mitre.org/techniques/T1098/)
- Sub Technique:
  - Name: Device Registration
- Id: T1098.005
- Reference URL: [[https://attack.mitre.org/techniques/T1098/005/](https://attack.mitre.org/techniques/T1098/005/)](https://attack.mitre.org/techniques/T1098/005/)