﻿---
title: Entra ID Service Principal Created
description: Identifies when a new service principal is added in Microsoft Entra ID. An application, hosted service, or automated tool that accesses or modifies resources...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/azure/persistence_entra_id_service_principal_created
products:
  - Elastic Security
---

# Entra ID Service Principal Created
Identifies when a new service principal is added in Microsoft Entra ID. An application, hosted service, or automated
tool that accesses or modifies resources needs an identity created. This identity is known as a service principal. For
security reasons, it's always recommended to use service principals with automated tools rather than allowing them to
log in with a user identity.
**Rule type**: query
**Rule indices**:
- filebeat-*
- logs-azure.auditlogs-*

**Rule Severity**: low
**Risk Score**: 21
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
- [[https://msrc-blog.microsoft.com/2020/12/13/customer-guidance-on-recent-nation-state-cyber-attacks/](https://msrc-blog.microsoft.com/2020/12/13/customer-guidance-on-recent-nation-state-cyber-attacks/)](https://msrc-blog.microsoft.com/2020/12/13/customer-guidance-on-recent-nation-state-cyber-attacks/)
- [[https://docs.microsoft.com/en-us/azure/active-directory/develop/howto-create-service-principal-portal](https://docs.microsoft.com/en-us/azure/active-directory/develop/howto-create-service-principal-portal)](https://docs.microsoft.com/en-us/azure/active-directory/develop/howto-create-service-principal-portal)

**Tags**:
- Domain: Cloud
- Data Source: Azure
- Data Source: Microsoft Entra ID
- Data Source: Microsoft Entra ID Audit Logs
- Use Case: Identity and Access Audit
- Resources: Investigation Guide
- Tactic: Persistence

**Version**: 109
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

### Microsft Entra ID Audit Logs

This rule requires the Azure integration with Microsoft Entra ID Audit Logs data stream ingesting in your Elastic Stack deployment. For more information, refer to the [Microsoft Entra ID Audit Logs integration documentation](https://www.elastic.co/docs/reference/integrations/azure/adlogs).

## Investigation guide


## Triage and analysis


### Investigating Entra ID Service Principal Created

Service Principals are identities used by applications, services, and automation tools to access specific resources. They grant specific access based on the assigned API permissions. Most organizations that work a lot with Azure AD make use of service principals. Whenever an application is registered, it automatically creates an application object and a service principal in an Azure AD tenant.
This rule looks for the addition of service principals. This behavior may enable attackers to impersonate legitimate service principals to camouflage their activities among noisy automations/apps.

#### Possible investigation steps

- Identify the user account that performed the action and whether it should perform this kind of action.
- Investigate other alerts associated with the user account during the past 48 hours.
- Consider the source IP address and geolocation for the user who issued the command. Do they look normal for the user?
- Consider the time of day. If the user is a human, not a program or script, did the activity take place during a normal time of day?
- Check if this operation was approved and performed according to the organization's change management policy.
- Contact the account owner and confirm whether they are aware of this activity.
- Examine the account's commands, API calls, and data management actions in the last 24 hours.
- If you suspect the account has been compromised, scope potentially compromised assets by tracking servers, services, and data accessed by the account in the last 24 hours.


### False positive analysis

If this rule is noisy in your environment due to expected activity, consider adding exceptions — preferably with a combination of user and device conditions.

### Response and remediation

- Initiate the incident response process based on the outcome of the triage.
- Disable or limit the account during the investigation and response.
- Identify the possible impact of the incident and prioritize accordingly; the following actions can help you gain context:
  - Identify the account role in the cloud environment.
- Assess the criticality of affected services and servers.
- Work with your IT team to identify and minimize the impact on users.
- Identify if the attacker is moving laterally and compromising other accounts, servers, or services.
- Identify any regulatory or legal ramifications related to this activity.
- Investigate credential exposure on systems compromised or used by the attacker to ensure all compromised accounts are identified. Reset passwords or delete API keys as needed to revoke the attacker's access to the environment. Work with your IT teams to minimize the impact on business operations during these actions.
- Check if unauthorized new users were created, remove unauthorized new accounts, and request password resets for other IAM users.
- Consider enabling multi-factor authentication for users.
- Follow security best practices [outlined](https://docs.microsoft.com/en-us/azure/security/fundamentals/identity-management-best-practices) by Microsoft.
- Determine the initial vector abused by the attacker and take action to prevent reinfection via the same vector.
- Using the incident response data, update logging and audit policies to improve the mean time to detect (MTTD) and the mean time to respond (MTTR).


## Rule Query

```kuery
event.dataset:azure.auditlogs
    and azure.auditlogs.operation_name:"Add service principal"
    and event.outcome:(success or Success)
    and not azure.auditlogs.identity: (
        "Managed Service Identity" or
        "Windows Azure Service Management API" or
        "Microsoft Azure AD Internal - Jit Provisioning" or
        "AAD App Management" or
        "Power Virtual Agents Service"
        )
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Persistence
- Id: TA0003
- Reference URL: [[https://attack.mitre.org/tactics/TA0003/](https://attack.mitre.org/tactics/TA0003/)](https://attack.mitre.org/tactics/TA0003/)
- Technique:
  - Name: Create Account
- Id: T1136
- Reference URL: [[https://attack.mitre.org/techniques/T1136/](https://attack.mitre.org/techniques/T1136/)](https://attack.mitre.org/techniques/T1136/)
- Sub Technique:
  - Name: Cloud Account
- Id: T1136.003
- Reference URL: [[https://attack.mitre.org/techniques/T1136/003/](https://attack.mitre.org/techniques/T1136/003/)](https://attack.mitre.org/techniques/T1136/003/)