﻿---
title: Entra ID OAuth PRT Issuance to Non-Managed Device Detected
description: Identifies when a user signs in with a refresh token using the Microsoft Authentication Broker (MAB) client, followed by a Primary Refresh Token (PRT)...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/azure/persistence_entra_id_rt_to_prt_transition_from_user_device
products:
  - Elastic Security
---

# Entra ID OAuth PRT Issuance to Non-Managed Device Detected
Identifies when a user signs in with a refresh token using the Microsoft Authentication Broker (MAB) client, followed by
a Primary Refresh Token (PRT) sign-in from the same device within 1 hour from an unmanaged device. This pattern may indicate that an attacker has
successfully registered a device using ROADtx and transitioned from short-term token access to long-term persistent
access via PRTs. Excluding access to the Device Registration Service (DRS) ensures the PRT is being used beyond
registration, often to access Microsoft 365 resources like Outlook or SharePoint.
**Rule type**: eql
**Rule indices**:
- filebeat-*
- logs-azure.signinlogs-*

**Rule Severity**: medium
**Risk Score**: 47
**Runs every**: 30m
**Searches indices from**: `now-60m`
**Maximum alerts per execution**: 100
**References**:
- [[https://www.volexity.com/blog/2025/04/22/phishing-for-codes-russian-threat-actors-target-microsoft-365-oauth-workflows/](https://www.volexity.com/blog/2025/04/22/phishing-for-codes-russian-threat-actors-target-microsoft-365-oauth-workflows/)](https://www.volexity.com/blog/2025/04/22/phishing-for-codes-russian-threat-actors-target-microsoft-365-oauth-workflows/)
- [[https://dirkjanm.io/abusing-azure-ad-sso-with-the-primary-refresh-token/](https://dirkjanm.io/abusing-azure-ad-sso-with-the-primary-refresh-token/)](https://dirkjanm.io/abusing-azure-ad-sso-with-the-primary-refresh-token/)

**Tags**:
- Domain: Cloud
- Domain: Identity
- Use Case: Threat Detection
- Data Source: Azure
- Data Source: Microsoft Entra ID
- Data Source: Microsoft Entra ID Sign-In Logs
- Tactic: Persistence
- Tactic: Initial Access
- Resources: Investigation Guide

**Version**: 3
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Investigation guide


## Triage and analysis


### Investigating Entra ID OAuth PRT Issuance to Non-Managed Device Detected

This rule identifies a sequence where a Microsoft Entra ID authenticates using a refresh token issued to the Microsoft Authentication Broker (MAB), followed by an authentication using a Primary Refresh Token (PRT) from the same unmanaged device. This behavior is uncommon for normal user activity and strongly suggests adversarial behavior, particularly when paired with OAuth phishing and device registration tools like ROADtx. The use of PRT shortly after a refresh token sign-in typically indicates the attacker has registered a virtual device and is now using the PRT to impersonate a registered user+device pair. The device in question is still marked as unmanaged, indicating it is not compliant with organizational policies and managed by Intune or other MDM solutions.

### Possible investigation steps

- Identify the user principal and device from `azure.signinlogs.properties.user_principal_name` and `azure.signinlogs.properties.device_detail.device_id`.
- Confirm the first sign-in event came from the Microsoft Auth Broker (`app_id`) with `incoming_token_type: refreshToken`.
- Ensure the device has a `trust_type` of "Azure AD joined" and that the `sign_in_session_status` is "unbound".
- Confirm the second sign-in used `incoming_token_type: primaryRefreshToken` and that the `resource_display_name` is not "Device Registration Service".
- Investigate any Microsoft Graph, Outlook, or SharePoint access occurring shortly after.
- Review conditional access policy outcomes and determine whether MFA or device compliance was bypassed.


### False positive analysis

- Legitimate device onboarding and sign-ins using hybrid-joined endpoints may trigger this rule.
- Rapid device provisioning in enterprise environments using MAB could generate similar token behavior.
- Use supporting signals, such as IP address changes, geolocation, or user agent anomalies, to reduce noise.


### Response and remediation

- Investigate other sign-in patterns and assess whether token abuse has occurred.
- Revoke PRT sessions via Microsoft Entra ID or Conditional Access.
- Remove or quarantine the suspicious device registration.
- Require password reset and enforce MFA.
- Audit and tighten device trust and conditional access configurations.


## Rule Query

```eql
sequence by azure.signinlogs.properties.user_id, azure.signinlogs.properties.device_detail.device_id with maxspan=1h
  [authentication where
    event.dataset == "azure.signinlogs" and
    azure.signinlogs.category == "NonInteractiveUserSignInLogs" and
    azure.signinlogs.properties.app_id == "29d9ed98-a469-4536-ade2-f981bc1d605e" and
    azure.signinlogs.properties.incoming_token_type == "refreshToken" and
    azure.signinlogs.properties.device_detail.trust_type == "Azure AD joined" and
    azure.signinlogs.properties.device_detail.device_id != null and
    azure.signinlogs.properties.token_protection_status_details.sign_in_session_status == "unbound" and
    azure.signinlogs.properties.user_type == "Member" and
    azure.signinlogs.result_signature == "SUCCESS"
  ]
  [authentication where
    event.dataset == "azure.signinlogs" and
    azure.signinlogs.properties.incoming_token_type == "primaryRefreshToken" and
    azure.signinlogs.properties.resource_display_name != "Device Registration Service" and
    azure.signinlogs.result_signature == "SUCCESS" and
    azure.signinlogs.properties.device_detail.is_managed != true
    and not (
        azure.signinlogs.properties.app_display_name == "Windows Sign In" or
        user_agent.original == "Windows-AzureAD-Authentication-Provider/1.0"
    )
  ]
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Persistence
- Id: TA0003
- Reference URL: [[https://attack.mitre.org/tactics/TA0003/](https://attack.mitre.org/tactics/TA0003/)](https://attack.mitre.org/tactics/TA0003/)
- Technique:
  - Name: Valid Accounts
- Id: T1078
- Reference URL: [[https://attack.mitre.org/techniques/T1078/](https://attack.mitre.org/techniques/T1078/)](https://attack.mitre.org/techniques/T1078/)
- Sub Technique:
  - Name: Cloud Accounts
- Id: T1078.004
- Reference URL: [[https://attack.mitre.org/techniques/T1078/004/](https://attack.mitre.org/techniques/T1078/004/)](https://attack.mitre.org/techniques/T1078/004/)
- Technique:
  - Name: Account Manipulation
- Id: T1098
- Reference URL: [[https://attack.mitre.org/techniques/T1098/](https://attack.mitre.org/techniques/T1098/)](https://attack.mitre.org/techniques/T1098/)
- Sub Technique:
  - Name: Device Registration
- Id: T1098.005
- Reference URL: [[https://attack.mitre.org/techniques/T1098/005/](https://attack.mitre.org/techniques/T1098/005/)](https://attack.mitre.org/techniques/T1098/005/)

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Credential Access
- Id: TA0006
- Reference URL: [[https://attack.mitre.org/tactics/TA0006/](https://attack.mitre.org/tactics/TA0006/)](https://attack.mitre.org/tactics/TA0006/)
- Technique:
  - Name: Steal Application Access Token
- Id: T1528
- Reference URL: [[https://attack.mitre.org/techniques/T1528/](https://attack.mitre.org/techniques/T1528/)](https://attack.mitre.org/techniques/T1528/)

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Initial Access
- Id: TA0001
- Reference URL: [[https://attack.mitre.org/tactics/TA0001/](https://attack.mitre.org/tactics/TA0001/)](https://attack.mitre.org/tactics/TA0001/)