﻿---
title: Entra ID Application Credential Modified
description: Identifies when a new credential is added to an application in Azure. An application may use a certificate or secret string to prove its identity when...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/azure/persistence_entra_id_application_credential_modification
products:
  - Elastic Security
---

# Entra ID Application Credential Modified
Identifies when a new credential is added to an application in Azure. An application may use a certificate or secret
string to prove its identity when requesting a token. Multiple certificates and secrets can be added for an application
and an adversary may abuse this by creating an additional authentication method to evade defenses or persist in an
environment.
**Rule type**: query
**Rule indices**:
- logs-azure.auditlogs-*
- filebeat-*

**Rule Severity**: medium
**Risk Score**: 47
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
- [[https://msrc-blog.microsoft.com/2020/12/13/customer-guidance-on-recent-nation-state-cyber-attacks/](https://msrc-blog.microsoft.com/2020/12/13/customer-guidance-on-recent-nation-state-cyber-attacks/)](https://msrc-blog.microsoft.com/2020/12/13/customer-guidance-on-recent-nation-state-cyber-attacks/)

**Tags**:
- Domain: Cloud
- Data Source: Azure
- Use Case: Identity and Access Audit
- Tactic: Persistence
- Resources: Investigation Guide

**Version**: 107
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Investigation guide


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating Entra ID Application Credential Modified

Azure applications use credentials like certificates or secret strings for identity verification during token requests. Adversaries may exploit this by adding unauthorized credentials, enabling persistent access or evading defenses. The detection rule monitors audit logs for successful updates to application credentials, flagging potential misuse by identifying unauthorized credential modifications.

### Possible investigation steps

- Review the Azure audit logs to identify the specific application that had its credentials updated, focusing on entries with the operation name "Update application - Certificates and secrets management" and a successful outcome.
- Determine the identity of the user or service principal that performed the credential modification by examining the associated user or principal ID in the audit log entry.
- Investigate the context of the credential modification by checking for any recent changes or unusual activities related to the application, such as modifications to permissions or roles.
- Assess the legitimacy of the new credential by verifying if it aligns with expected operational procedures or if it was authorized by a known and trusted entity.
- Check for any additional suspicious activities in the audit logs around the same timeframe, such as failed login attempts or other modifications to the application, to identify potential indicators of compromise.
- Contact the application owner or relevant stakeholders to confirm whether the credential addition was expected and authorized, and gather any additional context or concerns they might have.


### False positive analysis

- Routine credential updates by authorized personnel can trigger alerts. Regularly review and document credential management activities to distinguish between legitimate and suspicious actions.
- Automated processes or scripts that update application credentials as part of maintenance or deployment cycles may cause false positives. Identify and whitelist these processes to prevent unnecessary alerts.
- Credential updates during application scaling or migration might be flagged. Coordinate with IT teams to schedule these activities and temporarily adjust monitoring thresholds or exclusions.
- Third-party integrations that require periodic credential updates can be mistaken for unauthorized changes. Maintain an inventory of such integrations and establish baseline behaviors to filter out benign activities.
- Frequent updates by specific service accounts could be part of normal operations. Monitor these accounts separately and consider creating exceptions for known, non-threatening patterns.


### Response and remediation

- Immediately revoke the unauthorized credentials by accessing the Azure portal and removing any suspicious certificates or secret strings associated with the affected application.
- Conduct a thorough review of the application's access logs to identify any unauthorized access or actions performed using the compromised credentials.
- Reset and update all legitimate credentials for the affected application to ensure no further unauthorized access can occur.
- Notify the security team and relevant stakeholders about the incident, providing details of the unauthorized credential modification and any potential impact.
- Implement additional monitoring on the affected application to detect any further unauthorized changes or access attempts.
- Review and tighten access controls and permissions for managing application credentials to prevent unauthorized modifications in the future.
- If necessary, escalate the incident to higher-level security management or external cybersecurity experts for further investigation and response.


## Setup

The Azure Fleet integration, Filebeat module, or similarly structured data is required to be compatible with this rule.

## Rule Query

```kuery
event.dataset:azure.auditlogs and azure.auditlogs.operation_name:"Update application - Certificates and secrets management" and event.outcome:(success or Success)
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Persistence
- Id: TA0003
- Reference URL: [[https://attack.mitre.org/tactics/TA0003/](https://attack.mitre.org/tactics/TA0003/)](https://attack.mitre.org/tactics/TA0003/)
- Technique:
  - Name: Account Manipulation
- Id: T1098
- Reference URL: [[https://attack.mitre.org/techniques/T1098/](https://attack.mitre.org/techniques/T1098/)](https://attack.mitre.org/techniques/T1098/)
- Sub Technique:
  - Name: Additional Cloud Credentials
- Id: T1098.001
- Reference URL: [[https://attack.mitre.org/techniques/T1098/001/](https://attack.mitre.org/techniques/T1098/001/)](https://attack.mitre.org/techniques/T1098/001/)