﻿---
title: Rare Azure Activity Logs Event Failures
description: A machine learning job detected an unusual failure in an Azure Activity Logs message. These can be byproducts of attempted or successful persistence,...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/azure/ml_azure_rare_event_failures
products:
  - Elastic Security
---

# Rare Azure Activity Logs Event Failures
A machine learning job detected an unusual failure in an Azure Activity Logs message. These can be byproducts of attempted or
successful persistence, privilege escalation, defense evasion, discovery, lateral movement, or collection.
**Rule type**: machine_learning
**Rule indices**:
**Rule Severity**: low
**Risk Score**: 21
**Runs every**: 15m
**Searches indices from**: `now-2h`
**Maximum alerts per execution**: 100
**References**:
- [[https://www.elastic.co/guide/en/security/current/prebuilt-ml-jobs.html](https://www.elastic.co/guide/en/security/current/prebuilt-ml-jobs.html)](https://www.elastic.co/guide/en/security/current/prebuilt-ml-jobs.html)

**Tags**:
- Domain: Cloud
- Data Source: Azure
- Data Source: Azure Activity Logs
- Rule Type: ML
- Rule Type: Machine Learning
- Resources: Investigation Guide

**Version**: 1
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Setup

This rule requires the installation of associated Machine Learning jobs, as well as data coming in from Azure Activity Logs.

### Anomaly Detection Setup

Once the rule is enabled, the associated Machine Learning job will start automatically. You can view the Machine Learning job linked under the "Definition" panel of the detection rule. If the job does not start due to an error, the issue must be resolved for the job to commence successfully. For more details on setting up anomaly detection jobs, refer to the [helper guide](https://www.elastic.co/guide/en/kibana/current/xpack-ml-anomalies.html).

### Azure Activity Logs Integration Setup

The Azure Activity Logs integration allows you to collect logs and metrics from Azure with Elastic Agent.

#### The following steps should be executed in order to add the Elastic Agent System integration "Azure Activity Logs" to your system:

- Go to the Kibana home page and click “Add integrations”.
- In the query bar, search for “Azure Activity Logs” and select the integration to see more details about it.
- Click “Add Azure Activity Logs”.
- Configure the integration.
- Click “Save and Continue”.
- For more details on the integration refer to the [helper guide](https://www.elastic.co/docs/reference/integrations/azure/activitylogs).


## Investigation guide


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating Rare Azure Activity Logs Event Failures

This rule surfaces statistically rare Azure Activity Logs failures, pointing to control‑plane actions that break from typical patterns and may reflect reconnaissance, privilege changes, or defense evasion. A common attacker sequence is using a newly compromised identity to enumerate subscriptions and resource groups through the management API; repeated access denials during these discovery calls can occur as the adversary maps tenant scope and tests permissions before escalating.

### Possible investigation steps

- Classify the failing operations (discovery vs write/privileged) and tie them to the initiating principal and target scope to gauge intent and blast radius.
- Correlate with Entra ID sign-in telemetry for the same principal around the event window to assess geo/device novelty, MFA state, Conditional Access results, and identity risk flags.
- Check whether the identity recently had role assignments, group membership, PIM elevation, or app consent changes, and whether this is first-time access to the affected subscriptions or resource groups.
- Confirm whether Azure Policy denies, deny assignments, or resource locks explain the failures, and verify whether the principal should legitimately be exempt or granted access.
- If the actor is a service principal or managed identity, review recent credential changes (keys/secrets/certificates), app role assignment grants, and automation pipeline updates that could explain unexpected calls.


### False positive analysis

- A newly deployed automation or audit workflow attempts wide-scope resource discovery using a service principal or managed identity, encountering expected RBAC or policy denials that are rare for that caller.
- Recent governance changes such as Azure Policy deny effects, deny assignments, or resource locks cause routine management operations (e.g., writes or deletes) to start failing, creating an unusual failure pattern until baselines adjust.


### Response and remediation

- Immediately contain the initiating identity by disabling user/service principal sign-in, revoking refresh tokens, and applying a temporary Conditional Access block on Azure management endpoints, while placing deny assignments and resource locks on the impacted subscriptions/resource groups.
- Eradicate potential persistence by removing any newly created role assignments, app consent grants, policy exemptions, or management role changes identified in triage, and rotate keys/secrets/certificates for affected service principals or managed identities.
- Recover business operations by restoring access only to verified identities through PIM approvals, re-enabling known-good automation accounts/runbooks, and validating that expected management operations succeed without further rare failures on the targeted resources.
- Escalate to incident response immediately if rare failures are observed across multiple subscriptions or are followed by a successful privileged action (e.g., new Owner or User Access Administrator assignment, app consent grant, or resource lock removal) or originate from an unfamiliar geo/device, triggering tenant-wide containment.
- Harden going forward by enforcing MFA and Conditional Access (including workload identity policies) for Resource Manager access, restricting service principals to least privilege with certificate-based credentials or workload identity federation, implementing deny assignments/resource locks for crown-jewel resources, and centralizing Activity Logs in SIEM with detections for discovery bursts and denied write attempts.

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Discovery
- Id: TA0007
- Reference URL: [[https://attack.mitre.org/tactics/TA0007/](https://attack.mitre.org/tactics/TA0007/)](https://attack.mitre.org/tactics/TA0007/)
- Technique:
  - Name: Cloud Service Discovery
- Id: T1526
- Reference URL: [[https://attack.mitre.org/techniques/T1526/](https://attack.mitre.org/techniques/T1526/)](https://attack.mitre.org/techniques/T1526/)
- Technique:
  - Name: Cloud Infrastructure Discovery
- Id: T1580
- Reference URL: [[https://attack.mitre.org/techniques/T1580/](https://attack.mitre.org/techniques/T1580/)](https://attack.mitre.org/techniques/T1580/)

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Privilege Escalation
- Id: TA0004
- Reference URL: [[https://attack.mitre.org/tactics/TA0004/](https://attack.mitre.org/tactics/TA0004/)](https://attack.mitre.org/tactics/TA0004/)

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Defense Evasion
- Id: TA0005
- Reference URL: [[https://attack.mitre.org/tactics/TA0005/](https://attack.mitre.org/tactics/TA0005/)](https://attack.mitre.org/tactics/TA0005/)

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Lateral Movement
- Id: TA0008
- Reference URL: [[https://attack.mitre.org/tactics/TA0008/](https://attack.mitre.org/tactics/TA0008/)](https://attack.mitre.org/tactics/TA0008/)

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Persistence
- Id: TA0003
- Reference URL: [[https://attack.mitre.org/tactics/TA0003/](https://attack.mitre.org/tactics/TA0003/)](https://attack.mitre.org/tactics/TA0003/)

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Collection
- Id: TA0009
- Reference URL: [[https://attack.mitre.org/tactics/TA0009/](https://attack.mitre.org/tactics/TA0009/)](https://attack.mitre.org/tactics/TA0009/)