﻿---
title: Entra ID Protection - Risk Detection - Sign-in Risk
description: Identifies sign-in risk detection events via Microsofts Entra ID Protection service. Entra ID Protection detects sign-in activity such as anonymized IP...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/azure/initial_access_entra_id_protection_sign_in_risk_detected
products:
  - Elastic Security
---

# Entra ID Protection - Risk Detection - Sign-in Risk
Identifies sign-in risk detection events via Microsofts Entra ID Protection service. Entra ID Protection detects sign-in
activity such as anonymized IP addresses, unlikely travel, password spray, and more.
**Rule type**: query
**Rule indices**:
- logs-azure.identity_protection-*

**Rule Severity**: high
**Risk Score**: 73
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 1000
**References**:
- [[https://www.volexity.com/blog/2025/04/22/phishing-for-codes-russian-threat-actors-target-microsoft-365-oauth-workflows/](https://www.volexity.com/blog/2025/04/22/phishing-for-codes-russian-threat-actors-target-microsoft-365-oauth-workflows/)](https://www.volexity.com/blog/2025/04/22/phishing-for-codes-russian-threat-actors-target-microsoft-365-oauth-workflows/)
- [[https://github.com/dirkjanm/ROADtools](https://github.com/dirkjanm/ROADtools)](https://github.com/dirkjanm/ROADtools)
- [[https://dirkjanm.io/phishing-for-microsoft-entra-primary-refresh-tokens/](https://dirkjanm.io/phishing-for-microsoft-entra-primary-refresh-tokens/)](https://dirkjanm.io/phishing-for-microsoft-entra-primary-refresh-tokens/)
- [[https://learn.microsoft.com/en-us/entra/id-protection/concept-identity-protection-risks#risk-types-and-detection](https://learn.microsoft.com/en-us/entra/id-protection/concept-identity-protection-risks#risk-types-and-detection)](https://learn.microsoft.com/en-us/entra/id-protection/concept-identity-protection-risks#risk-types-and-detection)
- [[https://www.microsoft.com/en-us/security/blog/2025/05/27/new-russia-affiliated-actor-void-blizzard-targets-critical-sectors-for-espionage/](https://www.microsoft.com/en-us/security/blog/2025/05/27/new-russia-affiliated-actor-void-blizzard-targets-critical-sectors-for-espionage/)](https://www.microsoft.com/en-us/security/blog/2025/05/27/new-russia-affiliated-actor-void-blizzard-targets-critical-sectors-for-espionage/)

**Tags**:
- Domain: Cloud
- Domain: Identity
- Data Source: Azure
- Data Source: Entra ID
- Use Case: Identity and Access Audit
- Use Case: Threat Detection
- Use Case: Risk Detection
- Tactic: Initial Access
- Resources: Investigation Guide

**Version**: 4
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

#### Required Microsoft Entra ID Protection Logs

To use this rule, ensure that Microsoft Entra ID Protection logs are being collected and streamed into the Elastic Stack via the Azure integration.

### Additional notes

For information on troubleshooting the maximum alerts warning please refer to this [guide](https://www.elastic.co/guide/en/security/current/alerts-ui-monitor.html#troubleshoot-max-alerts).

## Investigation guide


## Triage and analysis

This rule detects sign-in risk detection events via Microsoft Entra ID Protection. It identifies various risk event types such as anonymized IP addresses, unlikely travel, password spray, and more. These events can indicate potential malicious activity or compromised accounts.

### Possible investigation steps

- Review the `azure.identityprotection.properties.risk_event_type` field to understand the specific risk event type detected.
- Check the `azure.identityprotection.properties.risk_level` field to determine the severity of the risk event.
- Check the `azure.identityprotection.properties.risk_detail` field for additional context on the risk event.
- Review the `azure.correlation_id` field to correlate this event with other related events in your environment.
- Review the `azure.identityprotection.properties.additional_info` field for any additional information provided by Entra ID Protection.
- Review the `azure.identityprotection.properties.detection_timing_type` field to understand when the risk event was detected. Offline detections may indicate a delayed response to a potential threat while real-time detections indicate immediate risk assessment.
- Check the `azure.identityprotection.properties.user_principal_name` field to identify the user account associated with the risk event. This can help determine if the account is compromised or if the risk event is expected behavior for that user. Triage the user account with other events from Entra ID audit or sign-in logs to identify any suspicious activity or patterns.


### False positive analysis

- Users accessing their accounts from anonymized IP addresses, such as VPNs or Tor, may trigger this rule. If this is expected behavior in your environment, consider adjusting the rule or adding exceptions for specific users or IP ranges.
- Users who frequently travel or access their accounts from different geographic locations may trigger this rule due to the unlikely travel detection mechanism. If this is expected behavior, consider adjusting the rule or adding exceptions for specific users.
- Users who have recently changed their passwords may trigger this rule due to the password spray detection mechanism. If this is expected behavior, consider adjusting the rule or adding exceptions for specific users.


### Response and remediation

- Investigate the user account associated with the risk event to determine if it has been compromised or if the risk event is expected behavior.
- If the risk event indicates a compromised account, take appropriate actions such as resetting the password, enabling multi-factor authentication, or disabling the account temporarily.
- Review authentication material such as primary refresh tokens (PRTs) or OAuth tokens to ensure they have not been compromised. If necessary, revoke these tokens to prevent further access.
- Implement sign-in risk policies in Entra ID Protection to automatically respond to risk events, such as requiring multi-factor authentication or blocking sign-ins from risky locations.
- Ensure multi-factor authentication is enabled for all user accounts to provide an additional layer of security against compromised accounts.
- Consider using high risk detections and conditional access evaluations to enforce stricter security measures for accounts or enable access revocation.


## Rule Query

```kuery
event.dataset: "azure.identity_protection" and
    event.action: "User Risk Detection" and
    azure.identityprotection.properties.activity: "signin" and
    not azure.identityprotection.properties.risk_state: (
        "remediated" or "dismissed" or "confirmedSafe"
    )
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Initial Access
- Id: TA0001
- Reference URL: [[https://attack.mitre.org/tactics/TA0001/](https://attack.mitre.org/tactics/TA0001/)](https://attack.mitre.org/tactics/TA0001/)
- Technique:
  - Name: Valid Accounts
- Id: T1078
- Reference URL: [[https://attack.mitre.org/techniques/T1078/](https://attack.mitre.org/techniques/T1078/)](https://attack.mitre.org/techniques/T1078/)
- Sub Technique:
  - Name: Cloud Accounts
- Id: T1078.004
- Reference URL: [[https://attack.mitre.org/techniques/T1078/004/](https://attack.mitre.org/techniques/T1078/004/)](https://attack.mitre.org/techniques/T1078/004/)

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Credential Access
- Id: TA0006
- Reference URL: [[https://attack.mitre.org/tactics/TA0006/](https://attack.mitre.org/tactics/TA0006/)](https://attack.mitre.org/tactics/TA0006/)
- Technique:
  - Name: Brute Force
- Id: T1110
- Reference URL: [[https://attack.mitre.org/techniques/T1110/](https://attack.mitre.org/techniques/T1110/)](https://attack.mitre.org/techniques/T1110/)
- Sub Technique:
  - Name: Password Spraying
- Id: T1110.003
- Reference URL: [[https://attack.mitre.org/techniques/T1110/003/](https://attack.mitre.org/techniques/T1110/003/)](https://attack.mitre.org/techniques/T1110/003/)
- Technique:
  - Name: Modify Authentication Process
- Id: T1556
- Reference URL: [[https://attack.mitre.org/techniques/T1556/](https://attack.mitre.org/techniques/T1556/)](https://attack.mitre.org/techniques/T1556/)

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Command and Control
- Id: TA0011
- Reference URL: [[https://attack.mitre.org/tactics/TA0011/](https://attack.mitre.org/tactics/TA0011/)](https://attack.mitre.org/tactics/TA0011/)
- Technique:
  - Name: Application Layer Protocol
- Id: T1071
- Reference URL: [[https://attack.mitre.org/techniques/T1071/](https://attack.mitre.org/techniques/T1071/)](https://attack.mitre.org/techniques/T1071/)