﻿---
title: Entra ID OAuth user_impersonation Scope for Unusual User and Client
description: Identifies rare occurrences of OAuth workflow for a user principal that is single factor authenticated, with an OAuth scope containing user_impersonation...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/azure/initial_access_entra_id_oauth_user_impersonation_scope
products:
  - Elastic Security
---

# Entra ID OAuth user_impersonation Scope for Unusual User and Client
Identifies rare occurrences of OAuth workflow for a user principal that is single factor authenticated, with an OAuth
scope containing user_impersonation for a token issued by Entra ID. Adversaries may use this scope to gain unauthorized
access to user accounts, particularly when the sign-in session status is unbound, indicating that the session is not
associated with a specific device or session. This behavior is indicative of potential account compromise or
unauthorized access attempts. This rule flags when this pattern is detected for a user principal that has not been seen
in the last 10 days, indicating potential abuse or unusual activity.
**Rule type**: new_terms
**Rule indices**:
- filebeat-*
- logs-azure.signinlogs-*

**Rule Severity**: medium
**Risk Score**: 47
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
- [[https://github.com/Flangvik/TeamFiltration](https://github.com/Flangvik/TeamFiltration)](https://github.com/Flangvik/TeamFiltration)
- [[https://www.proofpoint.com/us/blog/threat-insight/attackers-unleash-teamfiltration-account-takeover-campaign](https://www.proofpoint.com/us/blog/threat-insight/attackers-unleash-teamfiltration-account-takeover-campaign)](https://www.proofpoint.com/us/blog/threat-insight/attackers-unleash-teamfiltration-account-takeover-campaign)

**Tags**:
- Domain: Cloud
- Domain: Identity
- Use Case: Threat Detection
- Data Source: Azure
- Data Source: Microsoft Entra ID
- Data Source: Microsoft Entra ID Sign-In Logs
- Tactic: Initial Access
- Resources: Investigation Guide

**Version**: 4
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Investigation guide


## Triage and Analysis


### Investigating Entra ID OAuth user_impersonation Scope for Unusual User and Client

Identifies rare occurrences of OAuth workflow for a user principal that is single factor authenticated, with an OAuth scope containing `user_impersonation`, and a token issuer type of `AzureAD`. This rule is designed to detect suspicious
OAuth user impersonation attempts in Microsoft Entra ID, particularly those involving the `user_impersonation` scope, which is often used by adversaries to gain unauthorized access to user accounts. The rule focuses on sign-in events where
the sign-in session status is `unbound`, indicating that the session is not associated with a specific device or session, making it more vulnerable to abuse. This behavior is indicative of potential account compromise or
unauthorized access attempts, especially when the user type is `Member` and the sign-in outcome is `success`. The rule aims to identify these events to facilitate timely investigation and response to potential security incidents. This is a New Terms rule that flags when this pattern is detected for a user principal that has not been seen in the last 10 days, indicating potential abuse or unusual activity.

### Possible investigation steps

- Review the `azure.signinlogs.properties.user_principal_name` field to identify the user principal involved in the OAuth workflow.
- Check the `azure.signinlogs.properties.authentication_processing_details.Oauth Scope Info` field for the presence of `user_impersonation`. This scope is commonly used in OAuth flows to allow applications to access user resources on behalf of the user.
- Confirm that the `azure.signinlogs.properties.authentication_requirement` is set to `singleFactorAuthentication`, indicating that the sign-in did not require multi-factor authentication (MFA). This can be a red flag, as MFA is a critical security control that helps prevent unauthorized access.
- Review the `azure.signinlogs.properties.app_display_name` or `azure.signinlogs.properties.app_id` to identify the application involved in the OAuth workflow. Check if this application is known and trusted, or if it appears suspicious or unauthorized. FOCI applications are commonly abused by adversaries to evade security controls or conditional access policies.
- Analyze the `azure.signinlogs.properties.client_ip` to determine the source of the sign-in attempt. Look for unusual or unexpected IP addresses, especially those associated with known malicious activity or geographic locations that do not align with the user's typical behavior.
- Examine the `azure.signinlogs.properties.resource_display_name` or `azure.signinlogs.properties.resource_id` to identify the resource being accessed during the OAuth workflow. This can help determine if the access was legitimate or if it targeted sensitive resources. It may also help pivot to other related events or activities.
- Use the `azure.signinlogs.properties.session_id` or `azure.signinlogs.properties.correlation_id` to correlate this event with other related sign-in events or activities. This can help identify patterns of suspicious behavior or potential account compromise.


### False positive analysis

- Some legitimate applications may use the `user_impersonation` scope for valid purposes, such as accessing user resources on behalf of the user. If this is expected behavior, consider adjusting the rule or adding exceptions for specific applications or user principals.
- Users may occasionally authenticate using single-factor authentication for specific applications or scenarios, especially in environments where MFA is not enforced or required. If this is expected behavior, consider adjusting the rule or adding exceptions for specific user principals or applications.
- Some applications may use the `user_impersonation` scope for legitimate purposes, such as accessing user resources in a controlled manner. If this is expected behavior, consider adjusting the rule or adding exceptions for specific applications or user principals.


### Response and remediation

- Contact the user to validate the OAuth workflow and assess whether they were targeted or tricked by a malicious actor.
- If the OAuth workflow is confirmed to be malicious:
  - Block the user account and reset the password to prevent further unauthorized access.
- Revoke active sessions and refresh tokens associated with the user principal.
- Review the application involved in the OAuth workflow and determine if it should be blocked or removed from the tenant.
- Investigate the source of the sign-in attempt, including the application and IP address, to determine if there are any additional indicators of compromise or ongoing malicious activity.
- Monitor the user account and related resources for any further suspicious activity or unauthorized access attempts, and take appropriate actions to mitigate any risks identified.
- Educate users about the risks associated with OAuth user impersonation and encourage them to use more secure authentication methods, such as OAuth 2.0 or OpenID Connect, whenever possible.


## Rule Query

```kuery
event.dataset: azure.signinlogs and
    azure.signinlogs.properties.authentication_processing_details: *user_impersonation* and
    azure.signinlogs.properties.authentication_requirement: "singleFactorAuthentication" and
    azure.signinlogs.properties.token_issuer_type: "AzureAD" and
    azure.signinlogs.properties.token_protection_status_details.sign_in_session_status: "unbound" and
    azure.signinlogs.properties.user_type: "Member" and
    azure.signinlogs.properties.conditional_access_status: "notApplied" and
    not user_agent.original: (Mozilla*PKeyAuth/1.0 or Microsoft*Authentication*iPhone*) and
    not azure.signinlogs.properties.device_detail.operating_system: (Ios* or Android*) and
    event.outcome: "success"
    and not azure.signinlogs.properties.app_id: (
        "a5f63c0-b750-4f38-a71c-4fc0d58b89e2" or
        "6bc3b958-689b-49f5-9006-36d165f30e00" or
        "66a88757-258c-4c72-893c-3e8bed4d6899" or
        "cc15fd57-2c6c-4117-a88c-83b1d56b4bbe" or
        "0000000c-0000-0000-c000-000000000000" or
        "0a5f63c0-b750-4f38-a71c-4fc0d58b89e2" or
        "48af08dc-f6d2-435f-b2a7-069abd99c086" or
        "ab9b8c07-8f02-4f72-87fa-80105867a763" or
        "fc0f3af4-6835-4174-b806-f7db311fd2f3" or
        "5e3ce6c0-2b1f-4285-8d4b-75ee78787346" or
        "e8be65d6-d430-4289-a665-51bf2a194bda" or
        "95de633a-083e-42f5-b444-a4295d8e9314" or
        "d52792f4-ba38-424d-8140-ada5b883f293" or
        "65d91a3d-ab74-42e6-8a2f-0add61688c74" or
        "8c59ead7-d703-4a27-9e55-c96a0054c8d2"
    )
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Initial Access
- Id: TA0001
- Reference URL: [[https://attack.mitre.org/tactics/TA0001/](https://attack.mitre.org/tactics/TA0001/)](https://attack.mitre.org/tactics/TA0001/)
- Technique:
  - Name: Valid Accounts
- Id: T1078
- Reference URL: [[https://attack.mitre.org/techniques/T1078/](https://attack.mitre.org/techniques/T1078/)](https://attack.mitre.org/techniques/T1078/)
- Sub Technique:
  - Name: Cloud Accounts
- Id: T1078.004
- Reference URL: [[https://attack.mitre.org/techniques/T1078/004/](https://attack.mitre.org/techniques/T1078/004/)](https://attack.mitre.org/techniques/T1078/004/)

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Defense Evasion
- Id: TA0005
- Reference URL: [[https://attack.mitre.org/tactics/TA0005/](https://attack.mitre.org/tactics/TA0005/)](https://attack.mitre.org/tactics/TA0005/)
- Technique:
  - Name: Use Alternate Authentication Material
- Id: T1550
- Reference URL: [[https://attack.mitre.org/techniques/T1550/](https://attack.mitre.org/techniques/T1550/)](https://attack.mitre.org/techniques/T1550/)
- Sub Technique:
  - Name: Application Access Token
- Id: T1550.001
- Reference URL: [[https://attack.mitre.org/techniques/T1550/001/](https://attack.mitre.org/techniques/T1550/001/)](https://attack.mitre.org/techniques/T1550/001/)
- Technique:
  - Name: Impersonation
- Id: T1656
- Reference URL: [[https://attack.mitre.org/techniques/T1656/](https://attack.mitre.org/techniques/T1656/)](https://attack.mitre.org/techniques/T1656/)