﻿---
title: Entra ID Illicit Consent Grant via Registered Application
description: Identifies an illicit consent grant request on-behalf-of a registered Entra ID application. Adversaries may create and register an application in Microsoft...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/azure/initial_access_entra_id_illicit_consent_grant_via_registered_application
products:
  - Elastic Security
---

# Entra ID Illicit Consent Grant via Registered Application
Identifies an illicit consent grant request on-behalf-of a registered Entra ID application. Adversaries may create and
register an application in Microsoft Entra ID for the purpose of requesting user consent to access resources. This is
accomplished by tricking a user into granting consent to the application, typically via a pre-made phishing URL. This
establishes an OAuth grant that allows the malicious client applocation to access resources on-behalf-of the user.
**Rule type**: new_terms
**Rule indices**:
- logs-azure.auditlogs-*

**Rule Severity**: medium
**Risk Score**: 47
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
- [[https://www.wiz.io/blog/midnight-blizzard-microsoft-breach-analysis-and-best-practices](https://www.wiz.io/blog/midnight-blizzard-microsoft-breach-analysis-and-best-practices)](https://www.wiz.io/blog/midnight-blizzard-microsoft-breach-analysis-and-best-practices)
- [[https://docs.microsoft.com/en-us/microsoft-365/security/office-365-security/detect-and-remediate-illicit-consent-grants?view=o365-worldwide](https://docs.microsoft.com/en-us/microsoft-365/security/office-365-security/detect-and-remediate-illicit-consent-grants?view=o365-worldwide)](https://docs.microsoft.com/en-us/microsoft-365/security/office-365-security/detect-and-remediate-illicit-consent-grants?view=o365-worldwide)
- [[https://www.cloud-architekt.net/detection-and-mitigation-consent-grant-attacks-azuread/](https://www.cloud-architekt.net/detection-and-mitigation-consent-grant-attacks-azuread/)](https://www.cloud-architekt.net/detection-and-mitigation-consent-grant-attacks-azuread/)
- [[https://docs.microsoft.com/en-us/defender-cloud-apps/investigate-risky-oauth#how-to-detect-risky-oauth-apps](https://docs.microsoft.com/en-us/defender-cloud-apps/investigate-risky-oauth#how-to-detect-risky-oauth-apps)](https://docs.microsoft.com/en-us/defender-cloud-apps/investigate-risky-oauth#how-to-detect-risky-oauth-apps)

**Tags**:
- Domain: Cloud
- Data Source: Azure
- Data Source: Microsoft Entra ID
- Data Source: Microsoft Entra ID Audit Logs
- Use Case: Identity and Access Audit
- Resources: Investigation Guide
- Tactic: Initial Access
- Tactic: Credential Access

**Version**: 219
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Investigation guide


## Triage and analysis


### Investigating Entra ID Illicit Consent Grant via Registered Application

Adversaries may register a malicious application in Microsoft Entra ID and trick users into granting excessive permissions via OAuth consent. These applications can access sensitive data—such as mail, profiles, or files—on behalf of the user once consent is granted. This is commonly delivered via spearphishing links that prompt users to approve permissions for seemingly legitimate applications.
This rule identifies a new consent grant event based on Azure audit logs where the application was granted access with potentially risky scopes, such as offline_access, Mail.Read, or User.Read, and may include admin consent or tenant-wide delegation.
This is a New Terms rule that will only trigger if the user and client ID have not been seen doing this activity in the last 14 days.

#### Possible investigation steps

- Review `azure.auditlogs.properties.additional_details.value` to identify the AppId and User-Agent values to determine which application was granted access and how the request was initiated. Pivot on the AppId in the Azure portal under Enterprise Applications to investigate further.
- Review `azure.auditlogs.properties.initiated_by.user.userPrincipalName` to identify the user who approved the application. Investigate their recent activity for signs of phishing, account compromise, or anomalous behavior during the timeframe of the consent.
- Review `azure.auditlogs.properties.initiated_by.user.ipAddress` to assess the geographic source of the consent action. Unexpected locations or IP ranges may indicate adversary-controlled infrastructure.
- Review `azure.auditlogs.properties.target_resources.display_name` to evaluate whether the application name is familiar, expected, or potentially spoofing a known service.
- Review `azure.auditlogs.properties.target_resources.modified_properties.display_name` to inspect key indicators of elevated privilege or risk, including:
  - ConsentContext.IsAdminConsent to determine if the application was granted tenant-wide admin access.
- ConsentContext.OnBehalfOfAll to identify whether the app was granted permissions on behalf of all users in the tenant.
- ConsentAction.Permissions to evaluate the specific scopes and data access the application requested.
- ConsentAction.Reason to understand if Microsoft flagged the activity or if any reason was recorded by the platform.
- TargetId.ServicePrincipalNames to confirm the service principal associated with the granted permissions.
- Review `azure.tenant_id` to confirm the activity originated from your tenant and is not related to a cross-tenant application.
- Review `@timestamp` and `azure.auditlogs.properties.correlation_id` to pivot into related sign-in, token usage, or application activity for further context.


### False positive analysis

- Some applications may request high-privilege scopes for legitimate purposes. Validate whether the application is verified, developed by Microsoft, or approved internally by your organization.
- Review publisher verification, app ownership, and scope alignment with the intended business use case.


### Response and remediation

- Revoke the application’s OAuth grant using Graph API or PowerShell. Use the Remove-AzureADOAuth2PermissionGrant cmdlet.
- Remove the associated service principal from Azure AD.
- Reset credentials or revoke tokens for affected users.
- Block the application via Conditional Access or Defender for Cloud Apps policies.
- Enable the Admin Consent Workflow in Azure AD to prevent unsanctioned user approvals in the future.
- Report any malicious applications to Microsoft to protect other tenants.


## Rule Query

```kuery
event.dataset: "azure.auditlogs" and
  (
    azure.auditlogs.operation_name:"Consent to application"
    or event.action:"Consent to application"
  )
  and event.outcome: "success"
  and azure.auditlogs.properties.additional_details.key: "AppId"
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Initial Access
- Id: TA0001
- Reference URL: [[https://attack.mitre.org/tactics/TA0001/](https://attack.mitre.org/tactics/TA0001/)](https://attack.mitre.org/tactics/TA0001/)
- Technique:
  - Name: Phishing
- Id: T1566
- Reference URL: [[https://attack.mitre.org/techniques/T1566/](https://attack.mitre.org/techniques/T1566/)](https://attack.mitre.org/techniques/T1566/)
- Sub Technique:
  - Name: Spearphishing Link
- Id: T1566.002
- Reference URL: [[https://attack.mitre.org/techniques/T1566/002/](https://attack.mitre.org/techniques/T1566/002/)](https://attack.mitre.org/techniques/T1566/002/)

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Credential Access
- Id: TA0006
- Reference URL: [[https://attack.mitre.org/tactics/TA0006/](https://attack.mitre.org/tactics/TA0006/)](https://attack.mitre.org/tactics/TA0006/)
- Technique:
  - Name: Steal Application Access Token
- Id: T1528
- Reference URL: [[https://attack.mitre.org/techniques/T1528/](https://attack.mitre.org/techniques/T1528/)](https://attack.mitre.org/techniques/T1528/)