﻿---
title: Entra ID OAuth Device Code Grant by Unusual User
description: Identifies when a user is observed for the first time in the last 14 days authenticating using the device code authentication workflow. This authentication...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/azure/initial_access_entra_id_first_time_seen_device_code_auth
products:
  - Elastic Security
---

# Entra ID OAuth Device Code Grant by Unusual User
Identifies when a user is observed for the first time in the last 14 days authenticating using the device code
authentication workflow. This authentication workflow can be abused by attackers to phish users and steal access tokens
to impersonate the victim. By its very nature, device code should only be used when logging in to devices without
keyboards, where it is difficult to enter emails and passwords.
**Rule type**: new_terms
**Rule indices**:
- filebeat-*
- logs-azure.signinlogs-*
- logs-azure.activitylogs-*

**Rule Severity**: medium
**Risk Score**: 47
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
- [[https://aadinternals.com/post/phishing/](https://aadinternals.com/post/phishing/)](https://aadinternals.com/post/phishing/)
- [[https://www.blackhillsinfosec.com/dynamic-device-code-phishing/](https://www.blackhillsinfosec.com/dynamic-device-code-phishing/)](https://www.blackhillsinfosec.com/dynamic-device-code-phishing/)
- [[https://www.volexity.com/blog/2025/02/13/multiple-russian-threat-actors-targeting-microsoft-device-code-authentication/](https://www.volexity.com/blog/2025/02/13/multiple-russian-threat-actors-targeting-microsoft-device-code-authentication/)](https://www.volexity.com/blog/2025/02/13/multiple-russian-threat-actors-targeting-microsoft-device-code-authentication/)
- [[https://learn.microsoft.com/en-us/entra/identity/conditional-access/concept-authentication-flows](https://learn.microsoft.com/en-us/entra/identity/conditional-access/concept-authentication-flows)](https://learn.microsoft.com/en-us/entra/identity/conditional-access/concept-authentication-flows)

**Tags**:
- Domain: Cloud
- Data Source: Azure
- Data Source: Microsoft Entra ID
- Use Case: Identity and Access Audit
- Tactic: Initial Access
- Resources: Investigation Guide

**Version**: 7
**Rule authors**:
- Elastic
- Matteo Potito Giorgio

**Rule license**: Elastic License v2
This rule optionally requires Azure Sign-In logs from the Azure integration. Ensure that the Azure integration is correctly set up and that the required data is being collected.

## Investigation guide


## Triage and analysis


### Investigating Entra ID OAuth Device Code Grant by Unusual User

This rule detects the first instance of a user authenticating via the **DeviceCode** authentication protocol within a **14-day window**. The **DeviceCode** authentication workflow is designed for devices that lack keyboards, such as IoT devices and smart TVs. However, adversaries can abuse this mechanism by phishing users and stealing authentication tokens, leading to unauthorized access.

### Possible Investigation Steps


#### Identify the User and Authentication Details

- **User Principal Name (UPN)**: Review `azure.signinlogs.properties.user_principal_name` to identify the user involved in the authentication event.
- **User ID**: Check `azure.signinlogs.properties.user_id` for a unique identifier of the affected account.
- **Authentication Protocol**: Confirm that `azure.signinlogs.properties.authentication_protocol` is set to `deviceCode`.
- **Application Used**: Verify the application through `azure.signinlogs.properties.app_display_name` and `azure.signinlogs.properties.app_id` to determine if it is an expected application.


#### Review the Source IP and Geolocation

- **Source IP Address**: Check `source.ip` and compare it with previous authentication logs to determine whether the login originated from a trusted or expected location.
- **Geolocation Details**: Analyze `source.geo.city_name`, `source.geo.region_name`, and `source.geo.country_name` to confirm whether the login location is suspicious.
- **ASN / ISP Details**: Review `source.as.organization.name` to check if the IP is associated with a known organization or cloud provider.


#### Examine Multi-Factor Authentication (MFA) and Conditional Access

- **MFA Enforcement**: Review `azure.signinlogs.properties.applied_conditional_access_policies` to determine if MFA was enforced during the authentication.
- **Conditional Access Policies**: Check `azure.signinlogs.properties.conditional_access_status` to understand if conditional access policies were applied and if any controls were bypassed.
- **Authentication Method**: Look at `azure.signinlogs.properties.authentication_details` to confirm how authentication was satisfied (e.g., MFA via claim in token).


#### Validate Device and Client Details

- **Device Information**: Review `azure.signinlogs.properties.device_detail.browser` to determine if the login aligns with the expected behavior of a device that lacks a keyboard.
- **User-Agent Analysis**: Inspect `user_agent.original` for anomalies, such as an unexpected operating system or browser.
- **Client Application**: Verify `azure.signinlogs.properties.client_app_used` to confirm whether the login was performed using a known client.


#### Investigate Related Activities

- **Correlate with Phishing Attempts**: Check if the user recently reported phishing attempts or suspicious emails.
- **Monitor for Anomalous Account Activity**: Look for recent changes in the user's account settings, including password resets, role changes, or delegation of access.
- **Check for Additional DeviceCode Logins**: Review if other users in the environment have triggered similar authentication events within the same timeframe.


## False Positive Analysis

- **Legitimate Device Enrollment**: If the user is setting up a new device (e.g., a smart TV or kiosk), this authentication may be expected.
- **Automation or Scripting**: Some legitimate applications or scripts may leverage the `DeviceCode` authentication protocol for non-interactive logins.
- **Shared Devices in Organizations**: In cases where shared workstations or conference room devices are in use, legitimate users may trigger alerts.
- **Travel and Remote Work**: If the user is traveling or accessing from a new location, confirm legitimacy before taking action.


## Response and Remediation

- **Revoke Suspicious Access Tokens**: Immediately revoke any access tokens associated with this authentication event.
- **Investigate the User’s Recent Activity**: Review additional authentication logs, application access, and recent permission changes for signs of compromise.
- **Reset Credentials and Enforce Stronger Authentication**:
  - Reset the affected user’s credentials.
- Enforce stricter MFA policies for sensitive accounts.
- Restrict `DeviceCode` authentication to only required applications.
- **Monitor for Further Anomalies**:
  - Enable additional logging and anomaly detection for DeviceCode logins.
- Set up alerts for unauthorized access attempts using this authentication method.
- **Educate Users on Phishing Risks**: If phishing is suspected, notify the affected user and provide security awareness training on how to recognize and report phishing attempts.
- **Review and Adjust Conditional Access Policies**:
  - Limit `DeviceCode` authentication to approved users and applications.
- Implement stricter geolocation-based authentication restrictions.


## Rule Query

```kuery
event.dataset:(azure.activitylogs or azure.signinlogs)
    and (
            azure.signinlogs.properties.authentication_protocol:deviceCode or
            azure.signinlogs.properties.original_transfer_method: "Device code flow" or
            azure.activitylogs.properties.authentication_protocol:deviceCode
        )
    and event.outcome:success
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Initial Access
- Id: TA0001
- Reference URL: [[https://attack.mitre.org/tactics/TA0001/](https://attack.mitre.org/tactics/TA0001/)](https://attack.mitre.org/tactics/TA0001/)
- Technique:
  - Name: Phishing
- Id: T1566
- Reference URL: [[https://attack.mitre.org/techniques/T1566/](https://attack.mitre.org/techniques/T1566/)](https://attack.mitre.org/techniques/T1566/)
- Sub Technique:
  - Name: Spearphishing Link
- Id: T1566.002
- Reference URL: [[https://attack.mitre.org/techniques/T1566/002/](https://attack.mitre.org/techniques/T1566/002/)](https://attack.mitre.org/techniques/T1566/002/)
- Technique:
  - Name: Valid Accounts
- Id: T1078
- Reference URL: [[https://attack.mitre.org/techniques/T1078/](https://attack.mitre.org/techniques/T1078/)](https://attack.mitre.org/techniques/T1078/)
- Sub Technique:
  - Name: Cloud Accounts
- Id: T1078.004
- Reference URL: [[https://attack.mitre.org/techniques/T1078/004/](https://attack.mitre.org/techniques/T1078/004/)](https://attack.mitre.org/techniques/T1078/004/)