﻿---
title: Azure Storage Blob Retrieval via AzCopy
description: Identifies successful GetBlob operations on Azure Storage Accounts using AzCopy user agent with SAS token authentication. AzCopy is a command-line utility...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/azure/exfiltration_azure_storage_blob_download_azcopy_sas_token
products:
  - Elastic Security
---

# Azure Storage Blob Retrieval via AzCopy
Identifies successful GetBlob operations on Azure Storage Accounts using AzCopy user agent with SAS token
authentication. AzCopy is a command-line utility for copying data to and from Azure Storage. While legitimate for data
migration, adversaries may abuse AzCopy with compromised SAS tokens to exfiltrate data from Azure Storage Accounts. This
rule detects the first occurrence of GetBlob operations from a specific storage account using this pattern.
**Rule type**: new_terms
**Rule indices**:
- logs-azure.platformlogs-*

**Rule Severity**: medium
**Risk Score**: 47
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
- [[https://www.microsoft.com/en-us/security/blog/2025/08/27/storm-0501s-evolving-techniques-lead-to-cloud-based-ransomware/](https://www.microsoft.com/en-us/security/blog/2025/08/27/storm-0501s-evolving-techniques-lead-to-cloud-based-ransomware/)](https://www.microsoft.com/en-us/security/blog/2025/08/27/storm-0501s-evolving-techniques-lead-to-cloud-based-ransomware/)
- [[https://learn.microsoft.com/en-us/azure/storage/common/storage-use-azcopy-v10](https://learn.microsoft.com/en-us/azure/storage/common/storage-use-azcopy-v10)](https://learn.microsoft.com/en-us/azure/storage/common/storage-use-azcopy-v10)
- [[https://learn.microsoft.com/en-us/azure/storage/common/storage-sas-overview](https://learn.microsoft.com/en-us/azure/storage/common/storage-sas-overview)](https://learn.microsoft.com/en-us/azure/storage/common/storage-sas-overview)

**Tags**:
- Domain: Cloud
- Domain: Storage
- Data Source: Azure
- Data Source: Azure Platform Logs
- Data Source: Azure Storage
- Use Case: Threat Detection
- Tactic: Exfiltration
- Resources: Investigation Guide

**Version**: 1
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

#### Required Azure Storage Diagnostic Logs

To ensure this rule functions correctly, the following diagnostic logs must be enabled for Azure Storage Accounts:
- StorageRead: This log captures all read operations performed on blobs in the storage account, including GetBlob operations. These logs should be streamed to the Event Hub used for the Azure integration configuration.


## Investigation guide


## Triage and analysis


### Investigating Azure Storage Blob Retrieval via AzCopy

Azure Storage Accounts provide cloud storage services for blobs, files, queues, and tables. Shared Access Signatures (SAS) tokens provide delegated access to resources in a storage account with specific permissions and time constraints. AzCopy is a Microsoft command-line utility designed for efficient data transfers to and from Azure Storage. While AzCopy is a legitimate tool, adversaries may abuse it with compromised SAS tokens to exfiltrate data from Azure Storage Accounts.

### Possible investigation steps

- Review the `azure.platformlogs.properties.accountName` field to identify which storage account is being accessed and assess the sensitivity of data stored in that account.
- Examine the `azure.platformlogs.properties.objectKey` field to identify the specific blob(s) being retrieved. Determine if the accessed files contain sensitive or confidential data.
- Check the `source.address` field to identify the source IP address of the request. Investigate if this IP is unusual, unexpected, or originates from an unexpected network or geographic location.
- Review the `azure.platformlogs.uri` field to examine the SAS token parameters, including:
  - `se` (expiry time): Check when the SAS token expires
- `sp` (permissions): Verify what permissions were granted (e.g., "rl" for read and list)
- `sv` (API version): Note the storage service version being used
- Examine the `azure.platformlogs.identity.tokenHash` field to identify the specific SAS token signature being used. Correlate this with SAS token generation logs to determine when and how the token was created.
- Check the `azure.platformlogs.properties.responseBodySize` field to assess the volume of data being downloaded. Multiple GetBlob operations with large response sizes may indicate bulk data exfiltration.
- Search for related GetBlob operations from the same `source.address` or with the same `azure.platformlogs.identity.tokenHash` to identify patterns of systematic data retrieval.
- Review Azure Activity Logs for recent SAS token generation events or storage account key access operations that may indicate how the adversary obtained the credentials.
- Correlate this activity with ListBlobs or ListContainers operations from the same source, as adversaries often enumerate storage contents before exfiltration.
- Investigate the `azure.resource.group` field to understand which resource group the storage account belongs to and check for any recent security events or configuration changes in that resource group.


### False positive analysis

- Routine data migration or backup operations using AzCopy with SAS tokens are common in enterprise environments. If this is expected behavior for the storage account, consider adding exceptions for specific accounts or IP ranges.
- DevOps pipelines or automated workflows may use AzCopy with SAS tokens for legitimate data transfers. Review the automation configuration and add exceptions if appropriate.
- Third-party services or partners may have authorized access to storage accounts using AzCopy and SAS tokens. Verify these relationships and create exceptions for known authorized sources.


### Response and remediation

- If unauthorized access is confirmed, immediately revoke the compromised SAS token to prevent further data exfiltration.
- Review and rotate any additional SAS tokens that may have been compromised through the same attack vector.
- Assess the scope of data accessed or exfiltrated during the unauthorized GetBlob operations and determine if sensitive data was compromised.
- Implement additional monitoring and alerting for the affected storage account to detect any further suspicious activity.
- Review and strengthen SAS token generation policies, including implementing shorter expiration times and more restrictive permissions.
- Consider implementing Azure Storage firewall rules or private endpoints to restrict access to storage accounts from trusted networks only.
- Investigate how the SAS token was compromised and remediate the initial access vector to prevent future incidents.
- Document the incident and update security procedures to prevent similar compromises in the future.


## Rule Query

```kuery
event.dataset: azure.platformlogs and
    event.action: GetBlob and
    azure.platformlogs.identity.type: SAS and
    azure.platformlogs.properties.userAgentHeader: AzCopy* and
    azure.platformlogs.statusCode: 200
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Exfiltration
- Id: TA0010
- Reference URL: [[https://attack.mitre.org/tactics/TA0010/](https://attack.mitre.org/tactics/TA0010/)](https://attack.mitre.org/tactics/TA0010/)
- Technique:
  - Name: Exfiltration Over Web Service
- Id: T1567
- Reference URL: [[https://attack.mitre.org/techniques/T1567/](https://attack.mitre.org/techniques/T1567/)](https://attack.mitre.org/techniques/T1567/)
- Sub Technique:
  - Name: Exfiltration to Cloud Storage
- Id: T1567.002
- Reference URL: [[https://attack.mitre.org/techniques/T1567/002/](https://attack.mitre.org/techniques/T1567/002/)](https://attack.mitre.org/techniques/T1567/002/)