﻿---
title: Entra ID MFA TOTP Brute Force Attempted
description: Identifies brute force attempts against Azure Entra multi-factor authentication (MFA) Time-based One-Time Password (TOTP) verification codes. This rule...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/azure/credential_access_entra_id_totp_brute_force_attempts
products:
  - Elastic Security
---

# Entra ID MFA TOTP Brute Force Attempted
Identifies brute force attempts against Azure Entra multi-factor authentication (MFA) Time-based One-Time Password
(TOTP) verification codes. This rule detects high frequency failed TOTP code attempts for a single user in a short
time-span with a high number of distinct session IDs. Adversaries may programmatically attemopt to brute-force TOTP
codes by generating several sessions and attempt to guess the correct code.
**Rule type**: esql
**Rule indices**:
**Rule Severity**: medium
**Risk Score**: 47
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
- [[https://www.oasis.security/resources/blog/oasis-security-research-team-discovers-microsoft-azure-mfa-bypass](https://www.oasis.security/resources/blog/oasis-security-research-team-discovers-microsoft-azure-mfa-bypass)](https://www.oasis.security/resources/blog/oasis-security-research-team-discovers-microsoft-azure-mfa-bypass)
- [[https://learn.microsoft.com/en-us/entra/identity/](https://learn.microsoft.com/en-us/entra/identity/)](https://learn.microsoft.com/en-us/entra/identity/)
- [[https://learn.microsoft.com/en-us/entra/identity/monitoring-health/concept-sign-ins](https://learn.microsoft.com/en-us/entra/identity/monitoring-health/concept-sign-ins)](https://learn.microsoft.com/en-us/entra/identity/monitoring-health/concept-sign-ins)

**Tags**:
- Domain: Cloud
- Domain: Identity
- Data Source: Azure
- Data Source: Entra ID
- Data Source: Entra ID Sign-in logs
- Use Case: Identity and Access Audit
- Use Case: Threat Detection
- Tactic: Credential Access
- Resources: Investigation Guide

**Version**: 7
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

#### Required Entra ID Sign-In Logs

This rule requires the Entra ID sign-in logs via the Azure integration be enabled. In Entra ID, sign-in logs must be enabled and streaming to the Event Hub used for the Entra ID logs integration.

## Investigation guide


## Triage and analysis


### Investigating Entra ID MFA TOTP Brute Force Attempted

This rule detects brute force attempts against Azure Entra multi-factor authentication (MFA) Time-based One-Time Password (TOTP) verification codes. It identifies high-frequency failed TOTP code attempts for a single user in a short time-span with a high number of distinct session IDs. Adversaries may programmatically attempt to brute-force TOTP codes by generating several sessions and attempting to guess the correct code.

#### Possible Investigation Steps:

- Check the source addresses associated with the failed TOTP attempts.
- Determine if the source IP address is consistent with the user’s typical login locations.
- Look for unusual geographic patterns or anomalous IP addresses (e.g., proxies, VPNs, or locations outside the user’s normal activity).
- Review the error code associated with the failed attempts. This can help identify if the failures are due to incorrect TOTP codes or other issues.
- Verify that that auth metho reported is `OAth` as it indicates the use of TOTP codes.
- Pivot into signin logs for the target user and check if auth via TOTP was successful which would indicate a successful brute force attempt.
- Review conditional access policies applied to the user or group as reported by the sign-in logs.
- Analyze the client application ID and display name to determine if the attempts are coming from a legitimate application or a potentially malicious script.
- Adversaries may use legitimate FOCI applications to bypass security controls or make login attempts appear legitimate.
- Review the resource ID access is being attempted against such as MyApps, Microsoft Graph, or other resources. This can help identify if the attempts are targeting specific applications or services.
- The correlation IDs or session IDs can be used to trace the authentication attempts across different logs or systems. Note that for this specific behavior, unique session ID count is high and could be challenging to correlate.

#### False Positive Analysis:

- Verify if the failed attempts could result from the user’s unfamiliarity with TOTP codes or issues with device synchronization.
- Check if the user recently switched MFA methods or devices, which could explain multiple failures.
- Determine if this is whitebox testing or a developer testing MFA integration.

#### Response and Remediation:

- If proven malicious, lock the affected account temporarily to prevent further unauthorized attempts.
- Notify the user of suspicious activity and validate their access to the account.
- Reset passwords and MFA settings for the affected user to prevent unauthorized access while communicating with the user.
- Ensure conditional access policies are configured to monitor and restrict anomalous login behavior.
- Consider a different MFA method or additional security controls to prevent future bypass attempts.
- Implement additional monitoring to track high-frequency authentication failures across the environment.
- Audit historical logs for similar patterns involving other accounts to identify broader threats.
- Provide guidance on the secure use of MFA and the importance of recognizing and reporting suspicious activity.

## Rule Query

```esql
from logs-azure.signinlogs-* metadata _id, _version, _index

| where
    // filter for Entra Sign-in Logs
    event.dataset == "azure.signinlogs"
    and azure.signinlogs.operation_name == "Sign-in activity"
    and azure.signinlogs.properties.user_type == "Member"

    // filter for MFA attempts with OATH conditional access attempts or TOTP
    and azure.signinlogs.properties.mfa_detail.auth_method == "OATH verification code"

    // filter on failures only from brute-force attempts
    and (
            (
                azure.signinlogs.result_signature == "FAILURE" and
                azure.signinlogs.result_description == "Authentication failed during strong authentication request."
            ) or azure.signinlogs.properties.status.error_code == 500121
        )

| stats
    Esql.event_count = count(*),
    Esql.azure_signinlogs_properties_session_id_count_distinct = count_distinct(azure.signinlogs.properties.session_id),
    Esql.source_address_values = values(source.address),
    Esql.azure_tenant_id_valuues = values(azure.tenant_id),
    Esql_priv.azure_identity_values = values(azure.signinlogs.identity),
    Esql_priv.azure_signinlogs_properties_user_principal_name_values = values(azure.signinlogs.properties.user_principal_name),
    Esql.azure_signinlogs_properties_app_id_values = values(azure.signinlogs.properties.app_id),
    Esql.azure_signinlogs_properties_app_display_name_values = values(azure.signinlogs.properties.app_display_name),
    Esql.azure_signinlogs_properties_authentication_requirement_values = values(azure.signinlogs.properties.authentication_requirement),
    Esql.azure_signinlogs_properties_authentication_protocol_values = values(azure.signinlogs.properties.authentication_protocol),
    Esql.azure_signinlogs_properties_client_app_used_values = values(azure.signinlogs.properties.client_app_used),
    Esql.azure_signinlogs_properties_client_credential_type_values = values(azure.signinlogs.properties.client_credential_type),
    Esql.azure_signinlogs_properties_conditional_access_status_values = values(azure.signinlogs.properties.conditional_access_status),
    Esql.azure_signinlogs_properties_correlation_id_values = values(azure.signinlogs.properties.correlation_id),
    Esql.azure_signinlogs_properties_is_interactive_values = values(azure.signinlogs.properties.is_interactive),
    Esql.azure_signinlogs_properties_mfa_detail_auth_method_values = values(azure.signinlogs.properties.mfa_detail.auth_method),
    Esql.azure_signinlogs_properties_resource_display_name_values = values(azure.signinlogs.properties.resource_display_name),
    Esql.azure_signinlogs_properties_resource_id_values = values(azure.signinlogs.properties.resource_id),
    Esql.azure_signinlogs_properties_risk_state_values = values(azure.signinlogs.properties.risk_state),
    Esql.azure_signinlogs_properties_risk_detail_values = values(azure.signinlogs.properties.risk_detail),
    Esql.azure_signinlogs_properties_status_error_code_values = values(azure.signinlogs.properties.status.error_code),
    Esql.azure_signinlogs_properties_original_request_id_values = values(azure.signinlogs.properties.original_request_id),
    Esql.user_id_values = values(user.id)
    by user.id

| where Esql.event_count >= 20 and Esql.azure_signinlogs_properties_session_id_count_distinct >= 10

| keep
    Esql.event_count,
    Esql.azure_signinlogs_properties_session_id_count_distinct,
    Esql.source_address_values,
    Esql.azure_tenant_id_valuues,
    Esql_priv.azure_identity_values,
    Esql_priv.azure_signinlogs_properties_user_principal_name_values,
    Esql.azure_signinlogs_properties_app_id_values,
    Esql.azure_signinlogs_properties_app_display_name_values,
    Esql.azure_signinlogs_properties_authentication_requirement_values,
    Esql.azure_signinlogs_properties_authentication_protocol_values,
    Esql.azure_signinlogs_properties_client_app_used_values,
    Esql.azure_signinlogs_properties_client_credential_type_values,
    Esql.azure_signinlogs_properties_conditional_access_status_values,
    Esql.azure_signinlogs_properties_correlation_id_values,
    Esql.azure_signinlogs_properties_is_interactive_values,
    Esql.azure_signinlogs_properties_mfa_detail_auth_method_values,
    Esql.azure_signinlogs_properties_resource_display_name_values,
    Esql.azure_signinlogs_properties_resource_id_values,
    Esql.azure_signinlogs_properties_risk_state_values,
    Esql.azure_signinlogs_properties_risk_detail_values,
    Esql.azure_signinlogs_properties_status_error_code_values,
    Esql.azure_signinlogs_properties_original_request_id_values,
    Esql.user_id_values
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Credential Access
- Id: TA0006
- Reference URL: [[https://attack.mitre.org/tactics/TA0006/](https://attack.mitre.org/tactics/TA0006/)](https://attack.mitre.org/tactics/TA0006/)
- Technique:
  - Name: Brute Force
- Id: T1110
- Reference URL: [[https://attack.mitre.org/techniques/T1110/](https://attack.mitre.org/techniques/T1110/)](https://attack.mitre.org/techniques/T1110/)
- Sub Technique:
  - Name: Password Guessing
- Id: T1110.001
- Reference URL: [[https://attack.mitre.org/techniques/T1110/001/](https://attack.mitre.org/techniques/T1110/001/)](https://attack.mitre.org/techniques/T1110/001/)