﻿---
title: Microsoft Graph Request Email Access by Unusual User and Client
description: Identifies access to email resources via Microsoft Graph API using an first-party application on behalf of a user principal. This behavior may indicate...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/azure/collection_graph_email_access_by_unusual_public_client_via_graph
products:
  - Elastic Security
---

# Microsoft Graph Request Email Access by Unusual User and Client
Identifies access to email resources via Microsoft Graph API using an first-party application on behalf of a user
principal. This behavior may indicate an adversary using a phished OAuth refresh token or a Primary Refresh Token (PRT)
to access email resources. The pattern includes requests to Microsoft Graph API endpoints related to email, such as
/me/mailFolders/inbox/messages or /users/{user_id}/messages, using a public client application ID and a user principal
object ID. This is a New Terms rule that only signals if the application ID and user principal object ID have not been
seen doing this activity in the last 14 days.
**Rule type**: new_terms
**Rule indices**:
- logs-azure.graphactivitylogs-*

**Rule Severity**: medium
**Risk Score**: 47
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
- [[https://www.volexity.com/blog/2025/04/22/phishing-for-codes-russian-threat-actors-target-microsoft-365-oauth-workflows/](https://www.volexity.com/blog/2025/04/22/phishing-for-codes-russian-threat-actors-target-microsoft-365-oauth-workflows/)](https://www.volexity.com/blog/2025/04/22/phishing-for-codes-russian-threat-actors-target-microsoft-365-oauth-workflows/)
- [[https://github.com/dirkjanm/ROADtools](https://github.com/dirkjanm/ROADtools)](https://github.com/dirkjanm/ROADtools)
- [[https://dirkjanm.io/phishing-for-microsoft-entra-primary-refresh-tokens/](https://dirkjanm.io/phishing-for-microsoft-entra-primary-refresh-tokens/)](https://dirkjanm.io/phishing-for-microsoft-entra-primary-refresh-tokens/)
- [[https://pushsecurity.com/blog/consentfix](https://pushsecurity.com/blog/consentfix)](https://pushsecurity.com/blog/consentfix)

**Tags**:
- Domain: Cloud
- Data Source: Azure
- Data Source: Microsoft Graph
- Data Source: Microsoft Graph Activity Logs
- Use Case: Threat Detection
- Tactic: Collection
- Resources: Investigation Guide

**Version**: 3
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Investigation guide


## Triage and analysis


### Investigating Microsoft Graph Request Email Access by Unusual User and Client

This rule detects instances where a previously unseen or rare Microsoft Graph application client ID accesses email-related APIs, such as `/me/messages`, `/sendMail`, or `/mailFolders/inbox/messages`. These accesses are performed via delegated user credentials using common OAuth scopes like `Mail.Read`, `Mail.ReadWrite`, `Mail.Send`, or `email`. This activity may indicate unauthorized use of a newly consented or compromised application to read or exfiltrate mail content. This is a New Terms rule that only signals if the application ID (`azure.graphactivitylogs.properties.app_id`) and user principal object ID (`azure.graphactivitylogs.properties.user_principal_object_id`) have not been seen doing this activity in the last 14 days.

### Possible Investigation Steps:

- `azure.graphactivitylogs.properties.app_id`: Investigate the application ID involved. Is it known and sanctioned in your tenant? Pivot to Azure Portal → Enterprise Applications → Search by App ID to determine app details, publisher, and consent status.
- `azure.graphactivitylogs.properties.scopes`: Review the scopes requested by the application. Email-related scopes such as `Mail.ReadWrite` and `Mail.Send` are especially sensitive and suggest the app is interacting with mail content.
- `url.path` / `azure.graphactivitylogs.properties.requestUri`: Determine exactly which mail-related APIs were accessed (e.g., reading inbox, sending messages, enumerating folders).
- `user.id`: Identify the user whose credentials were used. Determine if the user recently consented to a new app, clicked a phishing link, or reported suspicious activity.
- `user_agent.original`: Check for suspicious automation tools (e.g., `python-requests`, `curl`, non-browser agents), which may suggest scripted access.
- `source.ip` and `client.geo`: Investigate the source IP and geography. Look for unusual access from unexpected countries, VPS providers, or anonymizing services.
- `http.request.method`: Determine intent based on HTTP method — `GET` (reading), `POST` (sending), `PATCH`/`DELETE` (modifying/removing messages).
- `token_issued_at` and `@timestamp`: Determine how long the token has been active and whether access is ongoing or recent.
- `azure.graphactivitylogs.properties.c_sid`: Use the session correlation ID to identify other related activity in the same session. This may help identify if the app is accessing multiple users' mailboxes or if the same user is accessing multiple apps.
- Correlate with Microsoft Entra ID (`azure.auditlogs` and `azure.signinlogs`) to determine whether:
  - The app was recently granted admin or user consent
- Risky sign-ins occurred just prior to or after mail access
- The same IP or app ID appears across multiple users


### False Positive Analysis

- New legitimate apps may appear after a user consents via OAuth. Developers, third-party tools, or IT-supplied utilities may access mail APIs if users consent.
- Users leveraging Microsoft development environments (e.g., Visual Studio Code) may trigger this behavior with delegated `.default` permissions.
- Admin-approved apps deployed via conditional access may trigger similar access logs if not previously seen in detection baselines.


### Response and Remediation

- If access is unauthorized or unexpected:
  - Revoke the app's consent in Azure AD via the Enterprise Applications blade.
- Revoke user refresh tokens via Microsoft Entra or PowerShell.
- Investigate the user's session and alert them to possible phishing or OAuth consent abuse.
- Review and restrict risky OAuth permissions in Conditional Access and App Governance policies.
- Add known, trusted app IDs to a detection allowlist to reduce noise in the future.
- Continue monitoring the app ID for additional usage across the tenant or from suspicious IPs.


## Rule Query

```kuery
event.dataset: "azure.graphactivitylogs" and
azure.graphactivitylogs.properties.app_id: * and
azure.graphactivitylogs.result_signature: 200 and
azure.graphactivitylogs.properties.c_idtyp: "user" and
azure.graphactivitylogs.properties.client_auth_method: 0 and
http.request.method: (GET or POST or PUT or PATCH or DELETE) and (
  url.path: (/v1.0/me/*cc or /v1.0/users/*) and
  (
    url.path: (*mail* or *messages* or *inbox*) or
    azure.graphactivitylogs.properties.requestUri: (*mail* or *messages* or *inbox*)
  ) or
  azure.graphactivitylogs.properties.scopes: (
    "Mail.Read" or "Mail.ReadWrite" or "Mail.Send" or "email"
  )
)
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Collection
- Id: TA0009
- Reference URL: [[https://attack.mitre.org/tactics/TA0009/](https://attack.mitre.org/tactics/TA0009/)](https://attack.mitre.org/tactics/TA0009/)
- Technique:
  - Name: Email Collection
- Id: T1114
- Reference URL: [[https://attack.mitre.org/techniques/T1114/](https://attack.mitre.org/techniques/T1114/)](https://attack.mitre.org/techniques/T1114/)