﻿---
title: AWS Bedrock Detected Multiple Validation Exception Errors by a Single User
description: Identifies multiple validation exeception errors within AWS Bedrock. Validation errors occur when you run the InvokeModel or InvokeModelWithResponseStream...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/aws_bedrock/aws_bedrock_multiple_validation_exception_errors_by_single_user
products:
  - Elastic Security
---

# AWS Bedrock Detected Multiple Validation Exception Errors by a Single User
Identifies multiple validation exeception errors within AWS Bedrock. Validation errors occur when you run the
InvokeModel or InvokeModelWithResponseStream APIs on a foundation model that uses an incorrect inference parameter or
corresponding value. These errors also occur when you use an inference parameter for one model with a model that doesn't
have the same API parameter. This could indicate attempts to bypass limitations of other approved models, or to force an
impact on the environment by incurring exhorbitant costs.
**Rule type**: esql
**Rule indices**:
**Rule Severity**: high
**Risk Score**: 73
**Runs every**: 10m
**Searches indices from**: `now-60m`
**Maximum alerts per execution**: 100
**References**:
- [[https://atlas.mitre.org/techniques/AML.T0015](https://atlas.mitre.org/techniques/AML.T0015)](https://atlas.mitre.org/techniques/AML.T0015)
- [[https://atlas.mitre.org/techniques/AML.T0034](https://atlas.mitre.org/techniques/AML.T0034)](https://atlas.mitre.org/techniques/AML.T0034)
- [[https://atlas.mitre.org/techniques/AML.T0046](https://atlas.mitre.org/techniques/AML.T0046)](https://atlas.mitre.org/techniques/AML.T0046)
- [[https://www.elastic.co/security-labs/elastic-advances-llm-security](https://www.elastic.co/security-labs/elastic-advances-llm-security)](https://www.elastic.co/security-labs/elastic-advances-llm-security)

**Tags**:
- Domain: LLM
- Data Source: AWS
- Data Source: AWS Bedrock
- Data Source: AWS S3
- Use Case: Policy Violation
- Mitre Atlas: T0015
- Mitre Atlas: T0034
- Mitre Atlas: T0046
- Resources: Investigation Guide

**Version**: 6
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Setup

This rule requires that AWS Bedrock Integration be configured. For more information, see the AWS Bedrock integration documentation:
[https://www.elastic.co/docs/current/integrations/aws_bedrock](https://www.elastic.co/docs/current/integrations/aws_bedrock)

## Investigation guide


## Triage and analysis


### Investigating AWS Bedrock Detected Multiple Validation Exception Errors by a Single User

Amazon Bedrock is AWS’s managed service that enables developers to build and scale generative AI applications using large foundation models (FMs) from top providers.
Bedrock offers a variety of pretrained models from Amazon (such as the Titan series), as well as models from providers like Anthropic, Meta, Cohere, and AI21 Labs.

#### Possible investigation steps

- Identify the user account that caused validation errors in accessing the Amazon Bedrock models.
- Investigate other alerts associated with the user account during the past 48 hours.
- Consider the time of day. If the user is a human (not a program or script), did the activity take place during a normal time of day?
- Examine the account's attempts to access Amazon Bedrock models in the last 24 hours.
- If you suspect the account has been compromised, scope potentially compromised assets by tracking Amazon Bedrock model access, prompts generated, and responses to the prompts by the account in the last 24 hours.


### False positive analysis

- Verify the user account that that caused validation errors is a legitimate misunderstanding by users on accessing the bedrock models.


### Response and remediation

- Initiate the incident response process based on the outcome of the triage.
- Disable or limit the account during the investigation and response.
- Identify the possible impact of the incident and prioritize accordingly; the following actions can help you gain context:
  - Identify the account role in the cloud environment.
- Identify if the attacker is moving laterally and compromising other Amazon Bedrock Services.
- Identify any regulatory or legal ramifications related to this activity.
- Identify if any implication to resource billing.
- Review the permissions assigned to the implicated user group or role behind these requests to ensure they are authorized and expected to access bedrock and ensure that the least privilege principle is being followed.
- Determine the initial vector abused by the attacker and take action to prevent reinfection via the same vector.
- Using the incident response data, update logging and audit policies to improve the mean time to detect (MTTD) and the mean time to respond (MTTR).


## Rule Query

```esql
from logs-aws_bedrock.invocation-*

// Truncate timestamp to 1-minute window
| eval Esql.time_window_date_trunc = date_trunc(1 minutes, @timestamp)

// Filter for validation exceptions in responses
| where gen_ai.response.error_code == "ValidationException"

// keep relevant ECS and derived fields
| keep
  user.id,
  gen_ai.request.model.id,
  cloud.account.id,
  gen_ai.response.error_code,
  Esql.time_window_date_trunc

// count number of denials by user/account/time window
| stats
    Esql.ml_response_validation_error_count = count(*)
  by
    Esql.time_window_date_trunc,
    user.id,
    cloud.account.id

// Filter for excessive errors
| where Esql.ml_response_validation_error_count > 3
```