﻿---
title: AWS Bedrock Detected Multiple Attempts to use Denied Models by a Single User
description: Identifies multiple successive failed attempts to use denied model resources within AWS Bedrock. This could indicated attempts to bypass limitations of...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/aws_bedrock/aws_bedrock_multiple_attempts_to_use_denied_models_by_user
products:
  - Elastic Security
---

# AWS Bedrock Detected Multiple Attempts to use Denied Models by a Single User
Identifies multiple successive failed attempts to use denied model resources within AWS Bedrock. This could indicated
attempts to bypass limitations of other approved models, or to force an impact on the environment by incurring
exhorbitant costs.
**Rule type**: esql
**Rule indices**:
**Rule Severity**: high
**Risk Score**: 73
**Runs every**: 10m
**Searches indices from**: `now-60m`
**Maximum alerts per execution**: 100
**References**:
- [[https://docs.aws.amazon.com/bedrock/latest/userguide/guardrails-components.html](https://docs.aws.amazon.com/bedrock/latest/userguide/guardrails-components.html)](https://docs.aws.amazon.com/bedrock/latest/userguide/guardrails-components.html)
- [[https://atlas.mitre.org/techniques/AML.T0015](https://atlas.mitre.org/techniques/AML.T0015)](https://atlas.mitre.org/techniques/AML.T0015)
- [[https://atlas.mitre.org/techniques/AML.T0034](https://atlas.mitre.org/techniques/AML.T0034)](https://atlas.mitre.org/techniques/AML.T0034)
- [[https://www.elastic.co/security-labs/elastic-advances-llm-security](https://www.elastic.co/security-labs/elastic-advances-llm-security)](https://www.elastic.co/security-labs/elastic-advances-llm-security)

**Tags**:
- Domain: LLM
- Data Source: AWS Bedrock
- Data Source: AWS S3
- Resources: Investigation Guide
- Use Case: Policy Violation
- Mitre Atlas: T0015
- Mitre Atlas: T0034

**Version**: 6
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Setup

This rule requires that guardrails are configured in AWS Bedrock. For more information, see the AWS Bedrock documentation:
[https://docs.aws.amazon.com/bedrock/latest/userguide/guardrails-create.html](https://docs.aws.amazon.com/bedrock/latest/userguide/guardrails-create.html)

## Investigation guide


## Triage and analysis


### Investigating AWS Bedrock Detected Multiple Attempts to use Denied Models by a Single User

Amazon Bedrock is AWS’s managed service that enables developers to build and scale generative AI applications using large foundation models (FMs) from top providers.
Bedrock offers a variety of pretrained models from Amazon (such as the Titan series), as well as models from providers like Anthropic, Meta, Cohere, and AI21 Labs.

#### Possible investigation steps

- Identify the user account that attempted to use denied models.
- Investigate other alerts associated with the user account during the past 48 hours.
- Consider the time of day. If the user is a human (not a program or script), did the activity take place during a normal time of day?
- Examine the account's attempts to access Amazon Bedrock models in the last 24 hours.
- If you suspect the account has been compromised, scope potentially compromised assets by tracking Amazon Bedrock model access, prompts generated, and responses to the prompts by the account in the last 24 hours.


### False positive analysis

- Verify the user account that attempted to use denied models, is a legitimate misunderstanding by users or overly strict policies.


### Response and remediation

- Initiate the incident response process based on the outcome of the triage.
- Disable or limit the account during the investigation and response.
- Identify the possible impact of the incident and prioritize accordingly; the following actions can help you gain context:
  - Identify the account role in the cloud environment.
- Identify if the attacker is moving laterally and compromising other Amazon Bedrock Services.
- Identify any regulatory or legal ramifications related to this activity.
- Review the permissions assigned to the implicated user group or role behind these requests to ensure they are authorized and expected to access bedrock and ensure that the least privilege principle is being followed.
- Determine the initial vector abused by the attacker and take action to prevent reinfection via the same vector.
- Using the incident response data, update logging and audit policies to improve the mean time to detect (MTTD) and the mean time to respond (MTTR).


## Rule Query

```esql
from logs-aws_bedrock.invocation-*

// Filter for access denied errors from GenAI responses
| where gen_ai.response.error_code == "AccessDeniedException"

// keep ECS and response fields
| keep
  user.id,
  gen_ai.request.model.id,
  cloud.account.id,
  gen_ai.response.error_code

// count total denials per user/model/account
| stats
    Esql.ml_response_access_denied_count = count(*)
  by
    user.id,
    gen_ai.request.model.id,
    cloud.account.id

// Filter for users with repeated denials
| where Esql.ml_response_access_denied_count > 3

// sort by volume of denials
| sort Esql.ml_response_access_denied_count desc
```