﻿---
title: AWS STS Role Chaining
description: Identifies role chaining activity. Role chaining is when you use one assumed role to assume a second role through the AWS CLI or API. While this a recognized...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/aws/privilege_escalation_sts_role_chaining
products:
  - Elastic Security
---

# AWS STS Role Chaining
Identifies role chaining activity. Role chaining is when you use one assumed role to assume a second role through the
AWS CLI or API. While this a recognized functionality in AWS, role chaining can be abused for privilege escalation if
the subsequent assumed role provides additional privileges. Role chaining can also be used as a persistence mechanism as
each AssumeRole action results in a refreshed session token with a 1 hour maximum duration. This is a new terms rule that looks for the first occurance of one role (aws.cloudtrail.user_identity.session_context.session_issuer.arn) assuming another (aws.cloudtrail.resources.arn).
**Rule type**: new_terms
**Rule indices**:
- filebeat-*
- logs-aws.cloudtrail-*

**Rule Severity**: medium
**Risk Score**: 47
**Runs every**: 
**Searches indices from**: `now-6m`
**Maximum alerts per execution**: 100
**References**:
- [[https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles.html#id_roles_terms-and-concepts](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles.html#id_roles_terms-and-concepts)](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles.html#id_roles_terms-and-concepts)
- [[https://www.uptycs.com/blog/detecting-anomalous-aws-sessions-temporary-credentials](https://www.uptycs.com/blog/detecting-anomalous-aws-sessions-temporary-credentials)](https://www.uptycs.com/blog/detecting-anomalous-aws-sessions-temporary-credentials)
- [[https://hackingthe.cloud/aws/post_exploitation/role-chain-juggling/](https://hackingthe.cloud/aws/post_exploitation/role-chain-juggling/)](https://hackingthe.cloud/aws/post_exploitation/role-chain-juggling/)

**Tags**:
- Domain: Cloud
- Data Source: AWS
- Data Source: Amazon Web Services
- Data Source: AWS STS
- Use Case: Threat Detection
- Tactic: Persistence
- Tactic: Privilege Escalation
- Tactic: Lateral Movement
- Resources: Investigation Guide

**Version**: 4
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Investigation guide


## Triage and analysis


### Investigating AWS STS Role Chaining

Role chaining occurs when a role assumed with temporary credentials (`AssumeRole`) is used to assume another role. While supported by AWS, chaining can increase risk of Privilege escalation, if the second role grants broader permissions; and Persistence, since each chained AssumeRole refreshes the session with up to 1-hour duration. This new terms rule triggers on the first observed combination of one role (`aws.cloudtrail.user_identity.session_context.session_issuer.arn`) assuming another (`aws.cloudtrail.resources.arn`).

### Possible investigation steps

- **Review Alert Context**: Investigate the alert, focusing on `aws.cloudtrail.user_identity.session_context.session_issuer.arn` (the calling role) and `aws.cloudtrail.resources.arn` (the target role).
- **Determine scope and intent.** Check `aws.cloudtrail.recipient_account_id` and `aws.cloudtrail.resources.account_id` fields to identify whether the chaining is Intra-account (within the same AWS account) or Cross-account (from another AWS account).
- **Check role privileges.** Compare policies of the calling and target roles. Determine if chaining increases permissions (for example, access to S3 data, IAM modifications, or admin privileges).
- **Correlate with other activity.** Look for related alerts or CloudTrail activity within ±30 minutes: policy changes, unusual S3 access, or use of sensitive APIs. Use `aws.cloudtrail.user_identity.arn` to track behavior from the same role session, use `aws.cloudtrail.user_identity.session_context.session_issuer.arn` to track broader behavior from the role itself.
- **Validate legitimacy.** Contact the account or service owner to confirm if the chaining was expected (for example, automation pipelines or federated access flows).
- **Geography & source.** Review `cloud.region`, `source.address`, and other `geo` fields to assess if the activity originates from expected regions or network ranges.


### False positive analysis

- **Expected role chaining.** Some organizations use role chaining as part of multi-account access strategies. Maintain an allowlist of known `issuer.arn` - `target.arn` pairs.
- **Automation and scheduled tasks.** CI/CD systems or monitoring tools may assume roles frequently. Validate by `userAgent` and historical behavior.
- **Test/dev environments.** Development accounts may generate experimental chaining patterns. Tune rules or exceptions to exclude low-risk accounts.


### Response and remediation

**Immediate steps**
- **Preserve evidence.** Export triggering CloudTrail events (±30 minutes) into a restricted evidence bucket. Include session context, source IP, and user agent.
- **Notify owners.** Contact the owners of both roles to validate intent.

**Containment (if suspicious)**
- **Revoke temporary credentials.** [Revoke Session Permissions](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use_revoke-sessions.html) if possible, or attach [AWSDenyALL policy](https://docs.aws.amazon.com/aws-managed-policy/latest/reference/AWSDenyAll.html) to the originating role.
- **Restrict risky roles.** Apply least-privilege policies or temporarily deny `sts:AssumeRole` for suspicious principals.
- **Enable monitoring.** Ensure CloudTrail and GuardDuty are active in all regions to detect further chaining.

**Scope and hunt**
- Search for additional AssumeRole activity by the same `issuer.arn` or `resources.arn` across other accounts and regions.
- Look for privilege escalation attempts (for example, IAM `AttachRolePolicy`, `UpdateAssumeRolePolicy`) or sensitive data access following the chain.

**Recovery & hardening**
- Apply least privilege to all roles, limiting trust policies to only required principals.
- Enforce MFA where possible on AssumeRole operations.
- Periodically review role chaining patterns to validate necessity; remove unused or risky trust relationships.
- Document and tune new terms exceptions for known, legitimate chains.


### Additional information

- [AWS IR Playbooks](https://github.com/aws-samples/aws-incident-response-playbooks/): NIST-aligned templates for evidence, containment, eradication, recovery, post-incident.
- [AWS Customer Playbook Framework](https://github.com/aws-samples/aws-customer-playbook-framework/): Practical response steps for account and IAM misuse scenarios
- AWS IAM Best Practices: [AWS docs](https://docs.aws.amazon.com/IAM/latest/UserGuide/best-practices.html) for reducing risk from temporary credentials.


## Setup

The AWS Fleet integration, Filebeat module, or similarly structured data is required to be compatible with this rule.

## Rule Query

```kuery
    event.dataset : "aws.cloudtrail" and 
    event.provider : "sts.amazonaws.com" and 
    event.action : "AssumeRole" and 
    aws.cloudtrail.user_identity.type : "AssumedRole" and 
    event.outcome : "success" 
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Privilege Escalation
- Id: TA0004
- Reference URL: [[https://attack.mitre.org/tactics/TA0004/](https://attack.mitre.org/tactics/TA0004/)](https://attack.mitre.org/tactics/TA0004/)
- Technique:
  - Name: Abuse Elevation Control Mechanism
- Id: T1548
- Reference URL: [[https://attack.mitre.org/techniques/T1548/](https://attack.mitre.org/techniques/T1548/)](https://attack.mitre.org/techniques/T1548/)

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Lateral Movement
- Id: TA0008
- Reference URL: [[https://attack.mitre.org/tactics/TA0008/](https://attack.mitre.org/tactics/TA0008/)](https://attack.mitre.org/tactics/TA0008/)
- Technique:
  - Name: Use Alternate Authentication Material
- Id: T1550
- Reference URL: [[https://attack.mitre.org/techniques/T1550/](https://attack.mitre.org/techniques/T1550/)](https://attack.mitre.org/techniques/T1550/)
- Sub Technique:
  - Name: Application Access Token
- Id: T1550.001
- Reference URL: [[https://attack.mitre.org/techniques/T1550/001/](https://attack.mitre.org/techniques/T1550/001/)](https://attack.mitre.org/techniques/T1550/001/)

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Persistence
- Id: TA0003
- Reference URL: [[https://attack.mitre.org/tactics/TA0003/](https://attack.mitre.org/tactics/TA0003/)](https://attack.mitre.org/tactics/TA0003/)