﻿---
title: AWS STS Role Assumption by User
description: Identifies when a user or role has assumed a role in AWS Security Token Service (STS). Users can assume a role to obtain temporary credentials and access...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/aws/privilege_escalation_role_assumption_by_user
products:
  - Elastic Security
---

# AWS STS Role Assumption by User
Identifies when a user or role has assumed a role in AWS Security Token Service (STS). Users can assume a role to obtain
temporary credentials and access AWS resources. Adversaries can use this technique for credential access and privilege
escalation. This is a New Terms rule that identifies when a service assumes a role in AWS Security Token Service (STS)
to obtain temporary credentials and access AWS resources. While often legitimate, adversaries may use this technique for
unauthorized access, privilege escalation, or lateral movement within an AWS environment.
**Rule type**: new_terms
**Rule indices**:
- filebeat-*
- logs-aws.cloudtrail-*

**Rule Severity**: low
**Risk Score**: 21
**Runs every**: 
**Searches indices from**: `now-6m`
**Maximum alerts per execution**: 100
**References**:
- [[https://docs.aws.amazon.com/STS/latest/APIReference/API_AssumeRole.html](https://docs.aws.amazon.com/STS/latest/APIReference/API_AssumeRole.html)](https://docs.aws.amazon.com/STS/latest/APIReference/API_AssumeRole.html)

**Tags**:
- Domain: Cloud
- Data Source: AWS
- Data Source: Amazon Web Services
- Data Source: AWS STS
- Resources: Investigation Guide
- Use Case: Identity and Access Audit
- Tactic: Privilege Escalation
- Tactic: Lateral Movement

**Version**: 6
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Investigation guide


## Triage and analysis


### Investigating AWS STS Role Assumption by User

This rule detects when a user assumes a role in AWS Security Token Service (STS), receiving temporary credentials to access AWS resources. While often used for legitimate purposes, this action can be leveraged by adversaries to obtain unauthorized access, escalate privileges, or move laterally within an AWS environment.

#### Possible Investigation Steps

- **Identify the User and Assumed Role**:
  - **User Identity**: Check `aws.cloudtrail.user_identity.arn` and `aws.cloudtrail.user_identity.type` for details about the initiator of the `AssumeRole` action.
- **Role Assumed**: Review `aws.cloudtrail.resources.arn` to confirm the role assumed and ensure it aligns with the user’s standard permissions.
- **Session Name**: Note `aws.cloudtrail.flattened.request_parameters.roleSessionName` for context on the purpose of the session.
- **Expiration Time**: Use `aws.cloudtrail.flattened.response_elements.credentials.expiration` to confirm the credential expiration.
- **Inspect User Agent and Source Information**:
  - **User Agent**: Analyze the `user_agent.original` field to identify if specific tooling or SDKs like AWS CLI, Boto3, or custom agents were used.
- **Source IP and Geolocation**: Examine `source.ip` and `source.geo` fields to determine the origin of the request, confirming if it aligns with expected locations.
- **Correlate with Related Events**:
  - **Identify Patterns**: Review related CloudTrail events for unusual access patterns, such as resource access or sensitive actions following this `AssumeRole` action.
- **Filter High-Volume Roles**: If this role or user has a high volume of access, evaluate `roleArn` or `user_agent` values for common patterns and add trusted entities as exceptions.
- **Review the Privileges of the Assumed Role**:
  - **Permissions**: Examine permissions associated with the `roleArn` to assess its access scope.
- **Authorized Usage**: Confirm if the role is used frequently for administrative purposes and if this aligns with the user’s regular responsibilities.


### False Positive Analysis

- **Automated Processes and Applications**: Applications or scheduled tasks may assume roles regularly for operational purposes. Validate the consistency of the `user_agent` or `roleArn` with known automated workflows.
- **Standard IAM Policy Usage**: Confirm if the user or application routinely assumes new roles for normal operations by reviewing historical activity.


### Response and Remediation

- **Terminate Unauthorized Sessions**: If the role assumption is deemed unauthorized, revoke the session by modifying IAM policies or the permissions associated with the assumed role.
- **Strengthen Monitoring and Alerts**: Implement additional monitoring for specific high-risk roles, especially those with elevated permissions.
- **Regularly Manage Exceptions**: Regularly review high-volume roles and user agent patterns to refine alerts, minimizing noise by adding trusted patterns as exceptions.
- **Incident Response**: If confirmed as malicious, follow incident response protocols for containment, investigation, and remediation.


### Additional Information

For more details on managing and securing AWS STS in your environment, refer to the [AWS STS documentation](https://docs.aws.amazon.com/STS/latest/APIReference/API_AssumeRole.html).

## Rule Query

```kuery
event.dataset: "aws.cloudtrail"
    and event.provider: "sts.amazonaws.com"
    and event.action: "AssumeRole"
    and event.outcome: "success"
    and aws.cloudtrail.user_identity.type: ("AssumedRole" or "IAMUser")
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Privilege Escalation
- Id: TA0004
- Reference URL: [[https://attack.mitre.org/tactics/TA0004/](https://attack.mitre.org/tactics/TA0004/)](https://attack.mitre.org/tactics/TA0004/)
- Technique:
  - Name: Abuse Elevation Control Mechanism
- Id: T1548
- Reference URL: [[https://attack.mitre.org/techniques/T1548/](https://attack.mitre.org/techniques/T1548/)](https://attack.mitre.org/techniques/T1548/)

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Lateral Movement
- Id: TA0008
- Reference URL: [[https://attack.mitre.org/tactics/TA0008/](https://attack.mitre.org/tactics/TA0008/)](https://attack.mitre.org/tactics/TA0008/)
- Technique:
  - Name: Use Alternate Authentication Material
- Id: T1550
- Reference URL: [[https://attack.mitre.org/techniques/T1550/](https://attack.mitre.org/techniques/T1550/)](https://attack.mitre.org/techniques/T1550/)
- Sub Technique:
  - Name: Application Access Token
- Id: T1550.001
- Reference URL: [[https://attack.mitre.org/techniques/T1550/001/](https://attack.mitre.org/techniques/T1550/001/)](https://attack.mitre.org/techniques/T1550/001/)