﻿---
title: AWS IAM AdministratorAccess Policy Attached to Role
description: An adversary with access to a set of compromised credentials may attempt to persist or escalate privileges by attaching additional permissions to compromised...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/aws/privilege_escalation_iam_administratoraccess_policy_attached_to_role
products:
  - Elastic Security
---

# AWS IAM AdministratorAccess Policy Attached to Role
An adversary with access to a set of compromised credentials may attempt to persist or escalate privileges by attaching
additional permissions to compromised IAM roles. This rule looks for use of the IAM AttachRolePolicy API operation to
attach the highly permissive AdministratorAccess AWS managed policy to an existing IAM role.
**Rule type**: eql
**Rule indices**:
- logs-aws.cloudtrail-*

**Rule Severity**: medium
**Risk Score**: 47
**Runs every**: 
**Searches indices from**: `now-6m`
**Maximum alerts per execution**: 100
**References**:
- [[https://docs.aws.amazon.com/IAM/latest/APIReference/API_AttachRolePolicy.html](https://docs.aws.amazon.com/IAM/latest/APIReference/API_AttachRolePolicy.html)](https://docs.aws.amazon.com/IAM/latest/APIReference/API_AttachRolePolicy.html)
- [[https://docs.aws.amazon.com/aws-managed-policy/latest/reference/AdministratorAccess.html](https://docs.aws.amazon.com/aws-managed-policy/latest/reference/AdministratorAccess.html)](https://docs.aws.amazon.com/aws-managed-policy/latest/reference/AdministratorAccess.html)
- [[https://hackingthe.cloud/aws/exploitation/iam_privilege_escalation/](https://hackingthe.cloud/aws/exploitation/iam_privilege_escalation/)](https://hackingthe.cloud/aws/exploitation/iam_privilege_escalation/)

**Tags**:
- Domain: Cloud
- Data Source: AWS
- Data Source: Amazon Web Services
- Data Source: AWS IAM
- Use Case: Identity and Access Audit
- Tactic: Privilege Escalation
- Tactic: Persistence
- Resources: Investigation Guide

**Version**: 8
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Investigation guide


## Triage and analysis


### Investigating AWS IAM AdministratorAccess Policy Attached to Role

The `AdministratorAccess` managed policy grants unrestricted privileges.

When attached to a role, it can enable privilege escalation or persistence, especially if the role is assumable by other accounts or services.

This rule detects `AttachRolePolicy` events where the `policyName` is `AdministratorAccess`.

#### Possible investigation steps

- **Identify both identities.**

  Determine the calling user or role (`aws.cloudtrail.user_identity.arn`) and the target role (`aws.cloudtrail.request_parameters.roleName`).

  Validate whether this change aligns with intended administrative actions.
- **Review the target role’s trust policy.**

  Examine who can assume the role (`AssumeRolePolicyDocument`).

  If the role is assumable by external accounts, this may indicate a potential persistence or lateral movement path.
- **Review CloudTrail details.**

  Check `source.ip`, `user_agent.original`, and `source.geo` fields for anomalies.

  Compare with historical operations by the same principal.
- **Correlate with adjacent IAM events.**

  Look for `UpdateAssumeRolePolicy`, `CreateAccessKey`, or `PassRole` calls.

  These often accompany privilege escalation activity.
- **Inspect downstream activity.**

  Query CloudTrail for recent `AssumeRole` calls for the target role — determine if the newly elevated permissions were used.


### False positive analysis

- **Delegated role management.**

  Cloud administrators may legitimately grant temporary AdministratorAccess for troubleshooting. Confirm through tickets or change logs.
- **Automation or service-linked roles.**

  Some services attach policies automatically for setup; verify whether the target is a service-linked role.


### Response and remediation

**Immediate containment**
- Detach the policy. Remove the `AdministratorAccess` policy from the target role.
- Restrict access. Temporarily revoke the caller’s IAM privileges until the legitimacy of the action is confirmed.
- Audit trust policies. Review the role’s trust relationships to ensure only approved principals can assume it.
- Rotate credentials for any principals who assumed the affected role during the period of elevated privileges.

**Evidence preservation**
- Export the triggering `AttachRolePolicy` event and related CloudTrail entries ±30 minutes from the alert.
- Preserve AWS Config snapshots and GuardDuty findings for traceability.

**Scoping and investigation**
- Identify if the elevated role was subsequently assumed.

  Correlate by matching `aws.cloudtrail.eventName:AssumeRole` with the target role ARN.
- Search for other recent IAM policy attachments or modifications by the same actor or IP.

**Recovery and hardening**
- Apply least privilege policies; limit who can attach or modify administrative policies.
- Enforce IAM Conditions such as `aws:PrincipalArn` or `aws:ResourceTag` to limit policy attachment scope.
- Enable CloudTrail, GuardDuty, and Security Hub across all regions.
- Implement SCPs at the organization level to restrict direct `AdministratorAccess` attachments.


### Additional information

- **[AWS IR Playbooks](https://github.com/aws-samples/aws-incident-response-playbooks/blob/c151b0dc091755fffd4d662a8f29e2f6794da52c/playbooks/): response steps related to IAM policy modification and unauthorized privilege escalation..
- **[AWS Customer Playbook Framework](https://github.com/aws-samples/aws-customer-playbook-framework/): for containment, analysis, and recovery guidance.
- **AWS Documentation:** [AdministratorAccess Policy](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_job-functions.html#jf_administrator).


## Rule Query

```eql
iam where event.dataset == "aws.cloudtrail"
   and event.provider == "iam.amazonaws.com"
   and event.action == "AttachRolePolicy"
   and event.outcome == "success"
   and stringContains(aws.cloudtrail.request_parameters, "policyArn=arn:aws:iam::aws:policy/AdministratorAccess")
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Privilege Escalation
- Id: TA0004
- Reference URL: [[https://attack.mitre.org/tactics/TA0004/](https://attack.mitre.org/tactics/TA0004/)](https://attack.mitre.org/tactics/TA0004/)
- Technique:
  - Name: Account Manipulation
- Id: T1098
- Reference URL: [[https://attack.mitre.org/techniques/T1098/](https://attack.mitre.org/techniques/T1098/)](https://attack.mitre.org/techniques/T1098/)
- Sub Technique:
  - Name: Additional Cloud Roles
- Id: T1098.003
- Reference URL: [[https://attack.mitre.org/techniques/T1098/003/](https://attack.mitre.org/techniques/T1098/003/)](https://attack.mitre.org/techniques/T1098/003/)

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Persistence
- Id: TA0003
- Reference URL: [[https://attack.mitre.org/tactics/TA0003/](https://attack.mitre.org/tactics/TA0003/)](https://attack.mitre.org/tactics/TA0003/)
- Technique:
  - Name: Account Manipulation
- Id: T1098
- Reference URL: [[https://attack.mitre.org/techniques/T1098/](https://attack.mitre.org/techniques/T1098/)](https://attack.mitre.org/techniques/T1098/)
- Sub Technique:
  - Name: Additional Cloud Roles
- Id: T1098.003
- Reference URL: [[https://attack.mitre.org/techniques/T1098/003/](https://attack.mitre.org/techniques/T1098/003/)](https://attack.mitre.org/techniques/T1098/003/)