﻿---
title: AWS EC2 Route Table Created
description: Identifies when an EC2 Route Table has been created. Route tables can be used by attackers to disrupt network traffic, reroute communications, or maintain...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/aws/persistence_route_table_created
products:
  - Elastic Security
---

# AWS EC2 Route Table Created
Identifies when an EC2 Route Table has been created. Route tables can be used by attackers to disrupt network traffic, reroute communications, or maintain persistence in a compromised environment. This is a New Terms rule that detects the first instance of this behavior by a user or role.
**Rule type**: new_terms
**Rule indices**:
- filebeat-*
- logs-aws.cloudtrail-*

**Rule Severity**: low
**Risk Score**: 21
**Runs every**: 
**Searches indices from**: `now-6m`
**Maximum alerts per execution**: 100
**References**:
- [[https://docs.datadoghq.com/security_platform/default_rules/aws-ec2-route-table-modified/](https://docs.datadoghq.com/security_platform/default_rules/aws-ec2-route-table-modified/)](https://docs.datadoghq.com/security_platform/default_rules/aws-ec2-route-table-modified/)
- [[https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateRoute.html](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateRoute.html)](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateRoute.html)
- [[https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateRouteTable](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateRouteTable)](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateRouteTable)

**Tags**:
- Domain: Cloud
- Data Source: AWS
- Data Source: Amazon Web Services
- Data Source: AWS EC2
- Use Case: Network Security Monitoring
- Tactic: Persistence
- Resources: Investigation Guide

**Version**: 212
**Rule authors**:
- Elastic
- Austin Songer

**Rule license**: Elastic License v2

## Investigation guide


## Triage and analysis


### Investigating AWS EC2 Route Table Created

AWS Route Tables are crucial components in managing network traffic within AWS environments, directing data between subnets and internet gateways. Adversaries may exploit route tables to reroute traffic for data exfiltration or to establish persistence by creating unauthorized routes. The detection rule monitors successful creation events of route tables, flagging potential misuse by correlating specific AWS CloudTrail logs, thus aiding in identifying unauthorized network configuration changes.

### Possible investigation steps

- Investigate the AWS account and IAM user or role to determine if the action aligns with expected behavior and permissions.
- Examine the newly created route table's configuration to identify any unauthorized or suspicious routes that could indicate potential misuse or data exfiltration attempts.
- Correlate the event with other network security monitoring data to identify any unusual traffic patterns or anomalies that coincide with the route table creation.
- Assess the environment for any recent changes or incidents that might explain the creation of the route table, such as new deployments or infrastructure modifications.


### False positive analysis

- Routine infrastructure updates or deployments may trigger route table creation events. To manage this, establish a baseline of expected behavior during scheduled maintenance windows and exclude these from alerts.
- Automated cloud management tools often create route tables as part of their operations. Identify these tools and create exceptions for their known activities to reduce noise.
- Development and testing environments frequently undergo changes, including the creation of route tables. Consider excluding these environments from alerts or applying a different set of monitoring rules.
- Legitimate changes by authorized personnel can be mistaken for suspicious activity. Implement a process to verify and document authorized changes, allowing for quick exclusion of these events from alerts.
- Multi-account AWS setups might have centralized networking teams that create route tables across accounts. Coordinate with these teams to understand their activities and exclude them from triggering alerts.


### Response and remediation

- If unauthorized, remove permissions for related actions from the user or role. You can use the managed [AWSDenyAll](https://docs.aws.amazon.com/aws-managed-policy/latest/reference/AWSDenyAll.html) policy.
- Review the newly created route table and any associated routes to identify unauthorized entries. Remove any routes that are not part of the expected network configuration.
- Conduct a thorough audit of IAM roles and permissions to ensure that only authorized users have the ability to create or modify route tables. Revoke any excessive permissions identified.
- Implement network monitoring to detect unusual traffic patterns that may indicate data exfiltration or other malicious activities.
- Escalate the incident to the security operations team for further investigation and to determine if additional AWS resources have been compromised.
- Review AWS CloudTrail logs for any other suspicious activities around the time of the route table creation to identify potential indicators of compromise.
- Update security policies and procedures to include specific guidelines for monitoring and responding to unauthorized route table modifications, ensuring rapid detection and response in the future.


## Setup

The AWS Fleet integration, Filebeat module, or similarly structured data is required to be compatible with this rule.

## Rule Query

```kuery
event.dataset: "aws.cloudtrail"
    and event.provider: "ec2.amazonaws.com" 
    and event.action:(
        "CreateRoute" or 
        "CreateRouteTable"
    ) 
    and event.outcome: "success"
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Persistence
- Id: TA0003
- Reference URL: [[https://attack.mitre.org/tactics/TA0003/](https://attack.mitre.org/tactics/TA0003/)](https://attack.mitre.org/tactics/TA0003/)