﻿---
title: AWS IAM Group Creation
description: Identifies the creation of a group in AWS Identity and Access Management (IAM). Groups specify permissions for multiple users. Any user in a group automatically...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/aws/persistence_iam_group_creation
products:
  - Elastic Security
---

# AWS IAM Group Creation
Identifies the creation of a group in AWS Identity and Access Management (IAM). Groups specify permissions for multiple
users. Any user in a group automatically has the permissions that are assigned to the group. Adversaries who obtain
credentials with IAM write privileges may create a new group as a foothold for persistence: they can later attach
admin-level policies to the group and quietly add users or roles to inherit those privileges.
**Rule type**: query
**Rule indices**:
- filebeat-*
- logs-aws.cloudtrail-*

**Rule Severity**: low
**Risk Score**: 21
**Runs every**: 
**Searches indices from**: `now-6m`
**Maximum alerts per execution**: 100
**References**:
- [[https://awscli.amazonaws.com/v2/documentation/api/latest/reference/iam/create-group.html](https://awscli.amazonaws.com/v2/documentation/api/latest/reference/iam/create-group.html)](https://awscli.amazonaws.com/v2/documentation/api/latest/reference/iam/create-group.html)
- [[https://docs.aws.amazon.com/IAM/latest/APIReference/API_CreateGroup.html](https://docs.aws.amazon.com/IAM/latest/APIReference/API_CreateGroup.html)](https://docs.aws.amazon.com/IAM/latest/APIReference/API_CreateGroup.html)

**Tags**:
- Domain: Cloud
- Data Source: AWS
- Data Source: Amazon Web Services
- Data Source: AWS IAM
- Use Case: Identity and Access Audit
- Tactic: Persistence
- Resources: Investigation Guide

**Version**: 211
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Investigation guide


## Triage and analysis


### Investigating AWS IAM Group Creation

AWS IAM allows organizations to manage user access and permissions securely. Groups in IAM simplify permission management by allowing multiple users to inherit the same permissions. However, adversaries may exploit this by creating unauthorized groups to gain persistent access. This alert fires on `CreateGroup`. New group creation may indicate attacker staging for persistence, especially if followed by policy attachments or user additions.

#### Possible investigation steps

- **Identify the actor and context**
  - Check `aws.cloudtrail.user_identity.arn`, `aws.cloudtrail.user_identity.access_key_id` to determine who performed the group creation.
- Review `source.ip`, `user_agent.original`, `cloud.account.id`, `cloud.region` for unusual network, client, or region usage.
- **Examine the group details**
  - From `aws.cloudtrail.response_elements`, extract `groupName` and `path` (e.g., /service/, /dev/).
- Look for immediate follow-on changes by the same actor within the next 15–30 minutes:
  - AttachGroupPolicy (especially AdministratorAccess or broad s3:*, iam:*).
- AddUserToGroup (who was added and when?).
- Use GetGroup to enumerate current group membership and attached policies during triage.
- **Correlate with broader activity**
  - Look for prior suspicious actions by the same user: `AssumeRole`, `CreateAccessKey`, new IAM user/role.
- After group creation, watch for data-access or configuration changes (e.g., S3 policy updates, KMS key policy changes)


### False positive analysis

- IAM onboarding workflows or DevOps pipelines creating groups for new projects can trigger this alert.
- Test or sandbox accounts often create and delete groups routinely, validate account context and approval flows.


### Response and remediation:

- **Containment**:
  - If suspicious, disable further changes by the actor (temporarily remove IAM write privileges or deactivate keys).
- Place a change freeze on the newly created group (block `AttachGroupPolicy`/`AddUserToGroup` via SCP/permissions boundary until review completes).
- **Investigation and scoping**:
  - Use `GetGroup`, `ListAttachedGroupPolicies`, `ListUsersInGroup` to enumerate the group’s state and identify any suspicious policies or members. Investigate any attached policies granting broad privileges.
- Hunt for same-actor `AttachGroupPolicy`/`AddUserToGroup` events across the last 24–48h.
- **Recovery and hardening**:
  - Delete unauthorized, unused or suspicious groups. remove rogue policies/members.
- Restrict who can call `iam:CreateGroup`, `iam:AttachGroupPolicy`, and `iam:AddUserToGroup` (least privilege).


### Additional information

[AWS Security Best Practices](https://aws.amazon.com/premiumsupport/knowledge-center/security-best-practices/)

## Rule Query

```kuery
event.dataset: aws.cloudtrail and 
    event.provider: iam.amazonaws.com and 
    event.action: CreateGroup and 
    event.outcome: success
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Persistence
- Id: TA0003
- Reference URL: [[https://attack.mitre.org/tactics/TA0003/](https://attack.mitre.org/tactics/TA0003/)](https://attack.mitre.org/tactics/TA0003/)
- Technique:
  - Name: Create Account
- Id: T1136
- Reference URL: [[https://attack.mitre.org/techniques/T1136/](https://attack.mitre.org/techniques/T1136/)](https://attack.mitre.org/techniques/T1136/)
- Sub Technique:
  - Name: Cloud Account
- Id: T1136.003
- Reference URL: [[https://attack.mitre.org/techniques/T1136/003/](https://attack.mitre.org/techniques/T1136/003/)](https://attack.mitre.org/techniques/T1136/003/)