﻿---
title: AWS EC2 Network Access Control List Creation
description: Identifies the creation of an AWS EC2 network access control list (ACL) or an entry in a network ACL with a specified rule number. Adversaries may exploit...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/aws/persistence_ec2_network_acl_creation
products:
  - Elastic Security
---

# AWS EC2 Network Access Control List Creation
Identifies the creation of an AWS EC2 network access control list (ACL) or an entry in a network ACL with a specified rule number. Adversaries may exploit ACLs to establish persistence or exfiltrate data by creating permissive rules.
**Rule type**: query
**Rule indices**:
- filebeat-*
- logs-aws.cloudtrail-*

**Rule Severity**: low
**Risk Score**: 21
**Runs every**: 5m
**Searches indices from**: `now-6m`
**Maximum alerts per execution**: 100
**References**:
- [[https://awscli.amazonaws.com/v2/documentation/api/latest/reference/ec2/create-network-acl.html](https://awscli.amazonaws.com/v2/documentation/api/latest/reference/ec2/create-network-acl.html)](https://awscli.amazonaws.com/v2/documentation/api/latest/reference/ec2/create-network-acl.html)
- [[https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateNetworkAcl.html](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateNetworkAcl.html)](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateNetworkAcl.html)
- [[https://awscli.amazonaws.com/v2/documentation/api/latest/reference/ec2/create-network-acl-entry.html](https://awscli.amazonaws.com/v2/documentation/api/latest/reference/ec2/create-network-acl-entry.html)](https://awscli.amazonaws.com/v2/documentation/api/latest/reference/ec2/create-network-acl-entry.html)
- [[https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateNetworkAclEntry.html](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateNetworkAclEntry.html)](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateNetworkAclEntry.html)

**Tags**:
- Domain: Cloud
- Data Source: AWS
- Data Source: Amazon Web Services
- Data Source: AWS EC2
- Use Case: Network Security Monitoring
- Tactic: Persistence
- Tactic: Defense Evasion
- Resources: Investigation Guide

**Version**: 211
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Investigation guide


## Triage and analysis


### Investigating AWS EC2 Network Access Control List Creation

AWS EC2 Network ACLs are stateless firewalls for controlling inbound and outbound traffic at the subnet level. Adversaries may exploit ACLs to establish persistence or exfiltrate data by creating permissive rules. The detection rule monitors successful creation events of ACLs or entries, flagging potential unauthorized modifications that align with persistence tactics, aiding in early threat identification.

### Possible investigation steps

- Review the CloudTrail logs for the specific event.dataset:aws.cloudtrail entries to identify the user or role (event.user) that initiated the CreateNetworkAcl or CreateNetworkAclEntry actions.
- Examine the event.provider:ec2.amazonaws.com logs to determine the IP addresses and locations associated with the request to assess if they are expected or suspicious.
- Check the event.action details to understand the specific rules created in the Network ACL, focusing on any overly permissive rules that could indicate a security risk.
- Investigate the event.outcome:success entries to confirm the successful creation of the ACL or ACL entry and correlate with any other suspicious activities in the AWS environment.
- Cross-reference the event with other security alerts or logs to identify any patterns or anomalies that could suggest malicious intent or unauthorized access.
- Assess the impact of the new ACL rules on the network security posture, ensuring they do not inadvertently allow unauthorized access or data exfiltration.


### False positive analysis

- Routine infrastructure updates or deployments may trigger the creation of new network ACLs or entries. To manage this, establish a baseline of expected changes during scheduled maintenance windows and exclude these from alerts.
- Automated scripts or infrastructure-as-code tools like Terraform or CloudFormation can create network ACLs as part of normal operations. Identify and whitelist these automated processes to prevent unnecessary alerts.
- Changes made by trusted administrators or security teams for legitimate purposes can be mistaken for suspicious activity. Implement a process to log and review approved changes, allowing you to exclude these from detection.
- Temporary ACLs created for troubleshooting or testing purposes can generate alerts. Document and track these activities, and use tags or naming conventions to easily identify and exclude them from monitoring.
- Third-party services or integrations that require specific network configurations might create ACLs. Review and validate these services, and if deemed safe, add them to an exception list to reduce false positives.


### Response and remediation

- Immediately review the AWS CloudTrail logs to confirm the creation of the Network ACL or entry and identify the IAM user or role responsible for the action. This helps determine if the action was authorized or potentially malicious.
- Revoke any suspicious or unauthorized IAM credentials associated with the creation of the Network ACL or entry to prevent further unauthorized access.
- Modify or delete the newly created Network ACL or entry if it is determined to be unauthorized or overly permissive, ensuring that it aligns with your organization's security policies.
- Conduct a security review of the affected AWS environment to identify any other unauthorized changes or indicators of compromise, focusing on persistence mechanisms.
- Implement additional monitoring and alerting for changes to Network ACLs and other critical AWS resources to enhance detection of similar threats in the future.
- Escalate the incident to the security operations team or incident response team for further investigation and to determine if additional containment or remediation actions are necessary.
- Review and update IAM policies and permissions to ensure the principle of least privilege is enforced, reducing the risk of unauthorized changes to network configurations.


## Rule Query

```kuery
event.dataset:aws.cloudtrail and event.provider:ec2.amazonaws.com and event.action:(CreateNetworkAcl or CreateNetworkAclEntry) and event.outcome:success
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Persistence
- Id: TA0003
- Reference URL: [[https://attack.mitre.org/tactics/TA0003/](https://attack.mitre.org/tactics/TA0003/)](https://attack.mitre.org/tactics/TA0003/)
- Technique:
  - Name: External Remote Services
- Id: T1133
- Reference URL: [[https://attack.mitre.org/techniques/T1133/](https://attack.mitre.org/techniques/T1133/)](https://attack.mitre.org/techniques/T1133/)

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Defense Evasion
- Id: TA0005
- Reference URL: [[https://attack.mitre.org/tactics/TA0005/](https://attack.mitre.org/tactics/TA0005/)](https://attack.mitre.org/tactics/TA0005/)
- Technique:
  - Name: Impair Defenses
- Id: T1562
- Reference URL: [[https://attack.mitre.org/techniques/T1562/](https://attack.mitre.org/techniques/T1562/)](https://attack.mitre.org/techniques/T1562/)
- Sub Technique:
  - Name: Disable or Modify Cloud Firewall
- Id: T1562.007
- Reference URL: [[https://attack.mitre.org/techniques/T1562/007/](https://attack.mitre.org/techniques/T1562/007/)](https://attack.mitre.org/techniques/T1562/007/)