﻿---
title: AWS IAM Virtual MFA Device Registration Attempt with Session Token
description: Detects attempts to create or enable a Virtual MFA device (CreateVirtualMFADevice, EnableMFADevice) using temporary AWS credentials (access keys beginning...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/aws/persistence_aws_attempt_to_register_virtual_mfa_device
products:
  - Elastic Security
---

# AWS IAM Virtual MFA Device Registration Attempt with Session Token
Detects attempts to create or enable a Virtual MFA device (CreateVirtualMFADevice, EnableMFADevice) using temporary AWS
credentials (access keys beginning with ASIA). Session credentials are short-lived and tied to existing authenticated
sessions, so using them to register or enable MFA devices is unusual. Adversaries who compromise temporary credentials
may abuse this behavior to establish persistence by attaching new MFA devices to maintain access to high-privilege
accounts despite key rotation or password resets.
**Rule type**: eql
**Rule indices**:
- filebeat-*
- logs-aws.cloudtrail-*

**Rule Severity**: medium
**Risk Score**: 47
**Runs every**: 
**Searches indices from**: `now-6m`
**Maximum alerts per execution**: 100
**References**:
- [[https://www.sygnia.co/blog/sygnia-investigation-bybit-hack/](https://www.sygnia.co/blog/sygnia-investigation-bybit-hack/)](https://www.sygnia.co/blog/sygnia-investigation-bybit-hack/)

**Tags**:
- Domain: Cloud
- Data Source: AWS
- Data Source: Amazon Web Services
- Data Source: AWS CloudTrail
- Data Source: AWS IAM
- Tactic: Persistence
- Use Case: Identity and Access Audit
- Resources: Investigation Guide

**Version**: 4
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Investigation guide


## Triage and Analysis


### Investigating AWS IAM Virtual MFA Device Registration Attempt with Session Token

Temporary credentials that start with the prefix `ASIA` are generated by the AWS Security Token Service (STS). These
session tokens are used for short-lived operations and should not be used to modify or register IAM
authentication mechanisms. This rule detects cases where an IAM user or role uses such temporary credentials to invoke either `CreateVirtualMFADevice` or `EnableMFADevice`.

#### Possible investigation steps

- **Identify the actor and session context**
  - Review `aws.cloudtrail.user_identity.arn` and `aws.cloudtrail.user_identity.access_key_id` to determine the identity and confirm the `ASIA` prefix.
- If you ingest `event.original`, look for `sessionCredentialFromConsole: true` to determine if the temporary token is from a console login session (which uses temporary session tokens in the backend) rather than compromised session tokens.
- Check `user_agent.original`, `source.ip`, and `cloud.region` to determine if this activity originated from an expected host, VPN, or location.
- Cross-reference with prior activity by this identity—especially `GetSessionToken`, `AssumeRole`, or `GetCallerIdentity` calls.
- **Correlate related IAM events**
  - Search for subsequent or preceding calls to:
  - `EnableMFADevice` (after `CreateVirtualMFADevice`)
- `DeactivateMFADevice` or `DeleteVirtualMFADevice`
- `ListMFADevices`, `ListUsers`, or `UpdateLoginProfile`
- Review whether new MFA devices were successfully enabled (`event.outcome:success`).
- **Assess session scope and privileges**
  - Identify what IAM policies are attached to the user or role that issued this request.
- If the temporary credentials were created via `AssumeRole` or `GetSessionToken`, check the originating principal’s permissions.
- **Investigate possible persistence**
  - Look for new MFA devices listed for privileged users (e.g., account root or admin roles).
- Review login history for those accounts following the MFA change.


### False positive analysis

- **Legitimate Administrative or Automated Actions**

  Certain IAM administrative workflows or CI/CD automation tools may register or enable MFA devices using temporary
  session credentials. Confirm whether the calling principal is part of an authorized automation process or a known
  identity performing account configuration tasks.
- **Expected Console Behavior**

  When users create or enable Virtual MFA devices through the **AWS Management Console**, AWS automatically issues
  temporary STS credentials (with access key IDs beginning with `ASIA`) for that session. As a result, these events will
  appear identical to programmatic usage of session tokens in CloudTrail logs.

  This is expected and does not indicate compromise.


### Response and remediation

- **Immediate containment**
  - Revoke or expire the temporary credentials (`aws sts revoke-session` if applicable).
- Disable or delete any newly created virtual MFA devices using `DeleteVirtualMFADevice`.
- Rotate passwords and long-term access keys for the associated IAM users.
- **Investigation and scoping**
  - Review CloudTrail logs for related IAM modifications (`UpdateLoginProfile`, `AttachUserPolicy`, `CreateAccessKey`).
- Identify any new API keys or tokens created after the MFA registration.
- Cross-check whether the attacker leveraged the new MFA binding for session persistence or login.
- **Recovery and hardening**
  - Enforce the `iam:EnableMFADevice` and `iam:CreateVirtualMFADevice` permissions only for trusted admin roles.
- Implement `aws:MultiFactorAuthPresent` conditions in IAM policies.
- Monitor for any future `ASIA` credential–based IAM configuration changes.


### Additional information

- **[AWS IR Playbooks](https://github.com/aws-samples/aws-incident-response-playbooks/blob/c151b0dc091755fffd4d662a8f29e2f6794da52c/playbooks/)**
- **[AWS Customer Playbook Framework](https://github.com/aws-samples/aws-customer-playbook-framework/tree/a8c7b313636b406a375952ac00b2d68e89a991f2/docs)**
- **[Managing MFA Devices in IAM](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_mfa.html)**


## Rule Query

```eql
iam where event.dataset == "aws.cloudtrail"
  and event.provider == "iam.amazonaws.com"
  and event.outcome == "success"
  and event.action in ("CreateVirtualMFADevice", "EnableMFADevice")
  and startsWith (aws.cloudtrail.user_identity.access_key_id, "ASIA")
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Persistence
- Id: TA0003
- Reference URL: [[https://attack.mitre.org/tactics/TA0003/](https://attack.mitre.org/tactics/TA0003/)](https://attack.mitre.org/tactics/TA0003/)
- Technique:
  - Name: Account Manipulation
- Id: T1098
- Reference URL: [[https://attack.mitre.org/techniques/T1098/](https://attack.mitre.org/techniques/T1098/)](https://attack.mitre.org/techniques/T1098/)
- Sub Technique:
  - Name: Device Registration
- Id: T1098.005
- Reference URL: [[https://attack.mitre.org/techniques/T1098/005/](https://attack.mitre.org/techniques/T1098/005/)](https://attack.mitre.org/techniques/T1098/005/)
- Technique:
  - Name: Modify Authentication Process
- Id: T1556
- Reference URL: [[https://attack.mitre.org/techniques/T1556/](https://attack.mitre.org/techniques/T1556/)](https://attack.mitre.org/techniques/T1556/)
- Sub Technique:
  - Name: Multi-Factor Authentication
- Id: T1556.006
- Reference URL: [[https://attack.mitre.org/techniques/T1556/006/](https://attack.mitre.org/techniques/T1556/006/)](https://attack.mitre.org/techniques/T1556/006/)