﻿---
title: AWS SNS Topic Message Publish by Rare User
description: Identifies when an SNS topic message is published by a rare user in AWS. Adversaries may publish messages to SNS topics for phishing campaigns, data exfiltration,...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/aws/lateral_movement_sns_topic_message_publish_by_rare_user
products:
  - Elastic Security
---

# AWS SNS Topic Message Publish by Rare User
Identifies when an SNS topic message is published by a rare user in AWS. Adversaries may publish messages to SNS topics
for phishing campaigns, data exfiltration, or lateral movement within the AWS environment. SNS topics are used to send
notifications and messages to subscribed endpoints such as applications, mobile devices or email addresses, making them a
valuable target for adversaries to distribute malicious content or exfiltrate sensitive data. This is a New Terms rule that only flags
when this behavior is observed for the first time by a user or role.
**Rule type**: new_terms
**Rule indices**:
- filebeat-*
- logs-aws.cloudtrail-*

**Rule Severity**: medium
**Risk Score**: 47
**Runs every**: 
**Searches indices from**: `now-6m`
**Maximum alerts per execution**: 100
**References**:
- [[https://docs.aws.amazon.com/sns/latest/api/API_Publish.html](https://docs.aws.amazon.com/sns/latest/api/API_Publish.html)](https://docs.aws.amazon.com/sns/latest/api/API_Publish.html)
- [[https://hackingthe.cloud/aws/exploitation/Misconfigured_Resource-Based_Policies/exploting_public_resources_attack_playbook/](https://hackingthe.cloud/aws/exploitation/Misconfigured_Resource-Based_Policies/exploting_public_resources_attack_playbook/)](https://hackingthe.cloud/aws/exploitation/Misconfigured_Resource-Based_Policies/exploting_public_resources_attack_playbook/)
- [[https://permiso.io/blog/s/smishing-attack-on-aws-sms-new-phone-who-dis/](https://permiso.io/blog/s/smishing-attack-on-aws-sms-new-phone-who-dis/)](https://permiso.io/blog/s/smishing-attack-on-aws-sms-new-phone-who-dis/)
- [[https://www.sentinelone.com/labs/sns-sender-active-campaigns-unleash-messaging-spam-through-the-cloud/](https://www.sentinelone.com/labs/sns-sender-active-campaigns-unleash-messaging-spam-through-the-cloud/)](https://www.sentinelone.com/labs/sns-sender-active-campaigns-unleash-messaging-spam-through-the-cloud/)

**Tags**:
- Domain: Cloud
- Data Source: AWS
- Data Source: Amazon Web Services
- Data Source: AWS SNS
- Use Case: Threat Detection
- Resources: Investigation Guide
- Tactic: Lateral Movement
- Tactic: Exfiltration
- Tactic: Impact

**Version**: 4
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2
AWS SNS topic data event types need to be enabled in the CloudTrail trail configuration to capture the Publish action. Ensure that the AWS CloudTrail service is [configured](https://docs.aws.amazon.com/sns/latest/dg/logging-using-cloudtrail.html#cloudtrail-data-events) to log data events for SNS.

## Investigation guide


## Triage and Analysis


### Investigating AWS SNS Topic Message Publish by Rare User

This rule identifies when a message is published to an SNS topic by a user who has rarely or never published messages before. This activity could indicate adversarial actions, such as using SNS topics for phishing campaigns, data exfiltration, or lateral movement within an AWS environment.
This is a [New Terms](https://www.elastic.co/guide/en/security/current/rules-ui-create.html#create-new-terms-rule) rule that only flags when this behavior is observed for the first time by a user or role.

#### Possible Investigation Steps

- **Identify the Actor and Resource**:
  - **User Identity and Role**: Examine the `aws.cloudtrail.user_identity.arn` to identify the user or role responsible for publishing the SNS message. Verify whether this actor is authorized to publish messages to SNS topics.
- **Access Key Details**: Review the `aws.cloudtrail.user_identity.access_key_id` to determine the access key used.
- **SNS Topic ARN**: Analyze `aws.cloudtrail.resources.arn` to confirm whether the SNS topic is critical, sensitive, or used for authorized purposes.
- **Evaluate the Context of the SNS Message**:
  - **Published Message Details**: AWS redacts the message content in CloudTrail logs, but you can view the message ID, subject, and other metadata. Investigate the message details for any indicators of malicious content.
- **Message Recipients**: Investigate the subscriptions associated with the SNS topic to identify if messages were sent to unauthorized or unexpected recipients.
- **Analyze Source Information**:
  - **Source IP Address**: Examine the `source.ip` field to identify the origin of the activity. Unusual IP addresses or geolocations may indicate unauthorized access.
- **User Agent**: Review `user_agent.original` to determine the tool or client used for publishing the SNS message. Automated tools or unexpected clients (e.g., `Boto3` from an unknown host) may signify misuse.
- **Review Historical Activity**:
  - **Actor’s Past Behavior**: Identify whether the user has published messages to SNS topics before. Review similar past events for context.
- **Frequency and Patterns**: Examine the time and frequency of messages published by the same user or to the same SNS topic to detect anomalies.
- **Correlate with Other Events**:
  - **IAM or CloudTrail Events**: Look for events such as `AssumeRole`, `CreateAccessKey`, or other API actions associated with the same user ARN.
- **Unusual IAM Role Activity**: Determine if the actor has assumed roles or performed administrative tasks atypical for their role.


### False Positive Analysis

- **Routine Operational Use**:
  - Confirm if the publishing activity aligns with standard operational tasks or automation scripts.
- Validate whether new or rare users were recently granted permissions for publishing messages to SNS topics.
- **Testing or Monitoring Scripts**:
  - Automated testing or monitoring tools may trigger this rule if configured to publish messages to SNS topics.


### Response and Remediation

- **Immediate Action**:
  - If unauthorized activity is confirmed, disable the access key or IAM role associated with the user.
- Restrict or remove permissions from the SNS topic to prevent further misuse.
- **Review Policies and Subscriptions**:
  - Audit the IAM policies tied to the user and SNS topic to ensure appropriate permissions.
- Validate the subscriptions of the SNS topic to confirm all endpoints are authorized.
- **Enhance Monitoring and Alerting**:
  - Set up additional logging or alerting for SNS publish actions, especially from rare or unknown users.
- Monitor for similar actions across other SNS topics within the environment.
- **Conduct a Root Cause Analysis**:
  - Investigate how the user or role gained access to publish messages to the SNS topic.
- Determine if other AWS resources or services have been affected.


### Additional Information

For more information on SNS topic management and securing AWS resources, refer to:
- [AWS SNS Publish API Documentation](https://docs.aws.amazon.com/sns/latest/api/API_Publish.html)
- [AWS CloudTrail Documentation](https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-event-reference.html)


## Rule Query

```kuery
event.dataset:"aws.cloudtrail"
    and event.provider:"sns.amazonaws.com"
    and event.action:"Publish"
    and event.outcome:"success"
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Lateral Movement
- Id: TA0008
- Reference URL: [[https://attack.mitre.org/tactics/TA0008/](https://attack.mitre.org/tactics/TA0008/)](https://attack.mitre.org/tactics/TA0008/)
- Technique:
  - Name: Internal Spearphishing
- Id: T1534
- Reference URL: [[https://attack.mitre.org/techniques/T1534/](https://attack.mitre.org/techniques/T1534/)](https://attack.mitre.org/techniques/T1534/)

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Exfiltration
- Id: TA0010
- Reference URL: [[https://attack.mitre.org/tactics/TA0010/](https://attack.mitre.org/tactics/TA0010/)](https://attack.mitre.org/tactics/TA0010/)
- Technique:
  - Name: Exfiltration Over Web Service
- Id: T1567
- Reference URL: [[https://attack.mitre.org/techniques/T1567/](https://attack.mitre.org/techniques/T1567/)](https://attack.mitre.org/techniques/T1567/)

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Impact
- Id: TA0040
- Reference URL: [[https://attack.mitre.org/tactics/TA0040/](https://attack.mitre.org/tactics/TA0040/)](https://attack.mitre.org/tactics/TA0040/)
- Technique:
  - Name: Resource Hijacking
- Id: T1496
- Reference URL: [[https://attack.mitre.org/techniques/T1496/](https://attack.mitre.org/techniques/T1496/)](https://attack.mitre.org/techniques/T1496/)
- Sub Technique:
  - Name: Cloud Service Hijacking
- Id: T1496.004
- Reference URL: [[https://attack.mitre.org/techniques/T1496/004/](https://attack.mitre.org/techniques/T1496/004/)](https://attack.mitre.org/techniques/T1496/004/)