﻿---
title: AWS EC2 Instance Connect SSH Public Key Uploaded
description: Identifies when a new SSH public key is uploaded to an AWS EC2 instance using the EC2 Instance Connect service. This action could indicate an adversary...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/aws/lateral_movement_ec2_instance_connect_ssh_public_key_uploaded
products:
  - Elastic Security
---

# AWS EC2 Instance Connect SSH Public Key Uploaded
Identifies when a new SSH public key is uploaded to an AWS EC2 instance using the EC2 Instance Connect service. This
action could indicate an adversary attempting to maintain access to the instance. The rule detects the
SendSerialConsoleSSHPublicKey or SendSSHPublicKey API actions, which are logged when manually uploading an SSH key
to an EC2 instance or serial connection. It is important to know that this API call happens automatically by the EC2
Instance Connect service when a user connects to an EC2 instance using the EC2 Instance Connect service via the CLI or
AWS Management Console.
**Rule type**: query
**Rule indices**:
- filebeat-*
- logs-aws.cloudtrail-*

**Rule Severity**: medium
**Risk Score**: 47
**Runs every**: 
**Searches indices from**: `now-6m`
**Maximum alerts per execution**: 100
**References**:
- [[https://unit42.paloaltonetworks.com/cloud-lateral-movement-techniques](https://unit42.paloaltonetworks.com/cloud-lateral-movement-techniques)](https://unit42.paloaltonetworks.com/cloud-lateral-movement-techniques)
- [[https://medium.parttimepolymath.net/aws-ec2-instance-connect-a-very-neat-trick-4d2fc0c28010](https://medium.parttimepolymath.net/aws-ec2-instance-connect-a-very-neat-trick-4d2fc0c28010)](https://medium.parttimepolymath.net/aws-ec2-instance-connect-a-very-neat-trick-4d2fc0c28010)
- [[https://stratus-red-team.cloud/attack-techniques/AWS/aws.lateral-movement.ec2-instance-connect/](https://stratus-red-team.cloud/attack-techniques/AWS/aws.lateral-movement.ec2-instance-connect/)](https://stratus-red-team.cloud/attack-techniques/AWS/aws.lateral-movement.ec2-instance-connect/)
- [[https://cloud.hacktricks.xyz/pentesting-cloud/aws-security/aws-privilege-escalation/aws-ec2-privesc](https://cloud.hacktricks.xyz/pentesting-cloud/aws-security/aws-privilege-escalation/aws-ec2-privesc)](https://cloud.hacktricks.xyz/pentesting-cloud/aws-security/aws-privilege-escalation/aws-ec2-privesc)
- [[https://docs.aws.amazon.com/ec2-instance-connect/latest/APIReference/API_SendSSHPublicKey.html](https://docs.aws.amazon.com/ec2-instance-connect/latest/APIReference/API_SendSSHPublicKey.html)](https://docs.aws.amazon.com/ec2-instance-connect/latest/APIReference/API_SendSSHPublicKey.html)
- [[https://docs.aws.amazon.com/ec2-instance-connect/latest/APIReference/API_SendSerialConsoleSSHPublicKey.html](https://docs.aws.amazon.com/ec2-instance-connect/latest/APIReference/API_SendSerialConsoleSSHPublicKey.html)](https://docs.aws.amazon.com/ec2-instance-connect/latest/APIReference/API_SendSerialConsoleSSHPublicKey.html)

**Tags**:
- Domain: Cloud
- Data Source: AWS
- Data Source: Amazon Web Services
- Data Source: AWS EC2
- Use Case: Identity and Access Audit
- Tactic: Privilege Escalation
- Tactic: Lateral Movement
- Resources: Investigation Guide

**Version**: 7
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Investigation guide


## Triage and Analysis


### Investigating AWS EC2 Instance Connect SSH Public Key Uploaded

This rule detects when a new SSH public key is uploaded to an AWS EC2 instance using the EC2 Instance Connect service. Adversaries may upload SSH public keys to EC2 instances to maintain access to the instance or for initial access. This action also occurs automatically in the background when establishing a connection to an instance via the same service.  The rule covers cases where the `SendSerialConsoleSSHPublicKey` API action is used to upload an SSH public key to a serial connection, which can be exploited for privilege escalation.

#### Possible Investigation Steps:

- **Identify the Actor**: Review the `aws.cloudtrail.user_identity.arn` and `aws.cloudtrail.user_identity.access_key_id` fields to identify who performed the action. Verify if this actor typically performs such actions and if they have the necessary permissions.
- **Review the Request Details**: Examine the `aws.cloudtrail.request_parameters` to understand the specific details of the SSH public key upload. Look for any unusual parameters that could suggest unauthorized or malicious modifications. Determine the targeted EC2 instance.
- **Analyze the Source of the Request**: Investigate the `source.ip` and `source.geo` fields to determine the geographical origin of the request. An external or unexpected location might indicate compromised credentials or unauthorized access.
- **Contextualize with Timestamp**: Use the `@timestamp` field to check when the SSH public key was uploaded. Changes during non-business hours or outside regular maintenance windows might require further scrutiny.
- **Correlate with Other Activities**: Search for related CloudTrail events before and after this action to see if the same actor or IP address engaged in other potentially suspicious activities.
- **Check for Serial Console Access**: If the `SendSerialConsoleSSHPublicKey` action was used, verify if the `ec2:EnableSerialConsoleAccess` permission was also used, which might indicate an attempt to enable and exploit the serial console.


### False Positive Analysis:

- **Legitimate Administrative Actions**: Confirm if the SSH public key upload aligns with scheduled updates, development activities, or legitimate administrative tasks documented in change management systems.
- **Consistency Check**: Compare the action against historical data of similar actions performed by the user or within the organization. If the action is consistent with past legitimate activities, it might indicate a false alarm.


### Response and Remediation:

- **Immediate Review and Reversal if Necessary**: If the upload was unauthorized, remove the uploaded SSH public key from the EC2 instance and review the instance's access logs for any suspicious activity.
- **Enhance Monitoring and Alerts**: Adjust monitoring systems to alert on similar actions, especially those involving sensitive instances or unusual file extensions.
- **Educate and Train**: Provide additional training to users with administrative rights on the importance of security best practices concerning SSH key management and the risks of unauthorized key uploads.
- **Audit EC2 Instance Policies and Permissions**: Conduct a comprehensive audit of all EC2 instance policies and associated permissions to ensure they adhere to the principle of least privilege.
- **Incident Response**: If there's an indication of malicious intent or a security breach, initiate the incident response protocol to mitigate any damage and prevent future occurrences.


### Additional Information:

For further guidance on managing EC2 instances and securing AWS environments, refer to the [AWS EC2 Instance Connect documentation](https://docs.aws.amazon.com/ec2-instance-connect/latest/APIReference/API_SendSSHPublicKey.html) and AWS best practices for security. Additionally, consult the following resources for specific details on SSH key management and privilege escalation techniques:
- [Stratus Red Team - AWS EC2 Instance Connect](https://stratus-red-team.cloud/attack-techniques/AWS/aws.lateral-movement.ec2-instance-connect/)
- [HackTricks - AWS EC2 Privilege Escalation](https://cloud.hacktricks.xyz/pentesting-cloud/aws-security/aws-privilege-escalation/aws-ec2-privesc)
- [AWS EC2 Instance Connect API Reference](https://docs.aws.amazon.com/ec2-instance-connect/latest/APIReference/API_SendSSHPublicKey.html)


## Rule Query

```kuery
event.dataset: aws.cloudtrail
    and event.provider: ec2-instance-connect.amazonaws.com
    and event.action: (SendSSHPublicKey or SendSerialConsoleSSHPublicKey)
    and event.outcome: success
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Lateral Movement
- Id: TA0008
- Reference URL: [[https://attack.mitre.org/tactics/TA0008/](https://attack.mitre.org/tactics/TA0008/)](https://attack.mitre.org/tactics/TA0008/)
- Technique:
  - Name: Remote Services
- Id: T1021
- Reference URL: [[https://attack.mitre.org/techniques/T1021/](https://attack.mitre.org/techniques/T1021/)](https://attack.mitre.org/techniques/T1021/)
- Sub Technique:
  - Name: SSH
- Id: T1021.004
- Reference URL: [[https://attack.mitre.org/techniques/T1021/004/](https://attack.mitre.org/techniques/T1021/004/)](https://attack.mitre.org/techniques/T1021/004/)

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Privilege Escalation
- Id: TA0004
- Reference URL: [[https://attack.mitre.org/tactics/TA0004/](https://attack.mitre.org/tactics/TA0004/)](https://attack.mitre.org/tactics/TA0004/)
- Technique:
  - Name: Account Manipulation
- Id: T1098
- Reference URL: [[https://attack.mitre.org/techniques/T1098/](https://attack.mitre.org/techniques/T1098/)](https://attack.mitre.org/techniques/T1098/)
- Sub Technique:
  - Name: SSH Authorized Keys
- Id: T1098.004
- Reference URL: [[https://attack.mitre.org/techniques/T1098/004/](https://attack.mitre.org/techniques/T1098/004/)](https://attack.mitre.org/techniques/T1098/004/)