﻿---
title: AWS IAM Deactivation of MFA Device
description: Detects the deactivation of a Multi-Factor Authentication (MFA) device in AWS Identity and Access Management (IAM). MFA provides critical protection against...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/aws/impact_iam_deactivate_mfa_device
products:
  - Elastic Security
---

# AWS IAM Deactivation of MFA Device
Detects the deactivation of a Multi-Factor Authentication (MFA) device in AWS Identity and Access Management (IAM). MFA
provides critical protection against unauthorized access by requiring a second factor for authentication. Adversaries or
compromised administrators may deactivate MFA devices to weaken account protections, disable strong authentication, or
prepare for privilege escalation or persistence. This rule monitors successful DeactivateMFADevice API calls, which
represent the point at which MFA protection is actually removed.
**Rule type**: query
**Rule indices**:
- filebeat-*
- logs-aws.cloudtrail-*

**Rule Severity**: medium
**Risk Score**: 47
**Runs every**: 
**Searches indices from**: `now-6m`
**Maximum alerts per execution**: 100
**References**:
- [[https://awscli.amazonaws.com/v2/documentation/api/latest/reference/iam/deactivate-mfa-device.html](https://awscli.amazonaws.com/v2/documentation/api/latest/reference/iam/deactivate-mfa-device.html)](https://awscli.amazonaws.com/v2/documentation/api/latest/reference/iam/deactivate-mfa-device.html)
- [[https://docs.aws.amazon.com/IAM/latest/APIReference/API_DeactivateMFADevice.html](https://docs.aws.amazon.com/IAM/latest/APIReference/API_DeactivateMFADevice.html)](https://docs.aws.amazon.com/IAM/latest/APIReference/API_DeactivateMFADevice.html)

**Tags**:
- Domain: Cloud
- Data Source: AWS
- Data Source: Amazon Web Services
- Data Source: AWS CloudTrail
- Data Source: AWS IAM
- Resources: Investigation Guide
- Tactic: Impact
- Tactic: Persistence

**Version**: 214
**Rule authors**:
- Elastic
- Austin Songer

**Rule license**: Elastic License v2

## Investigation guide


## Triage and analysis


### Investigating AWS IAM Deactivation of MFA Device

This rule detects successful deactivation of a Virtual MFA device in AWS IAM.
Deactivation removes MFA enforcement from an IAM user, significantly lowering account resilience against credential theft or unauthorized access.
Since MFA devices must be deactivated before deletion, this represents the earliest and most critical opportunity to detect potential account compromise or persistence activity.
For more information about using MFA in AWS, access the [official documentation](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_mfa.html).

#### Possible investigation steps

- **Identify the actor and context**
  - Review `aws.cloudtrail.user_identity.arn` and `aws.cloudtrail.user_identity.access_key_id` to determine who initiated the deactivation.
- Check whether the actor typically manages MFA or has the IAM permissions to perform such actions.
- Review `user_agent.original` to confirm if the operation was performed via the AWS Console, CLI, or SDK.
- **Review the source and location**
  - Investigate `source.ip` and `source.geo` fields for unusual origins or unrecognized locations.
- Determine if this request originated from known automation infrastructure, internal IP ranges, or a personal endpoint.
- **Correlate with other related activity**
  - Look for preceding API calls such as `ListMFADevices`, `GetSessionToken`, or `ListUsers`, which may indicate reconnaissance or IAM enumeration.
- Search for subsequent `DeleteVirtualMFADevice` calls to confirm whether the deactivated device was later deleted — a common follow-up action.
- Check for any privilege changes, credential creations (`CreateAccessKey`, `AttachUserPolicy`), or unexpected login attempts following the deactivation.
- **Validate authorization**
  - Confirm with IAM or security administrators whether the action was part of an authorized device rotation or remediation.
- If not documented or approved, escalate as a potential credential compromise or persistence attempt.


### False positive analysis

- **Legitimate device rotation**
  - When replacing an MFA device, AWS requires deactivation of the existing device before the new one can be enabled.
- **Administrative maintenance**
  - IAM administrators or automation pipelines may deactivate MFA as part of account management or recovery workflows.


### Response and remediation

- **Containment**
  - Re-enable MFA for the affected IAM user (`EnableMFADevice`) or temporarily disable their login access until legitimacy is confirmed.
- Revoke temporary credentials or tokens associated with the actor to prevent further misuse.
- **Investigation and scoping**
  - Review CloudTrail history for additional IAM configuration changes or access key creation events tied to the same principal.
- Determine whether sensitive resources were accessed after MFA removal.
- Identify whether multiple users had MFA devices deactivated in a short timeframe — an indicator of broader compromise.
- **Recovery and hardening**
  - Require MFA for all privileged IAM users and enforce it using service control policies (SCPs).
- Enable GuardDuty or Security Hub findings for IAM anomaly detection related to account takeover or configuration changes.


### Additional information

- **[AWS IR Playbooks](https://github.com/aws-samples/aws-incident-response-playbooks/blob/c151b0dc091755fffd4d662a8f29e2f6794da52c/playbooks/)**
- **[AWS Customer Playbook Framework](https://github.com/aws-samples/aws-customer-playbook-framework/tree/a8c7b313636b406a375952ac00b2d68e89a991f2/docs)**
- **[DeactivateMFADevice API Reference](https://docs.aws.amazon.com/IAM/latest/APIReference/API_DeactivateMFADevice.html)**
- **[Managing MFA Devices in IAM](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_mfa.html)**


## Rule Query

```kuery
event.dataset: aws.cloudtrail 
    and event.provider: iam.amazonaws.com 
    and event.action: DeactivateMFADevice 
    and event.outcome: success
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Impact
- Id: TA0040
- Reference URL: [[https://attack.mitre.org/tactics/TA0040/](https://attack.mitre.org/tactics/TA0040/)](https://attack.mitre.org/tactics/TA0040/)
- Technique:
  - Name: Account Access Removal
- Id: T1531
- Reference URL: [[https://attack.mitre.org/techniques/T1531/](https://attack.mitre.org/techniques/T1531/)](https://attack.mitre.org/techniques/T1531/)

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Persistence
- Id: TA0003
- Reference URL: [[https://attack.mitre.org/tactics/TA0003/](https://attack.mitre.org/tactics/TA0003/)](https://attack.mitre.org/tactics/TA0003/)
- Technique:
  - Name: Modify Authentication Process
- Id: T1556
- Reference URL: [[https://attack.mitre.org/techniques/T1556/](https://attack.mitre.org/techniques/T1556/)](https://attack.mitre.org/techniques/T1556/)
- Sub Technique:
  - Name: Multi-Factor Authentication
- Id: T1556.006
- Reference URL: [[https://attack.mitre.org/techniques/T1556/006/](https://attack.mitre.org/techniques/T1556/006/)](https://attack.mitre.org/techniques/T1556/006/)