﻿---
title: AWS CloudTrail Log Updated
description: Detects updates to an existing CloudTrail trail via UpdateTrail API which may reduce visibility, change destinations, or weaken integrity (e.g., removing...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/aws/impact_cloudtrail_logging_updated
products:
  - Elastic Security
---

# AWS CloudTrail Log Updated
Detects updates to an existing CloudTrail trail via UpdateTrail API which may reduce visibility, change destinations, or
weaken integrity (e.g., removing global events, moving the S3 destination, or disabling validation). Adversaries can
modify trails to evade detection while maintaining a semblance of logging. Validate any configuration change against
approved baselines.
**Rule type**: query
**Rule indices**:
- filebeat-*
- logs-aws.cloudtrail-*

**Rule Severity**: low
**Risk Score**: 21
**Runs every**: 
**Searches indices from**: `now-6m`
**Maximum alerts per execution**: 100
**References**:
- [[https://docs.aws.amazon.com/awscloudtrail/latest/APIReference/API_UpdateTrail.html](https://docs.aws.amazon.com/awscloudtrail/latest/APIReference/API_UpdateTrail.html)](https://docs.aws.amazon.com/awscloudtrail/latest/APIReference/API_UpdateTrail.html)
- [[https://awscli.amazonaws.com/v2/documentation/api/latest/reference/cloudtrail/update-trail.html](https://awscli.amazonaws.com/v2/documentation/api/latest/reference/cloudtrail/update-trail.html)](https://awscli.amazonaws.com/v2/documentation/api/latest/reference/cloudtrail/update-trail.html)

**Tags**:
- Domain: Cloud
- Data Source: AWS
- Data Source: Amazon Web Services
- Data Source: AWS Cloudtrail
- Use Case: Log Auditing
- Resources: Investigation Guide
- Tactic: Impact

**Version**: 213
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Investigation guide


## Triage and analysis


### Investigating AWS CloudTrail Log Updated

AWS CloudTrail is a service that enables governance, compliance, and operational and risk auditing of your AWS account. It logs API calls and related events, providing visibility into user activity. Trail modifications can be used by attackers to redirect logs to non-approved buckets, drop regions, or disable valuable selectors. This rule identifies a modification on CloudTrail settings using the `UpdateTrail` API.

#### Possible investigation steps

- **Actor and context**
  - Check `aws.cloudtrail.user_identity.arn`, `user_agent.original`, `source.ip`; verify approved change.
- **Assess the modification**
  - In `aws.cloudtrail.request_parameters`, note changes to:
  - `S3BucketName`, `CloudWatchLogsLogGroupArn`, `KmsKeyId`
- `IsMultiRegionTrail`, `IncludeGlobalServiceEvents`
- Event or insight selectors (management vs data events)
- **Correlate**
  - Look for preceding `StopLogging` or following `DeleteTrail`.
- Review concurrent IAM policy edits or role changes by the same actor.


### False positive analysis

- **Planned changes**: Baseline drift during region onboarding or encryption rotation.
- **Automation**: IaC pipelines updating trails as templates evolve.


### Response and remediation

- **If unauthorized**
  - Revert to baseline; validate destination ownership and KMS policy.
- Investigate time ranges where visibility may have been reduced.
- **Hardening**
  - Constrain `cloudtrail:UpdateTrail`, require approvals, and monitor with AWS Config rules.


### Additional information

- **[AWS IR Playbooks](https://github.com/aws-samples/aws-incident-response-playbooks/blob/c151b0dc091755fffd4d662a8f29e2f6794da52c/playbooks/)**
- **[AWS Customer Playbook Framework](https://github.com/aws-samples/aws-customer-playbook-framework/tree/a8c7b313636b406a375952ac00b2d68e89a991f2/docs)**
- **Security Best Practices:** [AWS Knowledge Center – Security Best Practices](https://aws.amazon.com/premiumsupport/knowledge-center/security-best-practices/).


## Rule Query

```kuery
event.dataset: "aws.cloudtrail" 
    and event.provider: "cloudtrail.amazonaws.com" 
    and event.action: "UpdateTrail" 
    and event.outcome: "success"
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Impact
- Id: TA0040
- Reference URL: [[https://attack.mitre.org/tactics/TA0040/](https://attack.mitre.org/tactics/TA0040/)](https://attack.mitre.org/tactics/TA0040/)
- Technique:
  - Name: Data Manipulation
- Id: T1565
- Reference URL: [[https://attack.mitre.org/techniques/T1565/](https://attack.mitre.org/techniques/T1565/)](https://attack.mitre.org/techniques/T1565/)
- Sub Technique:
  - Name: Stored Data Manipulation
- Id: T1565.001
- Reference URL: [[https://attack.mitre.org/techniques/T1565/001/](https://attack.mitre.org/techniques/T1565/001/)](https://attack.mitre.org/techniques/T1565/001/)

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Collection
- Id: TA0009
- Reference URL: [[https://attack.mitre.org/tactics/TA0009/](https://attack.mitre.org/tactics/TA0009/)](https://attack.mitre.org/tactics/TA0009/)
- Technique:
  - Name: Data from Cloud Storage
- Id: T1530
- Reference URL: [[https://attack.mitre.org/techniques/T1530/](https://attack.mitre.org/techniques/T1530/)](https://attack.mitre.org/techniques/T1530/)