﻿---
title: AWS S3 Bucket Enumeration or Brute Force
description: Identifies a high number of failed S3 operations against a single bucket from a single source address within a short timeframe. This activity can indicate...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/aws/impact_aws_s3_bucket_enumeration_or_brute_force
products:
  - Elastic Security
---

# AWS S3 Bucket Enumeration or Brute Force
Identifies a high number of failed S3 operations against a single bucket from a single source address within a short timeframe.
This activity can indicate attempts to collect bucket objects or cause an increase in billing to an account via internal "AccessDenied" errors.
**Rule type**: threshold
**Rule indices**:
- logs-aws.cloudtrail-*

**Rule Severity**: low
**Risk Score**: 21
**Runs every**: 
**Searches indices from**: `now-6m`
**Maximum alerts per execution**: 100
**References**:
- [[https://medium.com/@maciej.pocwierz/how-an-empty-s3-bucket-can-make-your-aws-bill-explode-934a383cb8b1](https://medium.com/@maciej.pocwierz/how-an-empty-s3-bucket-can-make-your-aws-bill-explode-934a383cb8b1)](https://medium.com/@maciej.pocwierz/how-an-empty-s3-bucket-can-make-your-aws-bill-explode-934a383cb8b1)
- [[https://docs.aws.amazon.com/AmazonS3/latest/userguide/ErrorCodeBilling.html](https://docs.aws.amazon.com/AmazonS3/latest/userguide/ErrorCodeBilling.html)](https://docs.aws.amazon.com/AmazonS3/latest/userguide/ErrorCodeBilling.html)

**Tags**:
- Domain: Cloud
- Data Source: AWS
- Data Source: Amazon Web Services
- Data Source: AWS S3
- Resources: Investigation Guide
- Use Case: Log Auditing
- Tactic: Impact
- Tactic: Discovery
- Tactic: Collection

**Version**: 7
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Investigation guide


## Triage and analysis


### Investigating AWS S3 Bucket Enumeration or Brute Force

This rule detects when many failed S3 operations (HTTP 403 AccessDenied) hit a single bucket from a single source address in a short window. This can indicate bucket name enumeration, object/key guessing, or brute-force style traffic intended to drive cost or probe for misconfigurations. 403 requests from outside the bucket owner’s account/organization are not billed, but 4XX from inside the owner’s account/org can still incur charges. Prioritize confirming who is making the calls and where they originate.

#### Possible investigation steps

- **Investigate in Timeline.** Investigate the alert in timeline (Take action -> Investigate in timeline) to retrieve and review all of the raw CloudTrail events that contributed to the threshold alert. Threshold alerts only display the grouped fields; Timeline provides a way to see individual event details such as request parameters, full error messages, and additional user context.
- **Confirm entity & target.** Note the rule’s threshold and window. Identify the target bucket (`tls.client.server_name`) and the source (`source.address`). Verify the caller identity details via any available `aws.cloudtrail.user_identity` fields.
- **Actor & session context.** In CloudTrail events, pivot 15–30 minutes around the spike for the same `source.address` or principal. Determine if the source is:
  - **External** to your account/organization (recon/cost DDoS risk is lower for you due to 2024 billing change).
- **Internal** (same account/org)—higher cost risk and possible misuse of internal automation.
- **Bucket posture snapshot.** Record S3 Block Public Access, Bucket Policy, ACLs, and whether Versioning/Object Lock are enabled. Capture any recent `PutBucketPolicy`, `PutPublicAccessBlock`, `PutBucketVersioning`, or lifecycle changes.
- **Blast radius.** Check for similar spikes to other buckets/regions, or parallel spikes from the same source. Review any GuardDuty S3 findings and AWS Config drift related to the bucket or principal.
- **Business context.** Contact the bucket/app owner. Validate whether a migration, scanner, or broken job could legitimately cause bursts.


### False positive analysis

- **Expected jobs / broken automation.** Data movers, posture scanners, or failed credentials can generate 403 storms. Validate with `userAgent`, ARNs, change windows, and environment (dev/stage vs prod).
- **External probing.** Internet-origin enumeration often looks like uniform 403s from transient or cloud-provider IPs and typically has no business impact and no billing if outside your account/org. Tune thresholds or allowlist known scanners if appropriate.


### Response and remediation

**Immediate, low-risk actions**
- **Preserve evidence.** Export CloudTrail records (±30 minutes) for the bucket and source address into an evidence bucket with restricted access.
- **Notify owners.** Inform the bucket/application owner and security lead; confirm any maintenance windows.

**Containment options**
- **External-origin spikes:** Verify Block Public Access is enforced and bucket policies are locked down. Optionally apply a temporary deny-all bucket policy allowing only IR/admin roles while scoping.
- **Internal-origin spikes:** Identify the principal. Rotate access keys for IAM users, or restrict involved roles (temporary deny/SCP, remove risky policies). Pause broken jobs/pipelines until validated.

**Scope & hunting**
- Review Timeline and CloudTrail for related events: `PutBucketPolicy`, `PutPublicAccessBlock`, `PutBucketVersioning`, lifecycle changes, unusual `PutObject`/`DeleteObject` volumes, or cross-account access.
- Check GuardDuty S3 and Config drift findings for signs of tampering or lateral movement.

**Recovery & hardening**
- If data impact suspected: with Versioning, restore known-good versions; otherwise, recover from backups/replicas.
- Enable Versioning on critical buckets going forward; evaluate Object Lock legal hold if enabled.
- Ensure Block Public Access, least-privilege IAM policies, CloudTrail data events for S3, and GuardDuty protections are consistently enforced.


### Additional information

- [AWS S3 billing for error responses](https://docs.aws.amazon.com/AmazonS3/latest/userguide/ErrorCodeBilling.html): see latest AWS docs on which error codes are billed.
- [AWS announcement (Aug 2024)](https://aws.amazon.com/about-aws/whats-new/2024/05/amazon-s3-no-charge-http-error-codes/): 403s from outside the account/org are not billed.
- [AWS IR Playbooks](https://github.com/aws-samples/aws-incident-response-playbooks/): NIST-aligned template for evidence, containment, eradication, recovery, post-incident.
- [AWS Customer Playbook Framework](https://github.com/aws-samples/aws-customer-playbook-framework/): Practical response steps for account and bucket-level abuse.


## Rule Query

```kuery
  event.dataset: "aws.cloudtrail" and 
  event.provider : "s3.amazonaws.com" and 
  aws.cloudtrail.error_code : "AccessDenied" and 
  tls.client.server_name : * 
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Impact
- Id: TA0040
- Reference URL: [[https://attack.mitre.org/tactics/TA0040/](https://attack.mitre.org/tactics/TA0040/)](https://attack.mitre.org/tactics/TA0040/)
- Technique:
  - Name: Financial Theft
- Id: T1657
- Reference URL: [[https://attack.mitre.org/techniques/T1657/](https://attack.mitre.org/techniques/T1657/)](https://attack.mitre.org/techniques/T1657/)

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Discovery
- Id: TA0007
- Reference URL: [[https://attack.mitre.org/tactics/TA0007/](https://attack.mitre.org/tactics/TA0007/)](https://attack.mitre.org/tactics/TA0007/)
- Technique:
  - Name: Cloud Storage Object Discovery
- Id: T1619
- Reference URL: [[https://attack.mitre.org/techniques/T1619/](https://attack.mitre.org/techniques/T1619/)](https://attack.mitre.org/techniques/T1619/)

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Collection
- Id: TA0009
- Reference URL: [[https://attack.mitre.org/tactics/TA0009/](https://attack.mitre.org/tactics/TA0009/)](https://attack.mitre.org/tactics/TA0009/)
- Technique:
  - Name: Data from Cloud Storage
- Id: T1530
- Reference URL: [[https://attack.mitre.org/techniques/T1530/](https://attack.mitre.org/techniques/T1530/)](https://attack.mitre.org/techniques/T1530/)