﻿---
title: AWS Lambda Layer Added to Existing Function
description: Identifies when a Lambda layer is added to an existing AWS Lambda function. Lambda layers allow shared code, dependencies, or runtime modifications to...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/aws/execution_lambda_external_layer_added_to_function
products:
  - Elastic Security
---

# AWS Lambda Layer Added to Existing Function
Identifies when a Lambda layer is added to an existing AWS Lambda function. Lambda layers allow shared code,
dependencies, or runtime modifications to be injected into a function’s execution environment. Adversaries with the
ability to update function configurations may add a malicious layer to establish persistence, run unauthorized code, or
intercept data handled by the function. This activity should be reviewed to ensure the modification is expected and
authorized.
**Rule type**: query
**Rule indices**:
- filebeat-*
- logs-aws.cloudtrail-*

**Rule Severity**: low
**Risk Score**: 21
**Runs every**: 
**Searches indices from**: `now-6m`
**Maximum alerts per execution**: 100
**References**:
- [[https://cloud.hacktricks.xyz/pentesting-cloud/aws-security/aws-persistence/aws-lambda-persistence/aws-lambda-layers-persistence](https://cloud.hacktricks.xyz/pentesting-cloud/aws-security/aws-persistence/aws-lambda-persistence/aws-lambda-layers-persistence)](https://cloud.hacktricks.xyz/pentesting-cloud/aws-security/aws-persistence/aws-lambda-persistence/aws-lambda-layers-persistence)
- [[https://docs.aws.amazon.com/lambda/latest/api/API_PublishLayerVersion.html](https://docs.aws.amazon.com/lambda/latest/api/API_PublishLayerVersion.html)](https://docs.aws.amazon.com/lambda/latest/api/API_PublishLayerVersion.html)
- [[https://docs.aws.amazon.com/lambda/latest/api/API_UpdateFunctionConfiguration.html](https://docs.aws.amazon.com/lambda/latest/api/API_UpdateFunctionConfiguration.html)](https://docs.aws.amazon.com/lambda/latest/api/API_UpdateFunctionConfiguration.html)

**Tags**:
- Domain: Cloud
- Data Source: AWS
- Data Source: Amazon Web Services
- Data Source: AWS Lambda
- Use Case: Threat Detection
- Tactic: Execution
- Resources: Investigation Guide

**Version**: 7
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Investigation guide


## Triage and analysis


### Investigating AWS Lambda Layer Added to Existing Function

Lambda layers introduce external code artifacts into a function’s runtime. Adding a layer to an existing Lambda function
modifies its execution environment and may allow an adversary to run arbitrary code, intercept data, or maintain
persistence without altering the function source itself. This detection highlights successful configuration updates using
`PublishLayerVersion*` or `UpdateFunctionConfiguration*`.

### Possible investigation steps

**Identify the actor**
- Review `aws.cloudtrail.user_identity.arn` and the `access_key_id`. Determine whether the actor normally administers Lambda or has recently exhibited unusual behavior.

**Review what was modified**
- Inspect `aws.cloudtrail.request_parameters` to identify which layer ARN was added, the function name and region, whether multiple layers were applied at once or in rapid succession.
- Compare the added layer version against known and approved layer catalogs.

**Validate the operational context**
- Check the time of the update (`@timestamp`) to see if it aligns with known release pipelines or deployment windows and Normal working hours for the responsible team.
- Determine whether a CI/CD pipeline or IaC tool was expected to update this function.

**Assess where the change came from**
- Review `source.ip` and `user_agent.original` for signs of console access from unusual locations, access via previously unused automation tools, suspicious programmatic access consistent with compromised keys.

**Correlate with additional activity**
- Look for preceding or subsequent events such as:
  - Creation of new Lambda layers (`PublishLayerVersion`).
- IAM role modifications affecting the Lambda function.
- Increased invocation volume or unusual invocation patterns after the layer addition.
- Search for other functions modified by the same actor or from the same IP.


### False positive analysis

- Confirm whether the change aligns with a planned deployment, application update, or dependency upgrade.
- Determine whether the user or automation role commonly modifies Lambda function configurations.
- Validate the legitimacy of the added layer by checking internal documentation or release notes.


### Response and remediation

- Remove or roll back the added layer if the modification appears unauthorized or suspicious.
- Review the layer contents, especially for newly published layers, to verify integrity and legitimacy.
- Investigate the IAM role or user responsible for the change and rotate compromised credentials if necessary.
- Tighten permissions by ensuring only approved roles can modify Lambda configurations or publish new layers.
- Implement monitoring for subsequent Lambda configuration changes, invocation anomalies caused by the injected layer, additional persistence techniques targeting serverless infrastructure.


### Additional information

- **[AWS IR Playbooks](https://github.com/aws-samples/aws-incident-response-playbooks/blob/c151b0dc091755fffd4d662a8f29e2f6794da52c/playbooks/)**
- **[AWS Customer Playbook Framework](https://github.com/aws-samples/aws-customer-playbook-framework/tree/a8c7b313636b406a375952ac00b2d68e89a991f2/docs)**
- **[AWS Knowledge Center – Security Best Practices](https://aws.amazon.com/premiumsupport/knowledge-center/security-best-practices/)**


## Rule Query

```kuery
event.dataset: aws.cloudtrail
    and event.provider: lambda.amazonaws.com
    and event.outcome: success
    and event.action: (PublishLayerVersion* or UpdateFunctionConfiguration*)
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Execution
- Id: TA0002
- Reference URL: [[https://attack.mitre.org/tactics/TA0002/](https://attack.mitre.org/tactics/TA0002/)](https://attack.mitre.org/tactics/TA0002/)
- Technique:
  - Name: Serverless Execution
- Id: T1648
- Reference URL: [[https://attack.mitre.org/techniques/T1648/](https://attack.mitre.org/techniques/T1648/)](https://attack.mitre.org/techniques/T1648/)