﻿---
title: AWS WAF Access Control List Deletion
description: Identifies the deletion of an AWS Web Application Firewall (WAF) Web ACL. Web ACLs are the core enforcement objects in AWS WAF, defining which traffic...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/aws/defense_evasion_waf_acl_deletion
products:
  - Elastic Security
---

# AWS WAF Access Control List Deletion
Identifies the deletion of an AWS Web Application Firewall (WAF) Web ACL. Web ACLs are the core enforcement objects in
AWS WAF, defining which traffic is inspected, allowed, or blocked for protected applications. Deleting a Web ACL removes
all associated rules, protections, and logging configurations. Adversaries who obtain sufficient privileges may delete a
Web ACL to disable critical security controls, evade detection, or prepare for downstream attacks such as
web-application compromise, data theft, or resource abuse. Because Web ACLs are rarely deleted outside of controlled
maintenance or infrastructure updates, unexpected deletions may indicate potential defense evasion.
**Rule type**: query
**Rule indices**:
- filebeat-*
- logs-aws.cloudtrail-*

**Rule Severity**: medium
**Risk Score**: 47
**Runs every**: 
**Searches indices from**: `now-6m`
**Maximum alerts per execution**: 100
**References**:
- [[https://docs.aws.amazon.com/waf/latest/APIReference/API_DeleteWebACL.html](https://docs.aws.amazon.com/waf/latest/APIReference/API_DeleteWebACL.html)](https://docs.aws.amazon.com/waf/latest/APIReference/API_DeleteWebACL.html)
- [[https://docs.aws.amazon.com/waf/latest/APIReference/API_wafRegional_DeleteWebACL.html](https://docs.aws.amazon.com/waf/latest/APIReference/API_wafRegional_DeleteWebACL.html)](https://docs.aws.amazon.com/waf/latest/APIReference/API_wafRegional_DeleteWebACL.html)

**Tags**:
- Domain: Cloud
- Data Source: AWS
- Data Source: Amazon Web Services
- Data Source: AWS WAF
- Use Case: Network Security Monitoring
- Tactic: Defense Evasion
- Resources: Investigation Guide

**Version**: 211
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Investigation guide


## Triage and analysis


### Investigating AWS WAF Access Control List Deletion

AWS Web Application Firewall (WAF) protects applications by inspecting HTTP/S traffic and applying rule groups,
managed rule sets, and custom logic to block or allow requests. A Web ACL is the primary enforcement object that binds
these protections to CloudFront distributions, Application Load Balancers, API Gateway stages, and AppSync APIs.
Deleting a Web ACL immediately removes all protections and logging associated with that application entry point.
Because this action can expose applications to direct exploitation, adversaries may delete Web ACLs to disable
defenses, evade detection, or prepare for lateral movement or data exfiltration.
This rule detects successful `DeleteWebACL` events across WAF Classic, WAF Regional, and WAFv2 APIs.

### Possible investigation steps

- **Identify the actor and access context**
  - Review `aws.cloudtrail.user_identity.arn` and `access_key_id` for the identity that initiated deletion.
- Determine whether this principal normally manages WAF resources.
- Check if the call originated via IAM role assumption, federated identity, or long-lived IAM key.
- **Assess the deleted ACL**
  - Check `aws.cloudtrail.request_parameters` for:
  - The Web ACL ID (`WebACLId`, `Id`, or ARN).
- The scope (REGIONAL vs. CLOUDFRONT).
- Associated resource ARNs that were protected.
- Determine which applications or APIs depended on this Web ACL.
- Evaluate the criticality and sensitivity of any exposed endpoints.
- **Correlate with related security-affecting activity**
  - Use CloudTrail to pivot on:
  - The same identity (`user_identity.arn` or access key).
- The same application load balancer, CloudFront distribution, or API Gateway stage.
- Look for:
  - Prior rule updates (`UpdateWebACL`, `DeleteRuleGroup`, etc.).
- IAM privilege escalation events.
- Changes to logging or monitoring (e.g., disabling WAF logging).
- **Investigate request origin and tooling**
  - Review `source.ip`, ASN, and geo-location for anomalies.
- Analyze `user_agent.original` to identify automation, custom scripts, CLI usage, or console access.
- **Evaluate operational context**
  - Determine whether the deletion aligns with:
  - Scheduled maintenance.
- IaC-driven redeployments (Terraform, CDK, CloudFormation).
- Known migrations between WAF Classic and WAFv2.
- If deletion occurred outside expected time windows or without a corresponding change ticket, treat it as suspicious.


### False positive analysis

- **Expected infrastructure lifecycle events**
  - IaC pipelines may destroy and recreate Web ACLs as part of environment rotation or blue/green deployments.
- Confirm whether the deleting identity matches known automation roles.
- **Planned refactoring or migrations**
  - Organizations transitioning to WAFv2 or moving resources across regions may intentionally delete legacy ACLs.
- **Testing and sandbox environments**
  - Developers may frequently create and remove ACLs during experimentation.
- Tune the rule to suppress events from non-production accounts or specific tags.
- **Automated cleanup**
  - Certain CI/CD processes or teardown scripts remove WAF resources during ephemeral environment shutdowns.

If any deletion is inconsistent with normal operational patterns or performed by an unexpected principal, treat it as a potential defense-evasion attempt.

### Response and remediation

- **Containment**
  - Immediately assess exposed applications. If feasible, apply temporary restrictive network controls (e.g., ALB security group tightening or CloudFront WAFv2 fallback rules).
- Revoke session tokens or access keys associated with suspicious actors.
- **Restore protections**
  - Recreate the deleted Web ACL using IaC definitions, backups, or previous configurations.
- Validate that logging and monitoring (WAF logs, CloudWatch alarms, SIEM ingestion) are correctly restored.
- **Scope and impact analysis**
  - Review CloudTrail for follow-on or preceding activity by the same actor:
  - Rule modifications.
- IAM policy changes.
- Application configuration updates.
- API Gateway or ALB changes.
- Review application access logs for unusual requests following ACL removal.
- **Hardening**
  - Limit IAM permissions for `waf:DeleteWebACL`, `wafv2:DeleteWebACL`, and related actions to a small set of trusted roles.
- Enforce MFA for administrative access.
- Use AWS Config or Security Hub controls to detect unauthorized modifications to WAF resources.
- **Post-incident improvements**
  - Update change-management workflows to include required approvals for WAF modifications.
- Improve monitoring for other defense-evasion patterns such as disabling GuardDuty, CloudTrail, or logging.


### Additional information

- **DeleteWebACL API (WAF Classic & Regional):**

  [https://docs.aws.amazon.com/waf/latest/APIReference/API_wafRegional_DeleteWebACL.html](https://docs.aws.amazon.com/waf/latest/APIReference/API_wafRegional_DeleteWebACL.html)
- **DeleteWebACL API (WAFv2):**

  [https://docs.aws.amazon.com/waf/latest/APIReference/API_DeleteWebACL.html](https://docs.aws.amazon.com/waf/latest/APIReference/API_DeleteWebACL.html)
- **[AWS IR Playbooks](https://github.com/aws-samples/aws-incident-response-playbooks/blob/c151b0dc091755fffd4d662a8f29e2f6794da52c/playbooks/)**
- **[AWS Customer Playbook Framework](https://github.com/aws-samples/aws-customer-playbook-framework/tree/a8c7b313636b406a375952ac00b2d68e89a991f2/docs)**
- **[AWS Knowledge Center – Security Best Practices](https://aws.amazon.com/premiumsupport/knowledge-center/security-best-practices/)**


## Rule Query

```kuery
event.dataset: aws.cloudtrail 
    and event.provider: (waf.amazonaws.com or waf-regional.amazonaws.com or wafv2.amazonaws.com)
    and event.action: DeleteWebACL 
    and event.outcome: success
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Defense Evasion
- Id: TA0005
- Reference URL: [[https://attack.mitre.org/tactics/TA0005/](https://attack.mitre.org/tactics/TA0005/)](https://attack.mitre.org/tactics/TA0005/)
- Technique:
  - Name: Impair Defenses
- Id: T1562
- Reference URL: [[https://attack.mitre.org/techniques/T1562/](https://attack.mitre.org/techniques/T1562/)](https://attack.mitre.org/techniques/T1562/)
- Sub Technique:
  - Name: Disable or Modify Cloud Firewall
- Id: T1562.007
- Reference URL: [[https://attack.mitre.org/techniques/T1562/007/](https://attack.mitre.org/techniques/T1562/007/)](https://attack.mitre.org/techniques/T1562/007/)