﻿---
title: AWS First Occurrence of STS GetFederationToken Request by User
description: Identifies the first occurrence of an AWS Security Token Service (STS) GetFederationToken request made by a user. The GetFederationToken API call allows...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/aws/defense_evasion_sts_get_federation_token
products:
  - Elastic Security
---

# AWS First Occurrence of STS GetFederationToken Request by User
Identifies the first occurrence of an AWS Security Token Service (STS) GetFederationToken request made by a user. The GetFederationToken API call allows users to request temporary security credentials to
access AWS resources. The maximum expiration period for these tokens is 36 hours and they can be used to create a console signin token even for identities that don't already have one. Adversaries may use this API to obtain temporary credentials for persistence and to bypass IAM API call limitations by gaining console access.
**Rule type**: new_terms
**Rule indices**:
- filebeat-*
- logs-aws.cloudtrail-*

**Rule Severity**: medium
**Risk Score**: 47
**Runs every**: 
**Searches indices from**: `now-6m`
**Maximum alerts per execution**: 100
**References**:
- [[https://hackingthe.cloud/aws/post_exploitation/survive_access_key_deletion_with_sts_getfederationtoken/](https://hackingthe.cloud/aws/post_exploitation/survive_access_key_deletion_with_sts_getfederationtoken/)](https://hackingthe.cloud/aws/post_exploitation/survive_access_key_deletion_with_sts_getfederationtoken/)
- [[https://www.crowdstrike.com/en-us/blog/how-adversaries-persist-with-aws-user-federation/](https://www.crowdstrike.com/en-us/blog/how-adversaries-persist-with-aws-user-federation/)](https://www.crowdstrike.com/en-us/blog/how-adversaries-persist-with-aws-user-federation/)
- [[https://medium.com/@adan.alvarez/how-attackers-persist-in-aws-using-getfederationtoken-a-simple-and-effective-technique-used-in-the-987ec1f0bdfe/](https://medium.com/@adan.alvarez/how-attackers-persist-in-aws-using-getfederationtoken-a-simple-and-effective-technique-used-in-the-987ec1f0bdfe/)](https://medium.com/@adan.alvarez/how-attackers-persist-in-aws-using-getfederationtoken-a-simple-and-effective-technique-used-in-the-987ec1f0bdfe/)

**Tags**:
- Domain: Cloud
- Data Source: Amazon Web Services
- Data Source: AWS
- Data Source: AWS STS
- Use Case: Threat Detection
- Tactic: Defense Evasion
- Tactic: Persistence
- Resources: Investigation Guide

**Version**: 6
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Investigation guide


## Triage and analysis


### Investigating AWS First Occurrence of STS GetFederationToken Request by User

AWS Security Token Service (STS) enables users to request temporary credentials for accessing AWS resources. While beneficial for legitimate use, adversaries may exploit this to gain unauthorized access. These credentials will remain active for the duration specified (maximum 36 hours), even if the initial compromised identity is deleted. They can also be used to request a console signin token which allows the adversary to make sensitive IAM API calls which would otherwise be denied with the federation token alone. The detection rule identifies unusual activity by flagging the first instance of a `GetFederationToken` request by a user helping to uncover potential misuse aimed at evading defenses and gaining persistence.

### Possible investigation steps

- Review the specific user account associated with the `GetFederationToken` request to determine if the activity aligns with their typical behavior and role within the organization.
- Examine the AWS CloudTrail logs for additional context around the time of the `GetFederationToken` request, looking for any other unusual or suspicious activities by the same user or related accounts.
- Check the `source.ip` and `source.geo` fields of the request to identify if it originates from an expected or unexpected location.
- View the `aws.cloudtrail.response_elements` to find the created `federatedUser.arn`. Investigate the resources accessed by this Federated User to assess if there was any suspicious activity.
- Consult with the requesting user `aws.cloudtrail.user_identity.arn` to verify if the `GetFederationToken` request was legitimate and necessary for their work tasks.


### False positive analysis

- Routine administrative tasks by cloud administrators may trigger the rule if they are using `GetFederationToken` for legitimate purposes. To manage this, create exceptions for known administrative accounts that regularly perform these actions.
- Automated scripts or applications that use `GetFederationToken` for legitimate operations might be flagged. Identify these scripts and exclude their associated user accounts from the rule to prevent unnecessary alerts.
- Third-party services integrated with AWS that require temporary credentials might cause false positives. Review and whitelist these services if they are verified and trusted to avoid repeated alerts.
- New employees or contractors accessing AWS resources for the first time may trigger the rule. Implement a process to verify their access requirements and exclude their accounts if their actions are deemed non-threatening.


### Response and remediation

- If compromise is verified, attach a policy that denies all actions, effectively preventing any further activity, even from temporary credentials. You can use the AWS-managed policy [AWSDenyAll](https://docs.aws.amazon.com/aws-managed-policy/latest/reference/AWSDenyAll.html). This ensures that any temporary credentials generated by the compromised user are also blocked, stopping the attacker’s activities.
- Notify the security team and relevant stakeholders about the incident for awareness and further investigation.
- Conduct a root cause analysis to determine how the `GetFederationToken` request was initiated and identify any potential security gaps or misconfigurations.
- Implement additional monitoring and alerting for `GetFederationToken` requests to detect and respond to similar activities promptly in the future.
- Review and update IAM policies and permissions to ensure that only authorized users have the ability to request temporary credentials, reducing the risk of misuse.


## Rule Query

```kuery
event.dataset: "aws.cloudtrail"
    and event.provider:sts.amazonaws.com
    and event.action:GetFederationToken
    and event.outcome:success
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Defense Evasion
- Id: TA0005
- Reference URL: [[https://attack.mitre.org/tactics/TA0005/](https://attack.mitre.org/tactics/TA0005/)](https://attack.mitre.org/tactics/TA0005/)
- Technique:
  - Name: Use Alternate Authentication Material
- Id: T1550
- Reference URL: [[https://attack.mitre.org/techniques/T1550/](https://attack.mitre.org/techniques/T1550/)](https://attack.mitre.org/techniques/T1550/)
- Sub Technique:
  - Name: Application Access Token
- Id: T1550.001
- Reference URL: [[https://attack.mitre.org/techniques/T1550/001/](https://attack.mitre.org/techniques/T1550/001/)](https://attack.mitre.org/techniques/T1550/001/)

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Persistence
- Id: TA0003
- Reference URL: [[https://attack.mitre.org/tactics/TA0003/](https://attack.mitre.org/tactics/TA0003/)](https://attack.mitre.org/tactics/TA0003/)
- Technique:
  - Name: Account Manipulation
- Id: T1098
- Reference URL: [[https://attack.mitre.org/techniques/T1098/](https://attack.mitre.org/techniques/T1098/)](https://attack.mitre.org/techniques/T1098/)
- Sub Technique:
  - Name: Additional Cloud Credentials
- Id: T1098.001
- Reference URL: [[https://attack.mitre.org/techniques/T1098/001/](https://attack.mitre.org/techniques/T1098/001/)](https://attack.mitre.org/techniques/T1098/001/)