﻿---
title: AWS Route 53 Resolver Query Log Configuration Deleted
description: Identifies the deletion of an Amazon Route 53 Resolver Query Log Configuration. Resolver query logs provide critical visibility into DNS activity across...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/aws/defense_evasion_route53_dns_query_resolver_config_deletion
products:
  - Elastic Security
---

# AWS Route 53 Resolver Query Log Configuration Deleted
Identifies the deletion of an Amazon Route 53 Resolver Query Log Configuration. Resolver query logs provide critical
visibility into DNS activity across VPCs, including lookups made by EC2 instances, containers, Lambda functions, and
other AWS resources. Deleting a query log configuration immediately stops DNS query and response logging for the
associated VPC. Adversaries may delete these configurations to evade detection, suppress forensic evidence, or degrade
security monitoring capabilities.
**Rule type**: query
**Rule indices**:
- filebeat-*
- logs-aws.cloudtrail*

**Rule Severity**: medium
**Risk Score**: 47
**Runs every**: 
**Searches indices from**: `now-6m`
**Maximum alerts per execution**: 100
**References**:
- [[https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_DeleteResolverQueryLogConfig.html](https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_DeleteResolverQueryLogConfig.html)](https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_DeleteResolverQueryLogConfig.html)

**Tags**:
- Domain: Cloud
- Data Source: AWS
- Data Source: Amazon Web Services
- Data Source: AWS Route 53
- Use Case: Log Auditing
- Resources: Investigation Guide
- Tactic: Defense Evasion

**Version**: 7
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Investigation guide


## Triage and analysis


### Investigating AWS Route 53 Resolver Query Log Configuration Deleted

Route 53 Resolver query logs provide essential telemetry for DNS visibility across AWS environments. Deleting a Resolver Query Log Configuration immediately halts DNS logging for one or more VPCs, creating a significant monitoring gap. Adversaries may intentionally delete these configurations to hide malicious activity. This rule detects successful invocations of `DeleteResolverQueryLogConfig`.

### Possible investigation steps

**Validate the actor and request origin**
- Review `aws.cloudtrail.user_identity.arn` and `aws.cloudtrail.user_identity.access_key_id` to determine who initiated the deletion. Confirm whether the identity normally manages Route53 Resolver resources or VPC-level DNS configuration.
- Examine `source.ip`, `source.address`, `source.geo` fields and `user_agent.original` to determine whether the request originated from an expected network path or automation role. Whether API calls were made via console, CLI, SDK, or custom tooling.

**Understand what was deleted and the impacted environment**
- Inspect `aws.cloudtrail.request_parameters` and `aws.cloudtrail.response_elements` to identify the Query Log Configuration ID, Associated VPCs and destinations (e.g., CloudWatch Log Group, S3 bucket, Kinesis stream).
- Determine whether these VPCs support production workloads, contain regulated or sensitive data, host internet-facing or privileged workloads (e.g., EKS clusters, directory services, bastion hosts).

**Correlate for intent and related activity**
- Use `@timestamp` to correlate the deletion with:
  - Prior `PutResolverQueryLogConfig` or `AssociateResolverQueryLogConfig` modifications.
- IAM permission changes or STS session activities.
- Recent DNS anomalies if logs were active prior to deletion.
- Pivot on the same `aws.cloudtrail.user_identity.arn` to identify:
  - Additional logging-related tampering (CloudTrail, VPC Flow Logs, S3 server access logs).
- Resource isolation or privilege escalation attempts.
- Suspicious EC2, Lambda, or container workload behavior.

**Validate operational context**
- Check whether a change request, maintenance window, or migration task was underway that could explain the deletion.
- Confirm with networking, SRE, or platform engineering teams whether a logging pipeline redesign was in progress, a deprecated log config was intentionally removed, infrastructure-as-code (IaC) automation recently applied updates that removed the configuration.


### False positive analysis

- **Legitimate network and logging redesign**
  - Deletions performed during planned VPC migrations, resolver logging pipeline upgrades, or CloudWatch/S3 restructuring may be benign.
- **Expected IaC behavior**
  - Terraform, CloudFormation, or CDK stacks may destroy and recreate logging configurations during updates.

  Validate pipeline activity and automation roles to avoid noise.


### Response and remediation

**Contain and restore visibility**
- If unauthorized activity is suspected:
  - Immediately re-create the Resolver Query Log Configuration.
- Re-associate the configuration with the affected VPCs to restore DNS visibility.
- Verify that CloudWatch Log Groups or S3 destinations have not been deleted or altered.

**Investigate access and scope of impact**
- Review IAM permissions assigned to the actor:
  - Identify whether privilege escalation or role compromise occurred.
- Validate that other high-impact logging or monitoring configurations (CloudTrail, VPC Flow Logs, GuardDuty) remain intact.
- Perform a DNS-focused threat hunt:
  - Analyze prior logged queries for indicators of malware, C2 infrastructure, or suspicious domains before the logging gap.

**Strengthen defensive controls**
- Restrict sensitive operations by:
  - Limiting `route53resolver:DeleteResolverQueryLogConfig` to a small number of privileged roles.
- Adding IAM condition keys to constrain deletion operations by source IP, region, or principal ARN.
- Enable AWS Config or Security Hub controls that:
  - Detect missing or deleted query log configurations.
- Enforce continuous logging for critical VPCs.


### Additional information

- **[AWS IR Playbooks](https://github.com/aws-samples/aws-incident-response-playbooks/blob/c151b0dc091755fffd4d662a8f29e2f6794da52c/playbooks/)**
- **[AWS Customer Playbook Framework](https://github.com/aws-samples/aws-customer-playbook-framework/tree/a8c7b313636b406a375952ac00b2d68e89a991f2/docs)**
- **[AWS Knowledge Center – Security Best Practices](https://aws.amazon.com/premiumsupport/knowledge-center/security-best-practices/)**


## Rule Query

```kuery
event.dataset: aws.cloudtrail 
    and event.provider: route53resolver.amazonaws.com
    and event.action: DeleteResolverQueryLogConfig 
    and event.outcome: success
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Defense Evasion
- Id: TA0005
- Reference URL: [[https://attack.mitre.org/tactics/TA0005/](https://attack.mitre.org/tactics/TA0005/)](https://attack.mitre.org/tactics/TA0005/)
- Technique:
  - Name: Impair Defenses
- Id: T1562
- Reference URL: [[https://attack.mitre.org/techniques/T1562/](https://attack.mitre.org/techniques/T1562/)](https://attack.mitre.org/techniques/T1562/)
- Sub Technique:
  - Name: Disable or Modify Cloud Logs
- Id: T1562.008
- Reference URL: [[https://attack.mitre.org/techniques/T1562/008/](https://attack.mitre.org/techniques/T1562/008/)](https://attack.mitre.org/techniques/T1562/008/)