﻿---
title: AWS Config Resource Deletion
description: Identifies attempts to delete AWS Config resources. AWS Config provides continuous visibility into resource configuration changes and compliance posture...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/aws/defense_evasion_config_service_rule_deletion
products:
  - Elastic Security
---

# AWS Config Resource Deletion
Identifies attempts to delete AWS Config resources. AWS Config provides continuous visibility into resource
configuration changes and compliance posture across an account. Deleting Config components can significantly reduce
security visibility and auditability. Adversaries may delete or disable Config resources to evade detection, hide prior
activity, or weaken governance controls before or after other malicious actions.
**Rule type**: query
**Rule indices**:
- filebeat-*
- logs-aws.cloudtrail-*

**Rule Severity**: medium
**Risk Score**: 47
**Runs every**: 
**Searches indices from**: `now-6m`
**Maximum alerts per execution**: 100
**References**:
- [[https://docs.aws.amazon.com/config/latest/developerguide/how-does-config-work.html](https://docs.aws.amazon.com/config/latest/developerguide/how-does-config-work.html)](https://docs.aws.amazon.com/config/latest/developerguide/how-does-config-work.html)
- [[https://docs.aws.amazon.com/config/latest/APIReference/API_Operations.html](https://docs.aws.amazon.com/config/latest/APIReference/API_Operations.html)](https://docs.aws.amazon.com/config/latest/APIReference/API_Operations.html)

**Tags**:
- Domain: Cloud
- Data Source: AWS
- Data Source: Amazon Web Services
- Data Source: AWS Config
- Resources: Investigation Guide
- Tactic: Defense Evasion

**Version**: 213
**Rule authors**:
- Elastic
- Austin Songer

**Rule license**: Elastic License v2

## Investigation guide


## Triage and analysis


### Investigating AWS Config Resource Deletion

AWS Config records configuration changes, relationships, and compliance status for AWS resources over time.
Deleting Config components such as recorders, delivery channels, rules, or conformance packs disrupts
security monitoring, compliance enforcement, and forensic visibility. This behavior is uncommon outside of
planned infrastructure changes and should be treated as high-risk when unexpected. This rule detects successful deletion of AWS Config resources.

### Possible investigation steps

**Identify the actor**
- Review `aws.cloudtrail.user_identity.arn` and `aws.cloudtrail.user_identity.access_key_id` to determine who initiated the deletion.
- Confirm whether this principal typically manages AWS Config or centralized security tooling.
- Check `user_agent.original` to determine whether the action was performed via console, CLI, SDK, or automation.

**Determine what was deleted**
- Inspect `event.action` and `aws.cloudtrail.request_parameters` to identify which Config component was removed
  (e.g., configuration recorder, delivery channel, rule, aggregator, or conformance pack).
- Assess whether the deleted resource was account-scoped or organization-wide. Used for compliance reporting, guardrails, or security monitoring.
- Identify the affected regions and accounts using `cloud.region` and `cloud.account.id`.

**Reconstruct timing and intent**
- Use `@timestamp` to correlate the deletion with:
  - IAM changes (role updates, policy modifications, STS activity).
- Other monitoring disruptions (CloudTrail, GuardDuty, Security Hub).
- Destructive or high-impact actions occurring shortly before or after.
- Compare the timing against approved maintenance windows or infrastructure changes.

**Correlate with broader activity**
- Pivot in CloudTrail on the same principal or access key to identify:
  - Additional attempts to disable logging or security controls.
- Resource deletions or configuration weakening across services.
- Evaluate whether the deletion appears isolated or part of a broader evasion sequence.

**Validate intent with stakeholders**
- Confirm with security, cloud platform, or compliance teams whether the deletion was planned and approved.
- Verify whether replacement Config resources were created shortly after, or whether monitoring remains disabled.


### False positive analysis

- **Planned environment changes**
  - Non-production account teardown, environment consolidation, or compliance tool migrations may involve
  deletion of Config resources.
- **Authorized security automation**
  - Approved automation or security tooling may delete and recreate Config components during setup or remediation.
- Tune exceptions carefully using specific principals or automation roles rather than broad exclusions.


### Response and remediation

- **Contain and restore visibility**
  - If unauthorized, immediately re-enable AWS Config components, including recorders and delivery channels.
- Validate that historical configuration data and compliance reporting resume as expected.
- **Investigate scope and impact**
  - Determine how long Config visibility was impaired and what activity may have occurred during that window.
- Review other monitoring gaps (e.g., CloudTrail or GuardDuty changes) for coordinated evasion.
- **Credential and access review**
  - Rotate or disable credentials associated with the deleting principal if compromise is suspected.
- Review IAM permissions to ensure only a minimal, well-defined set of roles can manage AWS Config.
- **Hardening and prevention**
  - Use SCPs or IAM conditions to restrict deletion of Config resources in production and security accounts.
- Implement AWS Config rules or Security Hub controls to alert when Config is disabled or degraded.
- Document and formalize change procedures for governance tooling.


### Additional information

- **[AWS IR Playbooks](https://github.com/aws-samples/aws-incident-response-playbooks/blob/c151b0dc091755fffd4d662a8f29e2f6794da52c/playbooks/)**
- **[AWS Customer Playbook Framework](https://github.com/aws-samples/aws-customer-playbook-framework/tree/a8c7b313636b406a375952ac00b2d68e89a991f2/docs)**
- **[AWS Knowledge Center – Security Best Practices](https://aws.amazon.com/premiumsupport/knowledge-center/security-best-practices/)**


## Rule Query

```kuery
event.dataset: aws.cloudtrail 
    and event.provider: config.amazonaws.com 
    and event.outcome: success
    and event.action: (DeleteConfigRule or DeleteOrganizationConfigRule or DeleteConfigurationAggregator or
    DeleteConfigurationRecorder or DeleteConformancePack or DeleteOrganizationConformancePack or
    DeleteDeliveryChannel or DeleteRemediationConfiguration or DeleteRetentionConfiguration)
    and not aws.cloudtrail.user_identity.invoked_by: (securityhub.amazonaws.com or fms.amazonaws.com or controltower.amazonaws.com or config-conforms.amazonaws.com)
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Defense Evasion
- Id: TA0005
- Reference URL: [[https://attack.mitre.org/tactics/TA0005/](https://attack.mitre.org/tactics/TA0005/)](https://attack.mitre.org/tactics/TA0005/)
- Technique:
  - Name: Impair Defenses
- Id: T1562
- Reference URL: [[https://attack.mitre.org/techniques/T1562/](https://attack.mitre.org/techniques/T1562/)](https://attack.mitre.org/techniques/T1562/)
- Sub Technique:
  - Name: Disable or Modify Tools
- Id: T1562.001
- Reference URL: [[https://attack.mitre.org/techniques/T1562/001/](https://attack.mitre.org/techniques/T1562/001/)](https://attack.mitre.org/techniques/T1562/001/)
- Sub Technique:
  - Name: Disable or Modify Cloud Logs
- Id: T1562.008
- Reference URL: [[https://attack.mitre.org/techniques/T1562/008/](https://attack.mitre.org/techniques/T1562/008/)](https://attack.mitre.org/techniques/T1562/008/)