﻿---
title: AWS Management Console Brute Force of Root User Identity
description: Identifies a high number of failed authentication attempts to the AWS management console for the Root user identity. An adversary may attempt to brute...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/aws/credential_access_root_console_failure_brute_force
products:
  - Elastic Security
---

# AWS Management Console Brute Force of Root User Identity
Identifies a high number of failed authentication attempts to the AWS management console for the Root user identity. An
adversary may attempt to brute force the password for the Root user identity, as it has complete access to all services
and resources for the AWS account.
**Rule type**: threshold
**Rule indices**:
- filebeat-*
- logs-aws.cloudtrail-*

**Rule Severity**: high
**Risk Score**: 73
**Runs every**: 
**Searches indices from**: `now-6m`
**Maximum alerts per execution**: 100
**References**:
- [[https://docs.aws.amazon.com/IAM/latest/UserGuide/id_root-user.html](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_root-user.html)](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_root-user.html)

**Tags**:
- Domain: Cloud
- Data Source: AWS
- Data Source: Amazon Web Services
- Data Source: AWS Sign-In
- Use Case: Identity and Access Audit
- Tactic: Credential Access
- Resources: Investigation Guide

**Version**: 212
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Investigation guide


## Triage and analysis


### Investigating AWS Management Console Brute Force of Root User Identity

The AWS Management Console provides a web interface for managing AWS resources. Because the root user has unrestricted privileges, repeated failed console login attempts targeting this identity represent a high-risk credential access event. Even if no login succeeded, this activity may indicate reconnaissance, password spraying, or credential stuffing attempts targeting the root user.
This rule uses a threshold rule that detects a high number of failed `ConsoleLogin` events (`event.outcom: failure` with `userIdentity.type: Root`) within a short timeframe from the same IP address or user agent.

Threshold rules only summarize grouped field values, so analysts must use timeline to review the actual events that triggered the alert.

#### Possible investigation steps

- **Review in Timeline.**

  Open the alert and *Investigate in timeline* to view the individual CloudTrail events contributing to the threshold alert. Review:
  - `source.ip`, `user_agent.original`, `geo fields` and `@timestamp` for each failure.
- Look for patterns such as distributed sources or repeated retries at consistent intervals.
- Look for any corresponding successful `ConsoleLogin` events around the same timeframe from the same IP or agent.
- **Assess IP reputation and geolocation.**

  Use IP intelligence tools to evaluate whether the source addresses belong to known cloud providers, TOR nodes, or foreign regions outside your normal operations.
  - Correlate against `cloud.region` and `geo fields` and compare with expected login locations for your organization.
- **Check for related activity.**

  Review CloudTrail for other API calls from the same source IP (for example, `GetSessionToken`, `AssumeRole`, or `ListUsers`) that may indicate scripted credential testing or discovery.
- **Correlate with GuardDuty findings.**

  GuardDuty may raise complementary findings for anomalous console login behavior or brute force attempts. Review recent GuardDuty and AWS Config alerts for the same timeframe.
- **Determine business context.**

  Confirm whether the source IPs are internal (for example, corporate VPN, IT admin network) or part of legitimate red-team or third-party testing. If uncertain, treat as suspicious.


### False positive analysis

- **Forgotten or mistyped credentials.**

  Repeated failed logins from known internal IPs could indicate a legitimate user typing errors. Validate by checking if a successful root login followed soon after.
- **Automation or scanners.**

  Misconfigured monitoring tools or old browser sessions attempting to reuse cached credentials may trigger this rule.
- **Planned penetration testing.**

  Red-team or security testing activities can generate deliberate brute force attempts. Verify via ticketing or testing schedules.


### Response and remediation> The AWS Incident Response Playbooks classify root login attempts as Priority-1 credential compromise events.

Follow these steps whether or not your organization has a formal IR team.
**Immediate containment**
- **Check for success.**

  After pivoting to Timeline, confirm whether any `ConsoleLogin` events from the same IP or user agent show `event.oucome: success`.
  - If a successful login occurred, immediately follow the *AWS Management Console Root Login* rule investigation guide.
- **Rotate the root password.**

  Use AWS’s password reset function to set a strong, unique password stored in an offline vault.
- **Enable or verify Multi-Factor Authentication (MFA)** on the root account. If MFA was already configured, review the device registration for changes or suspicious resets.
- **Block offending IPs or networks.**

  Use AWS WAF, VPC network ACLs, or Security Groups to temporarily block the IPs used in the failed attempts.
- **Alert internal teams.**

  Notify your security operations or cloud governance teams of the brute force pattern and actions taken.

**Evidence preservation**
- Export all failed `ConsoleLogin` events visible in Timeline (±30 minutes around the alert window) to a restricted evidence bucket.
- Preserve GuardDuty findings, AWS Config history, and CloudTrail logs for the same timeframe for further analysis.

**Scoping and investigation**
- Query CloudTrail across other AWS accounts and regions for additional failed or successful `ConsoleLogin` events from the same IPs.
- Check IAM activity for simultaneous key creation, role modifications, or new users — signs of lateral or parallel intrusion attempts.
- Review network telemetry (VPC Flow Logs, CloudFront, WAF) to determine whether the activity originated from a distributed or scripted attack pattern.

**Recovery and hardening**
- Confirm MFA is enabled and enforced on the root account.
- Remove any root access keys (none should exist under normal security posture).
- Enable organization-wide CloudTrail, GuardDuty, and Security Hub across all regions.
- Set up real-time alerts for any future `ConsoleLogin` failures from the root user exceeding expected baselines.
- Store root credentials offline with dual-custody and document controlled access procedures.


### Additional information

- **[AWS IR Playbooks](https://github.com/aws-samples/aws-incident-response-playbooks/tree/c151b0dc091755fffd4d662a8f29e2f6794da52c/playbooks):** See “Credential Compromise” and “Account Compromise” for investigation, containment, and escalation guidance.
- **[AWS Customer Playbook Framework](https://github.com/aws-samples/aws-customer-playbook-framework/tree/a8c7b313636b406a375952ac00b2d68e89a991f2/docs):** Reference runbooks for failed-login response, evidence preservation, and MFA enforcement.
- **AWS Documentation:** [Tasks that require the root user](https://docs.aws.amazon.com/general/latest/gr/root-vs-iam.html#aws_tasks-that-require-root).
- **Security Best Practices:** [AWS Knowledge Center – Security Best Practices](https://aws.amazon.com/premiumsupport/knowledge-center/security-best-practices/).


## Rule Query

```kuery
event.dataset:aws.cloudtrail and 
event.provider:signin.amazonaws.com and 
event.action:ConsoleLogin and 
aws.cloudtrail.user_identity.type:Root and 
event.outcome:failure
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Credential Access
- Id: TA0006
- Reference URL: [[https://attack.mitre.org/tactics/TA0006/](https://attack.mitre.org/tactics/TA0006/)](https://attack.mitre.org/tactics/TA0006/)
- Technique:
  - Name: Brute Force
- Id: T1110
- Reference URL: [[https://attack.mitre.org/techniques/T1110/](https://attack.mitre.org/techniques/T1110/)](https://attack.mitre.org/techniques/T1110/)