﻿---
title: AWS EC2 Unauthorized Admin Credential Fetch via Assumed Role
description: Identifies the first occurrence of an unauthorized attempt by an AWS role to use GetPassword to access the administrator password of an EC2 instance...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/aws/credential_access_aws_getpassword_for_ec2_instance
products:
  - Elastic Security
---

# AWS EC2 Unauthorized Admin Credential Fetch via Assumed Role
Identifies the first occurrence of an unauthorized attempt by an AWS role to use `GetPassword` to access the administrator password of an EC2 instance.
Adversaries may use this API call to escalate privileges or move laterally within EC2 instances.
**Rule type**: new_terms
**Rule indices**:
- filebeat-*
- logs-aws.cloudtrail*

**Rule Severity**: medium
**Risk Score**: 47
**Runs every**: 5m
**Searches indices from**: `now-6m`
**Maximum alerts per execution**: 100
**References**:
- [[https://cloud.hacktricks.xyz/pentesting-cloud/aws-security/aws-privilege-escalation/aws-ec2-privesc](https://cloud.hacktricks.xyz/pentesting-cloud/aws-security/aws-privilege-escalation/aws-ec2-privesc)](https://cloud.hacktricks.xyz/pentesting-cloud/aws-security/aws-privilege-escalation/aws-ec2-privesc)

**Tags**:
- Domain: Cloud
- Data Source: AWS
- Data Source: Amazon Web Services
- Data Source: AWS EC2
- Use Case: Identity and Access Audit
- Resources: Investigation Guide
- Tactic: Credential Access

**Version**: 7
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Investigation guide


## Triage and analysis


### Investigating AWS EC2 Unauthorized Admin Credential Fetch via Assumed Role

This rule detects the first occurrence of a role using the `GetPasswordData` API call, which retrieves the administrator password, against an unauthorized EC2 instance in AWS. This can be an indicator of an adversary attempting to escalate privileges or move laterally within EC2 instances.
This is a New Terms rule, which means it will only trigger once for each unique value of the `aws.cloudtrail.user_identity.session_context.session_issuer.arn` field that has not been seen making this API request within the last 7 days. This field contains the Amazon Resource Name (ARN) of the assumed role that triggered the API call.

#### Possible Investigation Steps

- **Identify the User Identity and Role**: Examine the AWS CloudTrail logs to determine the user identity that made the `GetPasswordData` request. Pay special attention to the role and permissions associated with the user.
- **Review Request Parameters**: Analyze the `aws.cloudtrail.request_parameters` and `aws.cloudtrail.error_message` fields to understand the context of the API call.
- **Contextualize with User Behavior**: Compare this activity against the role's typical behavior patterns. Look for unusual login times, IP addresses, or other anomalous actions taken by the role prior to and following the incident.
- **Review EC2 Instance Details**: Check the details of the EC2 instance from which the password retrieval was attempted. Assess the criticality and sensitivity of the applications running on this instance.
- **Examine Related CloudTrail Events**: Search for other API calls made by the same role, especially those modifying security groups, network access controls, or instance metadata.
- **Investigate the Origin of the API Call**: Analyze the IP address and geographical location from which the request originated. Determine if it aligns with expected locations for legitimate administrative activity.


### False Positive Analysis

- **Legitimate Administrative Actions**: Ensure that the activity was not part of legitimate administrative tasks such as system maintenance or updates.
- **Automation Scripts**: Verify if the activity was generated by automation or deployment scripts that are authorized to use `GetPasswordData` for legitimate purposes.


### Response and Remediation

- **User Account Review**: Review the permissions of the implicated user identity. Apply the principle of least privilege by adjusting permissions to prevent misuse.
- **Enhanced Monitoring**: Increase monitoring on the user identity that triggered the rule and similar EC2 instances.
- **Incident Response**: If malicious intent is confirmed, initiate the incident response protocol. This includes further investigation, containment of the threat, eradication of any threat actor presence, and recovery of affected systems.
- **Preventative Measures**: Implement or enhance security measures such as multi-factor authentication and continuous audits of sensitive operations like `GetPasswordData`.


### Additional Information

Refer to resources like [AWS privilege escalation methods](https://cloud.hacktricks.xyz/pentesting-cloud/aws-security/aws-privilege-escalation/aws-ec2-privesc) and the MITRE ATT&CK technique [T1552.005 - Cloud Instance Metadata API](https://attack.mitre.org/techniques/T1552/005/) for more details on potential vulnerabilities and mitigation strategies.

## Rule Query

```kuery
event.dataset:"aws.cloudtrail"
    and event.provider:"ec2.amazonaws.com" and event.action:"GetPasswordData"
    and aws.cloudtrail.user_identity.type:"AssumedRole" and aws.cloudtrail.error_code:"Client.UnauthorizedOperation"
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Credential Access
- Id: TA0006
- Reference URL: [[https://attack.mitre.org/tactics/TA0006/](https://attack.mitre.org/tactics/TA0006/)](https://attack.mitre.org/tactics/TA0006/)
- Technique:
  - Name: Unsecured Credentials
- Id: T1552
- Reference URL: [[https://attack.mitre.org/techniques/T1552/](https://attack.mitre.org/techniques/T1552/)](https://attack.mitre.org/techniques/T1552/)
- Sub Technique:
  - Name: Cloud Instance Metadata API
- Id: T1552.005
- Reference URL: [[https://attack.mitre.org/techniques/T1552/005/](https://attack.mitre.org/techniques/T1552/005/)](https://attack.mitre.org/techniques/T1552/005/)