﻿---
title: AWS CloudTrail Log Created
description: Detects creation of a new AWS CloudTrail trail via CreateTrail API. While legitimate during onboarding or auditing improvements, adversaries can create...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/aws/collection_cloudtrail_logging_created
products:
  - Elastic Security
---

# AWS CloudTrail Log Created
Detects creation of a new AWS CloudTrail trail via CreateTrail API. While legitimate during onboarding or auditing
improvements, adversaries can create trails that write to attacker-controlled destinations, limit regions, or otherwise
subvert monitoring objectives. New trails should be validated for destination ownership, encryption, multi-region
coverage, and organizational scope.
**Rule type**: query
**Rule indices**:
- filebeat-*
- logs-aws.cloudtrail-*

**Rule Severity**: low
**Risk Score**: 21
**Runs every**: 
**Searches indices from**: `now-6m`
**Maximum alerts per execution**: 100
**References**:
- [[https://docs.aws.amazon.com/awscloudtrail/latest/APIReference/API_CreateTrail.html](https://docs.aws.amazon.com/awscloudtrail/latest/APIReference/API_CreateTrail.html)](https://docs.aws.amazon.com/awscloudtrail/latest/APIReference/API_CreateTrail.html)
- [[https://awscli.amazonaws.com/v2/documentation/api/latest/reference/cloudtrail/create-trail.html](https://awscli.amazonaws.com/v2/documentation/api/latest/reference/cloudtrail/create-trail.html)](https://awscli.amazonaws.com/v2/documentation/api/latest/reference/cloudtrail/create-trail.html)

**Tags**:
- Domain: Cloud
- Data Source: AWS
- Data Source: Amazon Web Services
- Data Source: AWS Cloudtrail
- Use Case: Log Auditing
- Tactic: Collection
- Resources: Investigation Guide

**Version**: 212
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Investigation guide


## Triage and analysis


### Investigating AWS CloudTrail Log Created

AWS CloudTrail is a service that enables governance, compliance, and operational and risk auditing of your AWS account. It logs API calls and related events, providing visibility into user activity. Adversaries may create new trails to capture sensitive data or cover their tracks. This detection identifies
`CreateTrail` calls so responders can verify destination ownership, encryption, and scope before accepting the change.

#### Possible investigation steps

- **Identify the actor and context**
  - Review `aws.cloudtrail.user_identity.arn`, `aws.cloudtrail.user_identity.type`, `user_agent.original`, `source.ip`.
- Confirm a related change request exists (onboarding, architecture change).
- **Validate trail configuration**
  - In `aws.cloudtrail.request_parameters`, verify:
  - `S3BucketName`/`CloudWatchLogsLogGroupArn` belong to your org (no external accounts).
- `IsMultiRegionTrail=true` and `IncludeGlobalServiceEvents=true` (as per your standard).
- `KmsKeyId` is an approved CMK; log file validation enabled.
- **Correlate activity**
  - Look for `PutEventSelectors`, `PutInsightSelectors`, `StartLogging` following creation.
- Check for prior enumeration: `DescribeTrails`, `ListBuckets`, `GetEventSelectors`.


### False positive analysis

- **Planned creation**: Onboarding or compliance initiatives often add trails. Validate via ticket and standard template.
- **Automation**: IaC or control-tower pipelines may create trails on account bootstrap.


### Response and remediation

- **If unauthorized**
  - Disable or delete the trail; verify and secure the destination S3/CloudWatch resources.
- Review the actor’s recent changes and rotate credentials if compromise is suspected.
- **Hardening**
  - Restrict `cloudtrail:CreateTrail` to admin roles.
- Use AWS Config / Security Hub controls to enforce multi-region, global events, and validated destinations.


### Additional information

- **[AWS IR Playbooks](https://github.com/aws-samples/aws-incident-response-playbooks/blob/c151b0dc091755fffd4d662a8f29e2f6794da52c/playbooks/)**
- **[AWS Customer Playbook Framework](https://github.com/aws-samples/aws-customer-playbook-framework/tree/a8c7b313636b406a375952ac00b2d68e89a991f2/docs)**
- **Security Best Practices:** [AWS Knowledge Center – Security Best Practices](https://aws.amazon.com/premiumsupport/knowledge-center/security-best-practices/).


## Rule Query

```kuery
event.dataset: "aws.cloudtrail" 
    and event.provider: "cloudtrail.amazonaws.com" 
    and event.action: "CreateTrail" 
    and event.outcome: "success"
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Collection
- Id: TA0009
- Reference URL: [[https://attack.mitre.org/tactics/TA0009/](https://attack.mitre.org/tactics/TA0009/)](https://attack.mitre.org/tactics/TA0009/)
- Technique:
  - Name: Data from Cloud Storage
- Id: T1530
- Reference URL: [[https://attack.mitre.org/techniques/T1530/](https://attack.mitre.org/techniques/T1530/)](https://attack.mitre.org/techniques/T1530/)