﻿---
title: Web Server Suspicious User Agent Requests
description: This rule detects unusual spikes in web server requests with uncommon or suspicious user-agent strings. Such activity may indicate reconnaissance attempts...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/cross-platform/reconnaissance_web_server_unusual_user_agents
products:
  - Elastic Security
---

# Web Server Suspicious User Agent Requests
This rule detects unusual spikes in web server requests with uncommon or suspicious user-agent strings. Such activity may
indicate reconnaissance attempts by attackers trying to identify vulnerabilities in web applications or servers. These
user-agents are often associated with automated tools used for scanning, vulnerability assessment, or brute-force attacks.
**Rule type**: esql
**Rule indices**:
**Rule Severity**: low
**Risk Score**: 21
**Runs every**: 10m
**Searches indices from**: `now-11m`
**Maximum alerts per execution**: 100
**References**:
**Tags**:
- Domain: Web
- Use Case: Threat Detection
- Tactic: Reconnaissance
- Tactic: Credential Access
- Data Source: Nginx
- Data Source: Apache
- Data Source: Apache Tomcat
- Data Source: IIS
- Resources: Investigation Guide

**Version**: 2
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Investigation guide


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating Web Server Suspicious User Agent Requests

This rule flags surges of web requests that advertise scanner or brute-force tool user agents, signaling active reconnaissance against your web servers and applications. A common pattern is dirsearch or gobuster sweeping for hidden paths, firing hundreds of rapid GETs across diverse URLs from one host and probing admin panels, backup folders, and robots.txt.

### Possible investigation steps

- Verify whether the activity aligns with approved scanners or uptime checks by cross-referencing inventories, allowlists, change windows, and egress ranges; otherwise enrich the originating IP with ASN, geolocation, and threat reputation to gauge risk.
- Sample representative requests to identify targeted paths and payloads (e.g., admin panels, .git/.env, backups, traversal, SQLi/XSS markers) and note any successful responses or downloads that indicate information exposure.
- Analyze request rate, methods, and status-code distribution to separate noisy recon from successful discovery or brute-force patterns, highlighting any POST/PUT with nontrivial bodies.
- Correlate the same client across hosts and security layers (application/auth logs, WAF/CDN, IDS) to determine whether it is scanning multiple services, triggering signatures, or attempting credential stuffing.
- Assess user-agent authenticity and evasiveness by comparing HTTP header order/values and TLS fingerprints (JA3/JA4) to expected clients, and verify true client identity via forwarded-for headers if behind a proxy or CDN.


### False positive analysis

- Legitimate, scheduled vulnerability assessments by internal teams (e.g., Nessus, Nikto, or OpenVAS) can generate large volumes of requests with those user-agent strings across many paths.
- Developer or QA testing using discovery/fuzzing or intercept-proxy tools (Dirsearch, Gobuster, Ffuf, Burp, or OWASP ZAP) may unintentionally target production hosts, producing a short-lived spike with diverse URLs.


### Response and remediation

- Immediately contain by blocking or rate-limiting the originating IPs at the WAF/CDN and edge firewall, and add temporary rules to drop or challenge requests that advertise tool user agents such as "nikto", "sqlmap", "dirsearch", "wpscan", "gobuster", or "burp".
- If traffic is proxied (CDN/reverse proxy), identify the true client via forwarded headers and extend blocks at both layers, enabling bot management or JS challenges on swept paths like /admin, /.git, /.env, /backup, and common discovery endpoints.
- Eradicate exposure by removing or restricting access to sensitive files and directories uncovered by the scans, rotating any credentials or API keys found, invalidating active sessions, and disabling public access to administrative panels until hardened.
- Recover by verifying no unauthorized changes or data exfiltration occurred, tuning per-IP and per-path rate limits to prevent path-sweeps while preserving legitimate traffic, and reintroducing normal rules only after fixes are deployed and stability is confirmed.
- Escalate to incident response if sensitive files are successfully downloaded (HTTP 200/206 on /.git, /.env, or backups), any login or account creation succeeds, multiple hosts or environments are targeted, or activity persists after blocking via UA spoofing or rapid IP rotation.
- Harden long term by enforcing WAF signatures for known scanner UAs and path patterns, denying directory listing and direct access to /.git, /.env, /backup and similar artifacts, requiring MFA/VPN for /admin and management APIs, and deploying auto-ban controls like fail2ban or mod_security.


## Rule Query

```esql
from logs-nginx.access-*, logs-apache.access-*, logs-apache_tomcat.access-*, logs-iis.access-*

| eval Esql.user_agent_original_to_lower = to_lower(user_agent.original), Esql.url_original_to_lower = to_lower(url.original)

| where
    Esql.user_agent_original_to_lower like "mozilla/5.0 (windows nt 10.0; win64; x64) applewebkit/537.36 (khtml, like gecko) chrome/74.0.3729.169 safari/537.36" or
    Esql.user_agent_original_to_lower like "nikto*" or
    Esql.user_agent_original_to_lower like "mozilla/4.0 (compatible; msie 8.0; windows nt 5.1; trident/4.0)" or
    Esql.user_agent_original_to_lower like "*nessus*" or
    Esql.user_agent_original_to_lower like "sqlmap/*" or
    Esql.user_agent_original_to_lower like "wpscan*" or
    Esql.user_agent_original_to_lower like "feroxbuster/*" or
    Esql.user_agent_original_to_lower like "masscan*" or
    Esql.user_agent_original_to_lower like "fuzz*" or
    Esql.user_agent_original_to_lower like "mozilla/5.0 (windows nt 10.0; win64; x64) applewebkit/537.36 (khtml, like gecko) chrome/user_agent.original like~ 87.0.4280.88 safari/537.36" or // Dirsearch
    Esql.user_agent_original_to_lower like "mozilla/4.0 (compatible; msie 6.0; windows nt 5.1)" or
    Esql.user_agent_original_to_lower like "dirbuster*" or
    Esql.user_agent_original_to_lower like "gobuster/*" or
    Esql.user_agent_original_to_lower like "*dirsearch*" or
    Esql.user_agent_original_to_lower like "*nmap*" or
    Esql.user_agent_original_to_lower like "*hydra*" or
    Esql.user_agent_original_to_lower like "*w3af*" or
    Esql.user_agent_original_to_lower like "*arachni*" or
    Esql.user_agent_original_to_lower like "*skipfish*" or
    Esql.user_agent_original_to_lower like "*openvas*" or
    Esql.user_agent_original_to_lower like "*acunetix*" or
    Esql.user_agent_original_to_lower like "*zap*" or
    Esql.user_agent_original_to_lower like "*burp*"

| keep
    @timestamp,
    event.dataset,
    user_agent.original,
    source.ip,
    agent.id,
    host.name,
    Esql.url_original_to_lower,
    Esql.user_agent_original_to_lower,
    data_stream.namespace
| stats
    Esql.event_count = count(),
    Esql.url_original_count_distinct = count_distinct(Esql.url_original_to_lower),
    Esql.host_name_values = values(host.name),
    Esql.agent_id_values = values(agent.id),
    Esql.url_original_values = values(Esql.url_original_to_lower),
    Esql.user_agent_original_values = values(Esql.user_agent_original_to_lower),
    Esql.event_dataset_values = values(event.dataset),
    Esql.data_stream_namespace_values = values(data_stream.namespace)
    by source.ip, agent.id
| where
    Esql.event_count > 50 and Esql.url_original_count_distinct > 10
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Reconnaissance
- Id: TA0043
- Reference URL: [[https://attack.mitre.org/tactics/TA0043/](https://attack.mitre.org/tactics/TA0043/)](https://attack.mitre.org/tactics/TA0043/)
- Technique:
  - Name: Active Scanning
- Id: T1595
- Reference URL: [[https://attack.mitre.org/techniques/T1595/](https://attack.mitre.org/techniques/T1595/)](https://attack.mitre.org/techniques/T1595/)
- Sub Technique:
  - Name: Scanning IP Blocks
- Id: T1595.001
- Reference URL: [[https://attack.mitre.org/techniques/T1595/001/](https://attack.mitre.org/techniques/T1595/001/)](https://attack.mitre.org/techniques/T1595/001/)
- Sub Technique:
  - Name: Vulnerability Scanning
- Id: T1595.002
- Reference URL: [[https://attack.mitre.org/techniques/T1595/002/](https://attack.mitre.org/techniques/T1595/002/)](https://attack.mitre.org/techniques/T1595/002/)
- Sub Technique:
  - Name: Wordlist Scanning
- Id: T1595.003
- Reference URL: [[https://attack.mitre.org/techniques/T1595/003/](https://attack.mitre.org/techniques/T1595/003/)](https://attack.mitre.org/techniques/T1595/003/)

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Credential Access
- Id: TA0006
- Reference URL: [[https://attack.mitre.org/tactics/TA0006/](https://attack.mitre.org/tactics/TA0006/)](https://attack.mitre.org/tactics/TA0006/)
- Technique:
  - Name: Brute Force
- Id: T1110
- Reference URL: [[https://attack.mitre.org/techniques/T1110/](https://attack.mitre.org/techniques/T1110/)](https://attack.mitre.org/techniques/T1110/)