﻿---
title: SUID/SGID Bit Set
description: An adversary may add the setuid or setgid bit to a file or directory in order to run a file with the privileges of the owning user or group. An adversary...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/cross-platform/privilege_escalation_setuid_setgid_bit_set_via_chmod
products:
  - Elastic Security
---

# SUID/SGID Bit Set
An adversary may add the setuid or setgid bit to a file or directory in order to run a file with the privileges of the
owning user or group. An adversary can take advantage of this to either do a shell escape or exploit a vulnerability in
an application with the setuid or setgid bit to get code running in a different user’s context. Additionally,
adversaries can use this mechanism on their own malware to make sure they're able to execute in elevated contexts in the
future.
**Rule type**: eql
**Rule indices**:
- auditbeat-*
- logs-endpoint.events.*

**Rule Severity**: low
**Risk Score**: 21
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 33
**References**:
- [[https://www.elastic.co/security-labs/primer-on-persistence-mechanisms](https://www.elastic.co/security-labs/primer-on-persistence-mechanisms)](https://www.elastic.co/security-labs/primer-on-persistence-mechanisms)

**Tags**:
- Domain: Endpoint
- OS: Linux
- OS: macOS
- Use Case: Threat Detection
- Tactic: Privilege Escalation
- Data Source: Elastic Defend
- Resources: Investigation Guide

**Version**: 109
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Investigation guide


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating SUID/SGID Bit Set

The SUID/SGID bits in Unix-like systems allow files to execute with the privileges of the file owner or group, enabling necessary elevated permissions for certain applications. However, adversaries can exploit these bits to escalate privileges by modifying files to run with higher access rights. The detection rule identifies suspicious use of commands like `chmod` or `install` to set these bits, excluding known safe paths, to flag potential privilege escalation attempts.

### Possible investigation steps

- Review the process details to identify the user who executed the command, focusing on the process.name and process.args fields to understand the specific command and arguments used.
- Check the process.parent.executable field to determine the parent process and assess whether it is a known legitimate process or potentially malicious.
- Investigate the file or directory targeted by the SUID/SGID bit modification by examining the process.args field for any unusual or sensitive paths that could indicate privilege escalation attempts.
- Correlate the event with other recent activities from the same user or system to identify any patterns or anomalies that could suggest malicious behavior.
- Verify if the file or directory with modified SUID/SGID bits is part of a known safe path as listed in the exclusion criteria, and assess whether the modification is expected or authorized.


### False positive analysis

- System package installations or updates may trigger the rule when legitimate processes like package managers set SUID/SGID bits. To handle this, exclude paths related to package management, such as "/var/lib/dpkg/info*".
- Docker or container-related operations might set these bits during normal operations. Exclude paths like "/var/lib/docker/*" to prevent false positives from container management activities.
- Temporary directories used during system operations, such as "/tmp/newroot/*", can cause false alerts. Exclude these paths to avoid unnecessary alerts from temporary system processes.
- Specific system services or applications, like "/usr/bin/ssh-agent", may require SUID/SGID bits for legitimate functionality. Exclude these known safe executables to reduce false positives.
- Custom scripts or applications that are known to require elevated permissions should be reviewed and, if deemed safe, added to the exclusion list to prevent repeated false alerts.


### Response and remediation

- Immediately isolate the affected system from the network to prevent further unauthorized access or privilege escalation.
- Identify and terminate any suspicious processes associated with the use of `chmod` or `install` commands that have set the SUID/SGID bits, especially those not in the excluded safe paths.
- Review and revert any unauthorized changes to file permissions, specifically those with SUID/SGID bits set, to their original state.
- Conduct a thorough audit of user accounts and privileges on the affected system to ensure no unauthorized accounts or privilege escalations have occurred.
- Implement additional monitoring on the affected system to detect any further attempts to exploit SUID/SGID bits, focusing on the specific commands and arguments identified in the detection query.
- Escalate the incident to the security operations team for a deeper investigation into potential lateral movement or persistence mechanisms that may have been established by the adversary.
- Apply patches and updates to the affected system and any vulnerable applications to mitigate known vulnerabilities that could be exploited in conjunction with SUID/SGID bit abuse.


## Rule Query

```eql
process where host.os.type == "linux" and event.type == "start" and event.action == "exec" and (
  (process.name == "chmod" and (process.args : ("+s", "u+s", "g+s") or process.args regex "[24][0-9]{3}")) or
  (process.name == "install" and process.args : "-m" and
  (process.args : ("+s", "u+s", "g+s") or process.args regex "[24][0-9]{3}"))
) and not (
  process.parent.executable : (
    "/usr/NX/*", "/var/lib/docker/*", "/var/lib/dpkg/info*", "/tmp/newroot/*", "/usr/bin/find", "/opt/commvault/Base/Galaxy",
    "/System/Library/PrivateFrameworks/PackageKit.framework/Versions/A/XPCServices/package_script_service.xpc/Contents/MacOS/package_script_service",
    "/opt/metallic/Base/Galaxy"
  ) or
  process.args : (
    "/run/*", "/var/run/*", "/usr/bin/keybase-redirector", "/usr/local/share/fonts", "/usr/bin/ssh-agent"
  ) or
  process.parent.args like ("/var/lib/dpkg/info/*", "/var/tmp/rpm-tmp*", "/usr/NX/*")
)
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Privilege Escalation
- Id: TA0004
- Reference URL: [[https://attack.mitre.org/tactics/TA0004/](https://attack.mitre.org/tactics/TA0004/)](https://attack.mitre.org/tactics/TA0004/)
- Technique:
  - Name: Abuse Elevation Control Mechanism
- Id: T1548
- Reference URL: [[https://attack.mitre.org/techniques/T1548/](https://attack.mitre.org/techniques/T1548/)](https://attack.mitre.org/techniques/T1548/)
- Sub Technique:
  - Name: Setuid and Setgid
- Id: T1548.001
- Reference URL: [[https://attack.mitre.org/techniques/T1548/001/](https://attack.mitre.org/techniques/T1548/001/)](https://attack.mitre.org/techniques/T1548/001/)

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Persistence
- Id: TA0003
- Reference URL: [[https://attack.mitre.org/tactics/TA0003/](https://attack.mitre.org/tactics/TA0003/)](https://attack.mitre.org/tactics/TA0003/)