﻿---
title: Newly Observed High Severity Detection Alert
description: This rule detects Elastic SIEM high severity detection alerts that are observed for the first time in the previous 5 days of alert history. It highlights...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/cross-platform/newly_observed_elastic_detection_rule
products:
  - Elastic Security
---

# Newly Observed High Severity Detection Alert
This rule detects Elastic SIEM high severity detection alerts that are observed for the first time in the previous 5 days
of alert history. It highlights low-volume, newly observed alerts tied to a specific detection rule, analysts can use this
to prioritize triage and response.
**Rule type**: esql
**Rule indices**:
**Rule Severity**: high
**Risk Score**: 73
**Runs every**: 5m
**Searches indices from**: `now-7205m`
**Maximum alerts per execution**: 100
**References**:
- [[https://www.elastic.co/docs/solutions/security/detect-and-alert/about-detection-rules](https://www.elastic.co/docs/solutions/security/detect-and-alert/about-detection-rules)](https://www.elastic.co/docs/solutions/security/detect-and-alert/about-detection-rules)

**Tags**:
- Use Case: Threat Detection
- Rule Type: Higher-Order Rule
- Resources: Investigation Guide

**Version**: 2
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Investigation guide


## Triage and analysis


### Investigating Newly Observed High Severity Detection Alert

This rule surfaces newly observed, low-frequency behavior high severity alerts affecting a single agent within the current day.
Because the alert has not been seen previously for this rule and host, it should be prioritized for validation to determine
whether it represents a true compromise or rare benign activity.

### Investigation Steps

- Identify the affected host, user and review the associated rule name to understand the behavior that triggered the alert.
- Validate the user context under which the activity occurred and assess whether it aligns with normal behavior for that account.
- Refer to the specific rule investiguation guide for further actions.


### False Positive Considerations

- Newly deployed or updated software may introduce behavior not previously observed on the host.
- Administrative scripts or automation tools can trigger behavior-based detections when first introduced.
- Security tooling, IT management agents, or EDR integrations may generate new behavior alerts during updates or configuration changes.
- Development or testing environments may produce one-off behaviors that resemble malicious techniques.


### Response and Remediation

- If the activity is confirmed malicious, isolate the affected host to prevent further execution or lateral movement.
- Terminate malicious processes and remove any dropped files or persistence mechanisms.
- Collect forensic artifacts to understand initial access and execution flow.
- Patch or remediate any vulnerabilities or misconfigurations that enabled the behavior.
- If benign, document the finding and consider tuning or exception handling to reduce future noise.
- Continue monitoring the host and environment for recurrence of the behavior or related alerts.


## Rule Query

```esql
FROM .alerts-security.*
| where kibana.alert.rule.name is not null and kibana.alert.risk_score >= 73  and
  not kibana.alert.rule.type in ("threat_match", "machine_learning", "new_terms") and
  not kibana.alert.rule.name like "Deprecated - *" and kibana.alert.rule.name != "My First Rule" and
  // covered by 7306ce7d-5c90-4f42-aa6c-12b0dc2fe3b8
  event.dataset != "endpoint.alerts"
| STATS Esql.alerts_count = count(*),
        Esql.first_time_seen = MIN(@timestamp),
        Esql.last_time_seen = MAX(@timestamp),
        Esql.process_executable = VALUES(process.executable),
        Esql.cmd_line = VALUES(process.command_line),
        Esql.parent_executable = VALUES(process.parent.executable),
        Esql.file_path_values = VALUES(file.path),
        Esql.file_path_values = VALUES(file.path),
        Esql.dll_path_values = VALUES(dll.path),
        Esql.user_id_values = VALUES(user.id),
        Esql.user_name_values = VALUES(user.name),
        Esql.agent_id_values = VALUES(agent.id),
        Esql.host_id_values = VALUES(host.id),
        Esql.event_module_values = VALUES(event.module),
        Esql.source_ip_values = VALUES(source.ip),
        Esql.agents_distinct_count = COUNT_DISTINCT(agent.id) by kibana.alert.rule.name
// fist time seen in the last 5 days - defined in the rule schedule Additional look-back time
| eval Esql.recent = DATE_DIFF("minute", Esql.first_time_seen, now())
// first time seen is within 10m of the rule execution time
| where Esql.recent <= 10 and Esql.agents_distinct_count == 1 and Esql.alerts_count <= 10 and (Esql.last_time_seen == Esql.first_time_seen)

// Move single values to their corresponding ECS fields for alerts exclusion
| eval host.id = mv_min(Esql.host_id_values)

| keep host.id, kibana.alert.rule.name, Esql.*
```