﻿---
title: Newly Observed Elastic Defend Behavior Alert
description: This rule detects Elastic Defend behavior alerts that are observed for the first time today when compared against the previous 5 days of alert history...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/cross-platform/newly_observed_elastic_defend_alert
products:
  - Elastic Security
---

# Newly Observed Elastic Defend Behavior Alert
This rule detects Elastic Defend behavior alerts that are observed for the first time today when compared against the previous
5 days of alert history. It highlights low-volume, newly observed alerts tied to a specific detection rule, analysts can use
this to prioritize triage and response.
**Rule type**: esql
**Rule indices**:
**Rule Severity**: high
**Risk Score**: 73
**Runs every**: 5m
**Searches indices from**: `now-7205m`
**Maximum alerts per execution**: 100
**References**:
- [[https://github.com/elastic/protections-artifacts/tree/main/behavior](https://github.com/elastic/protections-artifacts/tree/main/behavior)](https://github.com/elastic/protections-artifacts/tree/main/behavior)

**Tags**:
- Use Case: Threat Detection
- Rule Type: Higher-Order Rule
- Resources: Investigation Guide
- Data Source: Elastic Defend

**Version**: 2
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Investigation guide


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating Newly Observed Elastic Defend Behavior Alert

Elastic Defend behavior alerts indicate suspicious activity observed on an endpoint that may not yet be widespread or repeated.
This rule surfaces newly observed, low-frequency behavior alerts affecting a single agent within the current day, which can
represent early-stage malware execution, initial persistence attempts, or hands-on-keyboard activity.
Because the alert has not been seen previously for this rule and host, it should be prioritized for validation to determine
whether it represents a true compromise or rare benign activity.

### Investigation Steps

- Identify the affected host and review the associated Elastic Defend rule name to understand the behavior that triggered the alert.
- Review the process details, including executable path, parent process, command line, and SHA-256 hash.
- Determine whether the process is expected on the host by validating its origin, signer, and execution context.
- Examine the alert timeline to confirm that all activity occurred within a short time window and assess whether behavior escalated.
- Correlate with additional endpoint telemetry such as:
  - Process creation and termination
- File modifications
- Network connections
- Registry or persistence-related activity
- Check whether the process hash, command line, or related indicators are known malicious or associated with recent campaigns.
- Validate the user context under which the activity occurred and assess whether it aligns with normal behavior for that account.


### False Positive Considerations

- Newly deployed or updated software may introduce behavior not previously observed on the host.
- Administrative scripts or automation tools can trigger behavior-based detections when first introduced.
- Security tooling, IT management agents, or EDR integrations may generate new behavior alerts during updates or configuration changes.
- Development or testing environments may produce one-off behaviors that resemble malicious techniques.


### Response and Remediation

- If the activity is confirmed malicious, isolate the affected host to prevent further execution or lateral movement.
- Terminate malicious processes and remove any dropped files or persistence mechanisms.
- Collect forensic artifacts to understand initial access and execution flow.
- Patch or remediate any vulnerabilities or misconfigurations that enabled the behavior.
- If benign, document the finding and consider tuning or exception handling to reduce future noise.
- Continue monitoring the host and environment for recurrence of the behavior or related alerts.


## Rule Query

```esql
from logs-endpoint.alerts-*
| WHERE event.code == "behavior" and rule.name is not null
| STATS Esql.alerts_count = count(*),
        Esql.first_time_seen = MIN(@timestamp),
        Esql.last_time_seen = MAX(@timestamp),
        Esql.agents_distinct_count = COUNT_DISTINCT(agent.id),
        Esql.process_executable = VALUES(process.executable),
        Esql.process_parent_executable = VALUES(process.parent.executable),
        Esql.process_command_line = VALUES(process.command_line),
        Esql.process_hash_sha256 = VALUES(process.hash.sha256),
        Esql.host_id_values = VALUES(host.id),
        Esql.user_name = VALUES(user.name) by rule.name
// first time seen in the last 5 days - defined in the rule schedule Additional look-back time
| eval Esql.recent = DATE_DIFF("minute", Esql.first_time_seen, now())
// first time seen is within 10m of the rule execution time
| where Esql.recent <= 10 and Esql.agents_distinct_count == 1 and Esql.alerts_count <= 10 and (Esql.last_time_seen == Esql.first_time_seen)

// Move single values to their corresponding ECS fields for alerts exclusion
| eval host.id = mv_min(Esql.host_id_values)

| keep host.id, rule.name, Esql.*
```