﻿---
title: Multiple Machine Learning Alerts by Influencer Field
description: This rule uses alerts data to determine when multiple unique machine learning jobs involving the same influencer field are triggered. Analysts can use...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/cross-platform/multiple_machine_learning_jobs_by_entity
products:
  - Elastic Security
---

# Multiple Machine Learning Alerts by Influencer Field
This rule uses alerts data to determine when multiple unique machine learning jobs involving the same influencer field are triggered.
Analysts can use this to prioritize triage and response machine learning alerts.
**Rule type**: esql
**Rule indices**:
**Rule Severity**: high
**Risk Score**: 73
**Runs every**: 30m
**Searches indices from**: `now-45m`
**Maximum alerts per execution**: 100
**References**:
- [[https://www.elastic.co/guide/en/security/current/prebuilt-ml-jobs.html](https://www.elastic.co/guide/en/security/current/prebuilt-ml-jobs.html)](https://www.elastic.co/guide/en/security/current/prebuilt-ml-jobs.html)

**Tags**:
- Use Case: Threat Detection
- Rule Type: Higher-Order Rule
- Resources: Investigation Guide
- Rule Type: Machine Learning

**Version**: 1
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Investigation guide


## Triage and analysis


### Multiple Machine Learning Alerts by Influencer Field

Attackers may trigger multiple alerts by performing suspicious actions under a compromised user entity. The detection rule identifies such patterns by correlating diverse machine learning alerts linked to the same entity, excluding known system accounts, thus prioritizing potential threats for analysts.

### Possible investigation steps

- Review the alert details to identify the specific influencer field involved to gather initial context.
- Examine the timeline and sequence of the triggered alerts to understand the pattern of activity associated with the influencer field, noting any unusual or unexpected actions.
- Cross-reference the user activity with known legitimate activities or scheduled tasks to rule out false positives, ensuring that the actions are not part of normal operations.
- Investigate the source and destination IP addresses associated with the alerts to identify any suspicious or unauthorized access points.
- Check for any recent changes in user permissions or group memberships that could indicate privilege escalation attempts.
- Look into any recent login attempts or authentication failures for the user account to detect potential brute force or credential stuffing attacks.
- Collaborate with the user or their manager to verify if the activities were authorized or if the account might be compromised.


### False positive analysis

- Alerts triggered by automated system processes or scripts that mimic user behavior can be false positives. To manage these, identify and exclude known benign scripts or processes from the rule.
- Frequent alerts from users in roles that inherently require access to multiple systems or sensitive data, such as IT administrators, may not indicate compromise. Implement role-based exceptions to reduce noise.
- Alerts generated by legitimate software updates or maintenance activities can be mistaken for suspicious behavior. Schedule these activities during known maintenance windows and exclude them from the rule during these times.
- Users involved in testing or development environments may trigger multiple alerts due to their work nature. Create exceptions for these environments to prevent unnecessary alerts.
- High-volume users, such as those in customer support or sales, may naturally generate more alerts. Monitor these users separately and adjust the rule to focus on unusual patterns rather than volume alone.


### Response and remediation

- Isolate the affected user account immediately to prevent further unauthorized access. Disable the account or change the password to stop any ongoing malicious activity.
- Conduct a thorough review of the affected user's recent activities and access logs to identify any unauthorized actions or data access. This will help in understanding the scope of the compromise.
- Remove any malicious software or unauthorized tools that may have been installed on the user's system. Use endpoint detection and response (EDR) tools to scan and clean the system.
- Restore any altered or deleted data from backups, ensuring that the restored data is free from any malicious modifications.
- Notify relevant stakeholders, including IT security teams and management, about the incident and the steps being taken to address it. This ensures that everyone is aware and can provide support if needed.
- Implement additional monitoring on the affected user account and related systems to detect any further suspicious activities. This includes setting up alerts for unusual login attempts or data access patterns.
- Review and update access controls and permissions for the affected user and similar accounts to prevent future incidents. Ensure that least privilege principles are applied.


## Rule Query

```esql
from .alerts-security.*
| where kibana.alert.rule.type == "machine_learning"
| stats Esql.count_distinct_job_id = COUNT_DISTINCT(job_id),
        Esql.job_id_values = VALUES(job_id),
        Esql.rule_name_values = VALUES(kibana.alert.rule.name),
        Esql.influencer_field_values = VALUES(influencers.influencer_field_values),
        Esql.influencer_field_name = VALUES(influencers.influencer_field_name) by influencers.influencer_field_values, process.name, host.name
| where Esql.count_distinct_job_id >= 3 and not influencers.influencer_field_values in ("root", "SYSTEM")
| KEEP influencers.influencer_field_values, process.name, host.name, Esql.*
```