﻿---
title: Multiple External EDR Alerts by Host
description: This rule uses alert data to determine when multiple external EDR alerts involving the same host are triggered. Analysts can use this to prioritize triage...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/cross-platform/multiple_external_edr_alerts_by_host
products:
  - Elastic Security
---

# Multiple External EDR Alerts by Host
This rule uses alert data to determine when multiple external EDR alerts involving the same host are triggered. Analysts
can use this to prioritize triage and response, as these hosts are more likely to be compromised.
**Rule type**: esql
**Rule indices**:
**Rule Severity**: high
**Risk Score**: 73
**Runs every**: 30m
**Searches indices from**: `now-60m`
**Maximum alerts per execution**: 100
**References**:
- [[https://github.com/elastic/detection-rules/blob/main/rules/promotions/external_alerts.toml](https://github.com/elastic/detection-rules/blob/main/rules/promotions/external_alerts.toml)](https://github.com/elastic/detection-rules/blob/main/rules/promotions/external_alerts.toml)

**Tags**:
- Use Case: Threat Detection
- Rule Type: Higher-Order Rule
- Resources: Investigation Guide
- Domain: Endpoint

**Version**: 1
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Investigation guide


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating Multiple External EDR Alerts by Host

Endpoint security technologies monitor and analyze activities on devices to detect malicious behavior. Adversaries exploit these systems by deploying malware that triggers specific signatures across multiple hosts, indicating a coordinated attack. The detection rule identifies such threats by analyzing alert data for specific malware signatures across several hosts, flagging potential widespread infections for prioritized investigation.

### Possible investigation steps

- Review the alert details to identify the specific host involved and the different ATT&CK tactics that triggered the alerts.
- Examine the timeline of the alerts to understand the sequence of events and determine if there is a pattern or progression in the tactics used.
- Correlate the alert data with other logs and telemetry from the host, such as process creation, network connections, and file modifications, to gather additional context.
- Investigate any known vulnerabilities or misconfigurations on the host that could have been exploited by the adversary.
- Check for any indicators of compromise (IOCs) associated with the alerts, such as suspicious IP addresses, domains, or file hashes, and search for these across the network.
- Assess the impact and scope of the potential compromise by determining if other hosts or systems have similar alerts or related activity.


### False positive analysis

- Alerts from routine administrative tasks may trigger multiple tactics. Review and exclude known benign activities such as scheduled software updates or system maintenance.
- Security tools running on the host might generate alerts across different tactics. Identify and exclude alerts from trusted security applications to reduce noise.
- Automated scripts or batch processes can mimic adversarial behavior. Analyze and whitelist these processes if they are verified as non-threatening.
- Frequent alerts from development or testing environments can be misleading. Consider excluding these environments from the rule or applying a different risk score.
- User behavior anomalies, such as accessing multiple systems or applications, might trigger alerts. Implement user behavior baselines to differentiate between normal and suspicious activities.


### Response and remediation

- Isolate the affected host from the network immediately to prevent further lateral movement by the adversary.
- Conduct a thorough forensic analysis of the host to identify the specific vulnerabilities exploited and gather evidence of the attack phases involved.
- Remove any identified malicious software or unauthorized access tools from the host, ensuring all persistence mechanisms are eradicated.
- Apply security patches and updates to the host to address any exploited vulnerabilities and prevent similar attacks.
- Restore the host from a known good backup if necessary, ensuring that the backup is free from compromise.
- Monitor the host and network for any signs of re-infection or further suspicious activity, using enhanced logging and alerting based on the identified attack patterns.
- Escalate the incident to the appropriate internal or external cybersecurity teams for further investigation and potential legal action if the attack is part of a larger campaign.


## Rule Query

```esql
from .alerts-security.*
| WHERE event.dataset in ("crowdstrike.alert", "crowdstrike.falcon", "sentinel_one.alert", "sentinel_one.threat", "m365_defender.alert") and
        host.id is not null and kibana.alert.risk_score > 21 and
        not (event.module == "crowdstrike" and (kibana.alert.rule.name like "* at *" or kibana.alert.rule.name like "* on *" or kibana.alert.rule.name == "EICARTestFileWrittenWin"))
| stats Esql.alerts_count = COUNT(*),
        Esql.rule_risk_score_distinct_count = COUNT_DISTINCT(kibana.alert.risk_score),
        Esql.unique_rules_count = COUNT_DISTINCT(kibana.alert.rule.name),
        Esql.processes_count = COUNT_DISTINCT(process.executable),
        Esql.files_count = COUNT_DISTINCT(file.path),
        Esql.process_cmdline_count = COUNT_DISTINCT(process.command_line),
        Esql.rule_risk_score_values = VALUES(kibana.alert.risk_score),
        Esql.process_path_values = VALUES(process.executable),
        Esql.file_path_values = VALUES(file.path),
        Esql.user_name_values = VALUES(user.name),
        Esql.process_command_line_values = VALUES(process.command_line),
        Esql.process_parent_command_line_values = VALUES(process.parent.command_line),
        Esql.rule_name_values = VALUES(kibana.alert.rule.name) by host.id, host.name, event.module
| where (
	// 3+ unique rules or processes
  (
    Esql.unique_rules_count >= 3 or
    (Esql.processes_count >= 3 and Esql.rule_name_values == "External Alerts")
  ) and
  	// and 2+ rules of different severity, or 1 high/critical severity rule
  (
    Esql.rule_risk_score_distinct_count >= 2 or
    Esql.rule_risk_score_values == 73 or
    Esql.rule_risk_score_values == 99
  )
) or
  // or 5+ unique rules from the same host for 1+ path/command_line/process
  (Esql.unique_rules_count >= 5 and Esql.alerts_count <= 50 and
  (Esql.files_count >= 1 or Esql.process_cmdline_count >= 1 or Esql.processes_count >= 1)
)
| KEEP event.module, host.id, host.name, Esql.*
```