﻿---
title: Alerts in Different ATT&CK Tactics by Host
description: This rule uses alert data to determine when multiple alerts in different phases of an attack involving the same host are triggered and where the accumulated...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/cross-platform/multiple_alerts_risky_host_esql
products:
  - Elastic Security
---

# Alerts in Different ATT&CK Tactics by Host
This rule uses alert data to determine when multiple alerts in different phases of an attack involving the same host are
triggered and where the accumulated risk score is higher than a defined threshold. Analysts can use this to prioritize
triage and response, as these hosts are more likely to be compromised.
**Rule type**: esql
**Rule indices**:
**Rule Severity**: high
**Risk Score**: 73
**Runs every**: 1h
**Searches indices from**: `now-8h`
**Maximum alerts per execution**: 100
**References**:
**Tags**:
- Use Case: Threat Detection
- Rule Type: Higher-Order Rule
- Resources: Investigation Guide

**Version**: 1
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Investigation guide


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating Alerts in Different ATT&CK Tactics by Host

The detection rule identifies hosts with alerts across various attack phases, indicating potential compromise. Adversaries exploit system vulnerabilities, moving through different tactics like execution, persistence, and exfiltration. This rule prioritizes hosts with diverse tactic alerts, aiding analysts in focusing on high-risk threats by correlating alert data to detect complex attack patterns.

### Possible investigation steps

- Review the alert details to identify the specific host involved and the different ATT&CK tactics that triggered the alerts.
- Examine the timeline of the alerts to understand the sequence of events and determine if there is a pattern or progression in the tactics used.
- Correlate the alert data with other logs and telemetry from the host, such as process creation, network connections, and file modifications, to gather additional context.
- Investigate any known vulnerabilities or misconfigurations on the host that could have been exploited by the adversary.
- Check for any indicators of compromise (IOCs) associated with the alerts, such as suspicious IP addresses, domains, or file hashes, and search for these across the network.
- Assess the impact and scope of the potential compromise by determining if other hosts or systems have similar alerts or related activity.


### False positive analysis

- Alerts from routine administrative tasks may trigger multiple tactics. Review and exclude known benign activities such as scheduled software updates or system maintenance.
- Security tools running on the host might generate alerts across different tactics. Identify and exclude alerts from trusted security applications to reduce noise.
- Automated scripts or batch processes can mimic adversarial behavior. Analyze and whitelist these processes if they are verified as non-threatening.
- Frequent alerts from development or testing environments can be misleading. Consider excluding these environments from the rule or applying a different risk score.
- User behavior anomalies, such as accessing multiple systems or applications, might trigger alerts. Implement user behavior baselines to differentiate between normal and suspicious activities.


### Response and remediation

- Isolate the affected host from the network immediately to prevent further lateral movement by the adversary.
- Conduct a thorough forensic analysis of the host to identify the specific vulnerabilities exploited and gather evidence of the attack phases involved.
- Remove any identified malicious software or unauthorized access tools from the host, ensuring all persistence mechanisms are eradicated.
- Apply security patches and updates to the host to address any exploited vulnerabilities and prevent similar attacks.
- Restore the host from a known good backup if necessary, ensuring that the backup is free from compromise.
- Monitor the host and network for any signs of re-infection or further suspicious activity, using enhanced logging and alerting based on the identified attack patterns.
- Escalate the incident to the appropriate internal or external cybersecurity teams for further investigation and potential legal action if the attack is part of a larger campaign.


## Rule Query

```esql
from .alerts-security.*  metadata _id

// filter for alerts with populated risk score, excluding threat_match rules, deprecated and some other noisy ones.
| where kibana.alert.risk_score > 0 and
        kibana.alert.rule.name IS NOT NULL and
        host.id is not null and event.dataset is not null and
        kibana.alert.rule.type != "threat_match" and
        not kibana.alert.rule.name in ("Agent Spoofing - Mismatched Agent ID") and
        not kibana.alert.rule.name like "Deprecated - *"

// extract unique counts and values by host.id
| stats Esql.alerts_count = COUNT(*),
        Esql.kibana_alert_rule_name_distinct_count = COUNT_DISTINCT(kibana.alert.rule.name),
        Esql.event_module_distinct_count = COUNT_DISTINCT(event.module),
        Esql.event_module_values = VALUES(event.module),
        Esql.kibana_alert_rule_name_values = VALUES(kibana.alert.rule.name),
        Esql.threat_tactic_id_distinct_count = COUNT_DISTINCT(kibana.alert.rule.threat.tactic.id),
        Esql.threat_tactic_name_values = VALUES(kibana.alert.rule.threat.tactic.name),
        Esql.kibana_alert_risk_score_sum = sum(kibana.alert.risk_score),
        Esql.process_executable_values = VALUES(process.executable),
        Esql.process_parent_executable_values = VALUES(process.parent.executable),
        Esql.process_command_line_values = VALUES(process.command_line),
        Esql.process_entity_id_distinct_count = COUNT_DISTINCT(process.entity_id) by host.id

// divide the sum of risk scores by the total number of alerts
| eval Esql.risk_alerts_count_ratio = Esql.kibana_alert_risk_score_sum/Esql.alerts_count

// filter for risky hosts by risk score and unique count of rules and tactics
| where Esql.kibana_alert_rule_name_distinct_count >= 5 and Esql.threat_tactic_id_distinct_count >= 3 and Esql.threat_tactic_id_distinct_count >= 3 and Esql.alerts_count <= 500 and Esql.risk_alerts_count_ratio >= 50

// fiels populated in the resulting alert
| keep host.id,
       Esql.alerts_count,
       Esql.kibana_alert_risk_score_sum,
       Esql.risk_alerts_count_ratio,
       Esql.kibana_alert_rule_name_distinct_count,
       Esql.event_module_values,
       Esql.kibana_alert_rule_name_values,
       Esql.threat_tactic_name_values,
       Esql.process_executable_values,
       Esql.process_parent_executable_values,
       Esql.process_command_line_values
```