﻿---
title: Multiple Alerts Involving a User
description: This rule uses alert data to determine when multiple different alerts involving the same user are triggered. Analysts can use this to prioritize triage...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/cross-platform/multiple_alerts_involving_user
products:
  - Elastic Security
---

# Multiple Alerts Involving a User
This rule uses alert data to determine when multiple different alerts involving the same user are triggered. Analysts
can use this to prioritize triage and response, as these users are more likely to be compromised.
**Rule type**: esql
**Rule indices**:
**Rule Severity**: high
**Risk Score**: 73
**Runs every**: 1h
**Searches indices from**: `now-4h`
**Maximum alerts per execution**: 100
**References**:
**Tags**:
- Use Case: Threat Detection
- Rule Type: Higher-Order Rule
- Resources: Investigation Guide

**Version**: 5
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Investigation guide


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating Multiple Alerts Involving a User

In security environments, monitoring user activity is crucial as adversaries often exploit user accounts to gain unauthorized access. Attackers may trigger multiple alerts by performing suspicious actions under a compromised user account. The detection rule identifies such patterns by correlating diverse alerts linked to the same user, excluding known system accounts, thus prioritizing potential threats for analysts.

### Possible investigation steps

- Review the alert details to identify the specific user account involved, focusing on the user.name field to gather initial context about the user.
- Examine the timeline and sequence of the triggered alerts to understand the pattern of activity associated with the user, noting any unusual or unexpected actions.
- Cross-reference the user activity with known legitimate activities or scheduled tasks to rule out false positives, ensuring that the actions are not part of normal operations.
- Investigate the source and destination IP addresses associated with the alerts to identify any suspicious or unauthorized access points.
- Check for any recent changes in user permissions or group memberships that could indicate privilege escalation attempts.
- Look into any recent login attempts or authentication failures for the user account to detect potential brute force or credential stuffing attacks.
- Collaborate with the user or their manager to verify if the activities were authorized or if the account might be compromised.


### False positive analysis

- Alerts triggered by automated system processes or scripts that mimic user behavior can be false positives. To manage these, identify and exclude known benign scripts or processes from the rule.
- Frequent alerts from users in roles that inherently require access to multiple systems or sensitive data, such as IT administrators, may not indicate compromise. Implement role-based exceptions to reduce noise.
- Alerts generated by legitimate software updates or maintenance activities can be mistaken for suspicious behavior. Schedule these activities during known maintenance windows and exclude them from the rule during these times.
- Users involved in testing or development environments may trigger multiple alerts due to their work nature. Create exceptions for these environments to prevent unnecessary alerts.
- High-volume users, such as those in customer support or sales, may naturally generate more alerts. Monitor these users separately and adjust the rule to focus on unusual patterns rather than volume alone.


### Response and remediation

- Isolate the affected user account immediately to prevent further unauthorized access. Disable the account or change the password to stop any ongoing malicious activity.
- Conduct a thorough review of the affected user's recent activities and access logs to identify any unauthorized actions or data access. This will help in understanding the scope of the compromise.
- Remove any malicious software or unauthorized tools that may have been installed on the user's system. Use endpoint detection and response (EDR) tools to scan and clean the system.
- Restore any altered or deleted data from backups, ensuring that the restored data is free from any malicious modifications.
- Notify relevant stakeholders, including IT security teams and management, about the incident and the steps being taken to address it. This ensures that everyone is aware and can provide support if needed.
- Implement additional monitoring on the affected user account and related systems to detect any further suspicious activities. This includes setting up alerts for unusual login attempts or data access patterns.
- Review and update access controls and permissions for the affected user and similar accounts to prevent future incidents. Ensure that least privilege principles are applied.


## Rule Query

```esql
from .alerts-security.*
| where kibana.alert.rule.name is not null and user.id is not null and
  // Exclude low severity alerts
  kibana.alert.risk_score > 21
| stats
    Esql.rule_name_distinct_count = COUNT_DISTINCT(kibana.alert.rule.name), 
    Esql.rule_id_distinct_count = COUNT_DISTINCT(kibana.alert.rule.rule_id),
    Esql.host_id_distinct_count = COUNT_DISTINCT(host.id),
    Esql.risk_score_distinct_count = COUNT_DISTINCT(kibana.alert.risk_score),
    Esql.event_dataset_distinct_count = COUNT_DISTINCT(event.dataset),
    Esql.rule_name_values = VALUES(kibana.alert.rule.name), 
    Esql.risk_score_values = VALUES(kibana.alert.risk_score), 
    Esql.event_dataset_values = VALUES(event.dataset), 
    Esql.event_module_values = VALUES(event.module), 
    Esql.process_command_line = VALUES(process.command_line), 
    Esql.host_id_values = VALUES(host.id), 
    Esql.source_ip_values = VALUES(source.ip), 
    Esql.destination_ip_values = VALUES(destination.ip) by user.id

| where Esql.rule_name_distinct_count >= 4 AND Esql.rule_id_distinct_count >= 2 and
  // Exclude known system accounts with matches in more than one host
  not (
    (length(TO_STRING(user.id)) <= 4 or user.id IN ("S-1-5-18", "S-1-5-19", "S-1-5-20", "0")) and
    (Esql.host_id_distinct_count >= 2 or Esql.host_id_distinct_count == 0)
  )

| keep user.id, Esql.*
```