﻿---
title: Alerts From Multiple Integrations by User Name
description: This rule uses alert data to determine when multiple alerts from different integrations with unique event categories and involving the same user.name...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/cross-platform/multiple_alerts_from_different_modules_by_user
products:
  - Elastic Security
---

# Alerts From Multiple Integrations by User Name
This rule uses alert data to determine when multiple alerts from different integrations with unique event categories and
involving the same user.name are triggered. Analysts can use this to prioritize triage and response, as these users are
more likely to be compromised.
**Rule type**: esql
**Rule indices**:
**Rule Severity**: high
**Risk Score**: 73
**Runs every**: 30m
**Searches indices from**: `now-60m`
**Maximum alerts per execution**: 100
**References**:
**Tags**:
- Use Case: Threat Detection
- Rule Type: Higher-Order Rule
- Resources: Investigation Guide

**Version**: 1
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Investigation guide


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating Alerts From Multiple Integrations by User Name

The detection rule uses alert data to determine when multiple alerts from different integrations involving the same user.name are triggered.

### Possible investigation steps

- Review the alert details to identify the specific user involved and the different modules and rules that triggered the alert.
- Examine the timeline of the alerts to understand the sequence of events and determine if there is a pattern or progression in the tactics used.
- Correlate the alert data with other logs and telemetry from the host, such as process creation, network connections, and file modifications, to gather additional context.
- Investigate any known vulnerabilities or misconfigurations on the host that could have been exploited by the adversary.
- Check for any indicators of compromise (IOCs) associated with the alerts, such as suspicious IP addresses, domains, or file hashes, and search for these across the network.
- Assess the impact and scope of the potential compromise by determining if other hosts or systems have similar alerts or related activity.


### False positive analysis

- Alerts from routine administrative tasks may trigger multiple tactics. Review and exclude known benign activities such as scheduled software updates or system maintenance.
- Security tools running on the host might generate alerts across different tactics. Identify and exclude alerts from trusted security applications to reduce noise.
- Automated scripts or batch processes can mimic adversarial behavior. Analyze and whitelist these processes if they are verified as non-threatening.
- Frequent alerts from development or testing environments can be misleading. Consider excluding these environments from the rule or applying a different risk score.
- User behavior anomalies, such as accessing multiple systems or applications, might trigger alerts. Implement user behavior baselines to differentiate between normal and suspicious activities.


### Response and remediation

- Isolate the affected host from the network immediately to prevent further lateral movement by the adversary.
- Conduct a thorough forensic analysis of the host to identify the specific vulnerabilities exploited and gather evidence of the attack phases involved.
- Remove any identified malicious software or unauthorized access tools from the host, ensuring all persistence mechanisms are eradicated.
- Apply security patches and updates to the host to address any exploited vulnerabilities and prevent similar attacks.
- Restore the host from a known good backup if necessary, ensuring that the backup is free from compromise.
- Monitor the host and network for any signs of re-infection or further suspicious activity, using enhanced logging and alerting based on the identified attack patterns.
- Escalate the incident to the appropriate internal or external cybersecurity teams for further investigation and potential legal action if the attack is part of a larger campaign.


## Rule Query

```esql
from .alerts-security.*

// any alerts excluding low severity and the noisy ones
| where kibana.alert.rule.name is not null and user.name is not null and kibana.alert.risk_score > 21 and
        not kibana.alert.rule.type in ("threat_match", "machine_learning") and 
        not user.id in ("S-1-5-18", "S-1-5-19", "S-1-5-20", "0")

// group alerts by user.name and extract values of interest for alert triage
| stats Esql.event_module_distinct_count = COUNT_DISTINCT(event.module),
        Esql.rule_name_distinct_count = COUNT_DISTINCT(kibana.alert.rule.name),
        Esql.event_category_distinct_count = COUNT_DISTINCT(event.category),
        Esql.rule_risk_score_distinct_count = COUNT_DISTINCT(kibana.alert.risk_score),
        Esql.event_module_values = VALUES(event.module),
        Esql.rule_name_values = VALUES(kibana.alert.rule.name),
        Esql.message_values = VALUES(message),
        Esql.event_category_values = VALUES(event.category),
        Esql.event_action_values = VALUES(event.action),
        Esql.source_ip_values = VALUES(source.ip),
        Esql.destination_ip_values = VALUES(destination.ip),
        Esql.host_id_values = VALUES(host.id),
        Esql.agent_id_values = VALUES(agent.id),
        Esql.rule_severity_values = VALUES(kibana.alert.risk_score) by user.name, user.id

// filter for alerts from same destination.ip reported by different integrations with unique categories and with different severity levels
| where Esql.event_module_distinct_count >= 2 and Esql.event_category_distinct_count >= 2 and (Esql.rule_risk_score_distinct_count >= 2 or Esql.rule_severity_values == 73 or Esql.rule_severity_values == 99)
| keep user.name, Esql.*
```